#include "functions/util.function"
#SHADER_DEFINE DirfinalVertex

	FUNCTION_INPUT = 
	{
		{ ATTRIBUTE_POSITION, 			HIGH,	VEC4,		"in_Position" },
		{ ATTRIBUTE_COORDNATE0, 		HIGH,	VEC2,		"in_TexCoordinate"},
       
	}
	FUNCTION_OUTPUT =
	{
        { ATTRIBUTE_COORDNATE0,			HIGH,	VEC2,		"out_TexCooridate" },
	}

#SHADER_CODE
    gl_Position = in_Position;  
    vec2 out_TexCooridate;
    out_TexCooridate= in_TexCoordinate.xy;     // upper left corner
 
#END_CODE

#END_DEFINE


#SHADER_DEFINE DirfinalFragment

	FUNCTION_INPUT = 
	{
        { TEXTURE_uDab,		    	NONE,	TEXTURE2D,	  "uDab" },
        { ATTRIBUTE_COORDNATE0,		HIGH,	VEC2,	"vUV"},
		{ UNIFORM_uOs,				HIGH,	VEC2,	"uOs"},
		{ UNIFORM_uHiu,            	MEDIUM, FLOAT,   "uHiu"},
        { UNIFORM_uVer,            MEDIUM, FLOAT,   "uVer"}
	}
  
#SHADER_CODE

    float k = gauss(0.0, uHiu);
    float sum = k;
    vec4 fvb = texture2D(uDab, vUV);
    highp vec3 result;
    //if (abs(uVer - 2.0) < 0.0001) {
        result = vec3(decode(fvb), 0.0) * k;
    //}
    //else {
    //    result = fvb.xyz * k;
    //}

    for (int i = 1; i <= 3; ++i) {
        k = gauss(float(i), uHiu);
        sum += k + k;
        vec2 offset = vec2(0.0, uOs.y * float(i));

        vec4 xd0 = texture2D(uDab, vUV + offset);
        vec4 xd1 = texture2D(uDab, vUV - offset);
        //if (abs(uVer - 2.0) < 0.0001) {
            result += vec3(decode(xd0), 0.0) * k;
            result += vec3(decode(xd1), 0.0) * k;
        //}
        //else {
        //    result += xd0.xyz * k;
        //    result += xd1.xyz * k;
        //}
    }
    result /= sum;

    //if (abs(uVer - 2.0) < 0.0001) {
        gl_FragColor = encode(result.xy);
    //}
    //else {
    //    float kedc = ( result.x + result.z + sqrt(fsqr(result.x - result.z) + 4. * result.y * result.y) ) / 2.;
    //    vec2 v1 = vec2(kedc - result.x, -result.y);
    //    v1 = length(v1) > 0.0 ? normalize(v1) : vec2(0., 1.);
    //    gl_FragColor = vec4(v1, 0., 0.);
    //}
    // gl_FragColor.rgb = result;
#END_CODE

#END_DEFINE
