#include "functions/warp.function"

#SHADER_DEFINE BiggerEyesVertex

    FUNCTION_INPUT =
    {
        { ATTRIBUTE_POSITION,      HIGH,    VEC4,       "in_Position" },
        { ATTRIBUTE_COORDNATE0,    HIGH,    VEC2,       "in_TexCooridate"},
        { UNIFORM_FACESNUM,       MEDIUM,    FLOAT,        "facesNum"},
        { UNIFORM_LEFT_EYE,         HIGH,    VEC2_ARRAY,   "leftEyeCenterPosition", "3" },
        { UNIFORM_RIGHT_EYE,        HIGH,    VEC2_ARRAY,   "rightEyeCenterPosition", "3"},
        { UNIFORM_RADIUS,           HIGH,    VEC2_ARRAY,   "radius", "3"},
        { UNIFORM_RATIOASPECT,    MEDIUM,    FLOAT,        "aspectRatio"},
        { UNIFORM_NOSE,             HIGH,    VEC2_ARRAY,   "nose", "21"},
        { UNIFORM_MOUSE,            HIGH,    VEC2_ARRAY,   "mouse", "51"},
        { UNIFORM_CHIN,           MEDIUM,    VEC2_ARRAY,   "chin", "3"},
        { UNIFORM_LEFT_PTS,         HIGH,    VEC2_ARRAY,   "leftContourPoints", "48"},
        { UNIFORM_RIGHT_PTS,        HIGH,    VEC2_ARRAY,   "rightContourPoints", "48"},
        { UNIFORM_FACECOEF,       MEDIUM,    FLOAT,        "faceCoef"},
        { UNIFORM_CHINCOEF,       MEDIUM,    FLOAT,        "chinCoef"},
        { UNIFORM_FACES_BOX,        HIGH,    VEC4_ARRAY,   "facesBox", "3"},
        { FACEONEPARA,              HIGH,    VEC2_ARRAY,   "face1para", "9"},
        { FACETWOPARA,              HIGH,    VEC2_ARRAY,   "face2para", "7"},
        { MOUSEPARA,                HIGH,    VEC2_ARRAY,   "mousepara", "15"},
        { UNIFORM_SCALERATIO,     MEDIUM,    FLOAT,         "scaleRatio"},
    }
    FUNCTION_OUTPUT =
    {
        { ATTRIBUTE_COORDNATE0,    HIGH,    VEC2,       "out_TexCooridate" },
    }

#SHADER_CODE
    gl_Position = in_Position;
    
    const int halfFaceNum = 9;
    const int halfChinNum = 7;
    vec2 positionToUse  = in_TexCooridate * 2.0 - 1.0;
    int num = int(facesNum);
    for(int i = 0; i < num; ++i)
    {
        //if pixel not in face bounding box
        if(positionToUse.x < facesBox[i].x || // x < x_min
          positionToUse.x > facesBox[i].y || // x > x_max
          positionToUse.y < facesBox[i].z || // y < y_min
          positionToUse.y > facesBox[i].w)   // y > y_max
        {
          continue;
        }

        //眼睛
        positionToUse = scaleWarpPositionToUse(leftEyeCenterPosition[i],  positionToUse, radius[i].x, 0.7*scaleRatio, aspectRatio);
        positionToUse = scaleWarpPositionToUse(rightEyeCenterPosition[i], positionToUse, radius[i].y, 0.7*scaleRatio, aspectRatio);

        vec2 center = nose[i*7+6];
        int k = i * (halfFaceNum + halfChinNum);

        //颧骨至脸颊
        //face1radius  0.3744
        //face1scale[j]   0.018  0.0216 0.0252 0.0216 0.0216 0.0216 0.0216 0.0216 0.0216
        for(int j = 0; j < halfFaceNum; ++j, ++k)
        {
            positionToUse = transformWarpPositionToUseByFactor(positionToUse, leftContourPoints[k],  center, face1para[j].x, face1para[j].y* faceCoef , aspectRatio);
            positionToUse = transformWarpPositionToUseByFactor(positionToUse, rightContourPoints[k], center, face1para[j].x, face1para[j].y* faceCoef , aspectRatio);
        }

        //脸颊到下巴
        //face2radius[j]  0.3708 0.36 0.342 0.36 0.3708 ||0.432 0.432
        //face2scale[j]   0.01854 0.018 0.0171 0.0171 0.01836 ||0.022248(0.0216) 0.022248(0.0216)
        //9~13
        for(int j = 0; j < halfChinNum;j++,k++){
           positionToUse = transformWarpPositionToUseByFactor(positionToUse, leftContourPoints[k], rightContourPoints[k-8], face2para[j].x, face2para[j].y* chinCoef*1.1, aspectRatio);
           positionToUse = transformWarpPositionToUseByFactor(positionToUse, rightContourPoints[k], leftContourPoints[k-8], face2para[j].x, face2para[j].y* chinCoef*1.1, aspectRatio);
           //positionToUse = transformWarpPositionToUseByFactor(positionToUse, leftContourPoints[k], center, face2para[j].x , face2para[j].y* chinCoef, aspectRatio);
           //positionToUse = transformWarpPositionToUseByFactor(positionToUse, rightContourPoints[k], center, face2para[j].x , face2para[j].y* chinCoef, aspectRatio);
        }

        //下巴
        positionToUse = transformWarpPositionToUseByFactor(positionToUse, chin[i], center,  0.396 *1.5, 0.0198* chinCoef*1.2, aspectRatio);

        //鼻子
        float d3 = distance(nose[i*7+3], nose[i*7+4]);
        vec2 center2 = vec2(center.x,center.y*1.05);
        //positionToUse = transformWarpPositionToUse(positionToUse, nose[i*7], center2, 0.72* d3, 0.036 * d3 * faceCoef, aspectRatio);
        positionToUse = transformWarpPositionToUse(positionToUse, nose[i*7+1], nose[i*7+2], 0.72* d3, 0.054 * d3 * faceCoef, aspectRatio);
        positionToUse = transformWarpPositionToUse(positionToUse, nose[i*7+2], nose[i*7+1], 0.72* d3 , 0.054 * d3 * faceCoef, aspectRatio);
        positionToUse = transformWarpPositionToUse(positionToUse, nose[i*7+3], nose[i*7+4], 0.72* d3, 0.054 * d3 * faceCoef, aspectRatio);
        positionToUse = transformWarpPositionToUse(positionToUse, nose[i*7+4], nose[i*7+3], 0.72* d3, 0.054 * d3 * faceCoef, aspectRatio);
        //positionToUse = transformWarpPositionToUse(positionToUse, nose[i*7+5], center2, 0.72 * d3 , 0.018 * d3 * faceCoef, aspectRatio);

        //嘴
        vec2 center3 = nose[i*7];
        //positionToUse = transformWarpPositionToUseByFactor(positionToUse, mouse[i*20],   rightEyeCenterPosition[i], 0.165, 0.0228*faceCoef,aspectRatio);
        //positionToUse = transformWarpPositionToUseByFactor(positionToUse, mouse[i*20 + 1], leftEyeCenterPosition[i], 0.165, 0.0228*faceCoef,aspectRatio);
        //mouse1radius[15] 0.6 0.6 0.6 0.6 0.6 0.6 0.6 0.6 0.6 0.6 0.66 0.66 0.66 0.66 0.66
        //mouse1scale[15]  0.0114  0.0252 0.0252 0.0252 0.0114 0.036 0.0372 0.0372 0.0372 0.036 0.0228 0.0228 0.0228 0.0228 0.0228
        //for(int j=2;j<17;j++){
            //positionToUse = transformWarpPositionToUseByFactor(positionToUse, mouse[i*20 + j],  center3, mousepara[j-2].x , mousepara[j-2].y*faceCoef, aspectRatio);
        //}

    }
    vec2 out_TexCooridate =  0.5 * positionToUse + 0.5;
    //vec2 out_TexCooridate = in_TexCooridate;
#END_CODE
#END_DEFINE



#SHADER_DEFINE BiggerEyesFragment

    FUNCTION_INPUT =
    {
        { TEXTURE_DIFFUSE,          NONE,    TEXTURE2D,   "inputImageTexture" },
        { ATTRIBUTE_COORDNATE0,     HIGH,    VEC2,         "textureCoordinate"},

    }

#SHADER_CODE

    gl_FragColor = texture2D(inputImageTexture,vec2(clamp(textureCoordinate.x,0.001,0.999),clamp(textureCoordinate.y,0.001,0.999)));


#END_CODE
#END_DEFINE



#SHADER_DEFINE NewBiggerEyesVertex

    FUNCTION_INPUT =
    {
        { ATTRIBUTE_POSITION,       HIGH,    VEC4,         "in_Position"},
        { ATTRIBUTE_COORDNATE0,     HIGH,    VEC2,         "in_TexCooridate"},
        { UNIFORM_LEFT_EYE,         HIGH,    VEC2,         "leftEyeCenterPosition"},
        { UNIFORM_RIGHT_EYE,        HIGH,    VEC2,         "rightEyeCenterPosition"},
        { UNIFORM_RADIUS,           HIGH,    VEC2,         "radius"},
        { UNIFORM_RATIOASPECT,    MEDIUM,    FLOAT,        "aspectRatio"},
        { UNIFORM_NOSE,             HIGH,    VEC2_ARRAY,   "nose", "7"},
        { UNIFORM_MOUSE,            HIGH,    VEC2_ARRAY,   "mouse", "17"},
        { UNIFORM_CHIN,           MEDIUM,    VEC2,         "chin"},
        { UNIFORM_LEFT_PTS,         HIGH,    VEC2_ARRAY,   "leftContourPoints", "16"},
        { UNIFORM_RIGHT_PTS,        HIGH,    VEC2_ARRAY,   "rightContourPoints", "16"},
        { UNIFORM_FACECOEF,       MEDIUM,    FLOAT,        "faceCoef"},
        { UNIFORM_CHINCOEF,       MEDIUM,    FLOAT,        "chinCoef"},
        { FACEONEPARA,              HIGH,    VEC2_ARRAY,   "face1para", "9"},
        { FACETWOPARA,              HIGH,    VEC2_ARRAY,   "face2para", "7"},
        { MOUSEPARA,                HIGH,    VEC2_ARRAY,   "mousepara", "15"},
        { UNIFORM_SCALERATIO,     MEDIUM,    FLOAT,        "scaleRatio"},
        { UNIFORM_ZOOMSCALE,      MEDIUM,    MAT3,         "zoomscale"},
        
    }
    FUNCTION_OUTPUT =
    {
        { ATTRIBUTE_COORDNATE0,    HIGH,    VEC2,       "out_TexCooridate" },
    }

#SHADER_CODE

    vec2 newpos = (vec3(in_Position.xy,1.0)*zoomscale).xy;
    gl_Position = vec4(newpos,in_Position.z,in_Position.a);
    
    vec2 newTexCooridate = vec2((newpos.x+1.0)*0.5,(newpos.y+1.0)*0.5);
    const int halfFaceNum = 9;
    const int halfChinNum = 7;
    vec2 positionToUse  = newTexCooridate * 2.0 - 1.0;

    //眼睛
    positionToUse = scaleWarpPositionToUse(leftEyeCenterPosition,  positionToUse, radius.x, 0.7*scaleRatio, aspectRatio);
    positionToUse = scaleWarpPositionToUse(rightEyeCenterPosition, positionToUse, radius.y, 0.7*scaleRatio, aspectRatio);

    vec2 center = nose[6];
    int k = 0;

    //颧骨至脸颊
    //face1radius  0.3744
    //face1scale[j]   0.018  0.0216 0.0252 0.0216 0.0216 0.0216 0.0216 0.0216 0.0216
    for(int j = 0; j < halfFaceNum; ++j, ++k){
        positionToUse = transformWarpPositionToUseByFactor(positionToUse, leftContourPoints[k],  center, face1para[j].x, face1para[j].y* faceCoef , aspectRatio);
        positionToUse = transformWarpPositionToUseByFactor(positionToUse, rightContourPoints[k], center, face1para[j].x, face1para[j].y* faceCoef , aspectRatio);
    }

    //脸颊到下巴
    //face2radius[j]  0.3708 0.36 0.342 0.36 0.3708 ||0.432 0.432
    //face2scale[j]   0.01854 0.018 0.0171 0.0171 0.01836 ||0.022248(0.0216) 0.022248(0.0216)
    //9~13
    for(int j = 0; j < halfChinNum;j++,k++){
      positionToUse = transformWarpPositionToUseByFactor(positionToUse, leftContourPoints[k], rightContourPoints[k-8], face2para[j].x, face2para[j].y* chinCoef*1.1, aspectRatio);
      positionToUse = transformWarpPositionToUseByFactor(positionToUse, rightContourPoints[k], leftContourPoints[k-8], face2para[j].x, face2para[j].y* chinCoef*1.1, aspectRatio);
    }

    //下巴
    positionToUse = transformWarpPositionToUseByFactor(positionToUse, chin, center,  0.396 *1.5, 0.0198* chinCoef*1.2, aspectRatio);

    //鼻子
    float d3 = distance(nose[3], nose[4])*3.0;
    vec2 center2 = vec2(center.x,center.y*1.05);

    positionToUse = transformWarpPositionToUseByFactor(positionToUse, nose[1], nose[2], 0.72* d3, 0.054 * d3 * faceCoef, aspectRatio);
    positionToUse = transformWarpPositionToUseByFactor(positionToUse, nose[2], nose[1], 0.72* d3 , 0.054 * d3 * faceCoef, aspectRatio);
    positionToUse = transformWarpPositionToUseByFactor(positionToUse, nose[3], nose[4], 0.72* d3, 0.054 * d3 * faceCoef, aspectRatio);
    positionToUse = transformWarpPositionToUseByFactor(positionToUse, nose[4], nose[3], 0.72* d3, 0.054 * d3 * faceCoef, aspectRatio);

    vec2 out_TexCooridate =  0.5 * positionToUse + 0.5;
    //out_TexCooridate = vec2(out_TexCooridate.x, out_TexCooridate.y);
#END_CODE
#END_DEFINE



#SHADER_DEFINE NewBiggerEyesFragment

    FUNCTION_INPUT =
    {
        { TEXTURE_DIFFUSE,          NONE,    TEXTURE2D,   "inputImageTexture" },
        { ATTRIBUTE_COORDNATE0,     HIGH,    VEC2,         "textureCoordinate"},

    }

#SHADER_CODE
    gl_FragColor = texture2D(inputImageTexture,vec2(clamp(textureCoordinate.x,0.001,0.999),clamp(textureCoordinate.y,0.001,0.999)));
#END_CODE
#END_DEFINE
