#include "functions/utils.function"

#SHADER_DEFINE MouthVertex
    FUNCTION_INPUT =
	{
		{ ATTRIBUTE_POSITION, 			HIGH,	       VEC4,		"cpuPosition" },
		{ ATTRIBUTE_COORDNATE0, 		HIGH,	       VEC2,		"cpuTexCoord"},
    { ATTRIBUTE_NORMAL, 		HIGH,	       VEC3,		"cpuNormal"},
    { ATTRIBUTE_TANGENT, 			HIGH,	       VEC4,		"cpuTangent" },
    { PROJECTION,       HIGH,         MAT4, "projectionMatrix"},
    { MODELVIEW,       HIGH,        MAT4,     "modelViewMatrix"},
    { INVMODELVIEW,       HIGH,        MAT4,     "trans_inv_modelViewMatrix"},
	}

	FUNCTION_OUTPUT =
	{
		{ ATTRIBUTE_COORDNATE0,			HIGH,	       VEC2,		"vtxTexCoord" },
    { ATTRIBUTE_COORDNATE1,			HIGH,	       VEC3,		"vtxPositionInCam" },
    { ATTRIBUTE_NORMAL,			HIGH,	       VEC3,		"vtxNormal" },
    { ATTRIBUTE_COORDNATE3,			HIGH,	       MAT3,		"vtxTBN" },
    { ATTRIBUTE_COLOR0,			HIGH,	       FLOAT,		"vtxClippedZ" }
	}

#SHADER_CODE
vec4 _vtxPositionInCam = modelViewMatrix * cpuPosition;
gl_Position = projectionMatrix * _vtxPositionInCam;

vec3 vtxPositionInCam = _vtxPositionInCam.xyz;
vec3 vtxNormal = normalize((trans_inv_modelViewMatrix * vec4(cpuNormal, 0.0)).xyz);
vec2 vtxTexCoord = cpuTexCoord;

// construct TBN matrix for normal map
vec3 T = normalize(vec3(trans_inv_modelViewMatrix * vec4(cpuTangent.xyz, 0.0)));
vec3 N = normalize(vec3(trans_inv_modelViewMatrix * vec4(cpuNormal, 0.0)));
// Gauss-Schmidt orthogonalization
T = normalize(T - dot(T, N) * N);
vec3 B = cross(N, T) * cpuTangent.w;
mat3 vtxTBN = mat3(T, B, N);

// most mouth depth will fall in range [min_z, max_z]
float min_z = 0.05;
float max_z = 0.25;
float clamped_z = clamp(gl_Position.z / gl_Position.w, min_z, max_z);

float vtxClippedZ = (clamped_z - min_z) / (max_z - min_z);
#END_CODE
#END_DEFINE

#SHADER_DEFINE MouthFragment
	FUNCTION_INPUT =
	{
    { ATTRIBUTE_COORDNATE0,			HIGH,	       VEC2,		"vtxTexCoord" },
    { ATTRIBUTE_COORDNATE1,			HIGH,	       VEC3,		"vtxPositionInCam" },
    { ATTRIBUTE_NORMAL,			HIGH,	       VEC3,		"vtxNormal" },
    { ATTRIBUTE_COORDNATE3,			HIGH,	       MAT3,		"vtxTBN" },
    { ATTRIBUTE_COLOR0,			HIGH,	       FLOAT,		"vtxClippedZ" },
    { TEXTURE_DIFFUSE,			NONE,	       TEXTURE2D,		"texture1" },
    { TEXTURE_BUMP,			NONE,	       TEXTURE2D,		"textureNormal" },
    { INVMODELVIEW,       HIGH,        MAT4,     "trans_inv_modelViewMatrix"},
    { ENABLETEXTURE,			HIGH,	       FLOAT,		"enableTexture" },
    { ENABLENORMAL,			HIGH,	       FLOAT,		"enableNormalMap" },
    { AMBIENT,			HIGH,	       VEC3,		"ambient" },
    { SPECULAR,			HIGH,	       VEC3,		"specular" },
    { EMISSION,			HIGH,	       VEC3,		"emission" },
    { DIFFUSE,			HIGH,	       VEC3,		"diffuse" },
    { SHININESS,			HIGH,	       FLOAT,		"shininess" },
    { LIGHTPOSN,			HIGH,	       VEC4,		"lightposn" },
    { LIGHTCOLOR,			HIGH,	       VEC4,		"lightcolor" }
	}

#SHADER_CODE
vec3 lightColor = ambient + emission;

// eye direction
vec3 eyeDir = normalize(-vtxPositionInCam);

vec3 normalDir;
if (enableNormalMap > 0.5)
{
	vec3 normal_sample = texture2D(textureNormal, vtxTexCoord).rgb;
  	normal_sample = normalize(normal_sample * 2.0 - 1.0);
	normal_sample = normalize(vtxTBN * normal_sample);
	normalDir = normal_sample;
}
else
{
	normalDir = vtxNormal;
}

// light direction
vec3 lightDir;
if(0.0 == lightposn.w)	// directional light
{
	lightDir = normalize(lightposn.xyz);
}
else
{
	vec3 lightPos = lightposn.xyz / lightposn.w;
	lightDir = normalize(lightPos - vtxPositionInCam);
}

vec3 halfVec = normalize(eyeDir + lightDir);
vec3 color = ComputeLight(lightcolor.rgb, normalDir, lightDir, halfVec, diffuse, specular, shininess);
float depthLightIntensity = clamp(-log(vtxClippedZ), 0.0, 1.0);
lightColor += depthLightIntensity * color * lightcolor.a;

if (enableTexture > 0.5)
{
	gl_FragColor = vec4(lightColor * texture2D(texture1, vtxTexCoord).rgb, 1.0);
      //gl_FragColor = texture2D(texture1, vtxTexCoord);
}
else
{
      gl_FragColor = vec4(lightColor, 1.0);
}
#END_CODE
#END_DEFINE
