#include "functions/utils.function"

#SHADER_DEFINE PortraitVertex
    FUNCTION_INPUT =
    {
        { ATTRIBUTE_POSITION,           HIGH,           VEC3,       "cpuPosition" },
        { ATTRIBUTE_COORDNATE0,         HIGH,           VEC3,       "cpuOrigPosition" },
        { ATTRIBUTE_COORDNATE1,         HIGH,           VEC2,       "cpuTexCoord"},
        { ATTRIBUTE_COLOR0,             HIGH,           FLOAT,      "enableModelViewTransformation" },
        { PROJECTION,                   HIGH,           MAT4,       "projectionMatrix"},
        { MODELVIEW,                    HIGH,           MAT4,       "modelViewMatrix"},
        { MIXED,                        HIGH,           FLOAT,      "mixedTransformation"}
    }   
    
    FUNCTION_OUTPUT =   
    {   
        { ATTRIBUTE_COORDNATE0,         HIGH,          VEC3,        "vtxOrigCoord" },
        { ATTRIBUTE_COORDNATE1,         HIGH,          VEC2,        "vtxTexCoord" },
        { ATTRIBUTE_COORDNATE2,         HIGH,          VEC3,        "vtxCurCoord" }
    }

#SHADER_CODE
if (mixedTransformation > 0.5)  // for vertices containing both 3D vertices and image boundaries
{
  if (enableModelViewTransformation > 0.5)
  {
    gl_Position = projectionMatrix * modelViewMatrix * vec4(cpuPosition, 1.0);  // for valid feature points
  }
  else
  {
    gl_Position = projectionMatrix * vec4(cpuPosition, 1.0);
  }
}
else    // for normal 3D vertices
{
  gl_Position = projectionMatrix * modelViewMatrix * vec4(cpuPosition, 1.0);    // for valid feature points
}

vec2 vtxTexCoord = cpuTexCoord;
vec3 vtxOrigCoord = cpuOrigPosition;
vec3 vtxCurCoord = cpuPosition;
#END_CODE
#END_DEFINE

#SHADER_DEFINE PortraitFragment
    FUNCTION_INPUT =
    {
        { ATTRIBUTE_COORDNATE1,         HIGH,            VEC2,              "vtxTexCoord" },
        { ATTRIBUTE_COORDNATE0,         HIGH,            VEC3,              "vtxOrigCoord" },
        { ATTRIBUTE_COORDNATE2,         HIGH,            VEC3,              "vtxCurCoord" },
        { TEXTURE_DIFFUSE,              NONE,            TEXTURE2D,         "textureImage" },  
        { ORIGIN_FOREHEAD_CENTER,       HIGH,            VEC3_ARRAY,        "origForeheadCenter", 2 },
        { CUR_FOREHEAD_CENTER,          HIGH,            VEC3_ARRAY,        "curForeheadCenter", 2 },
        { ORIGIN_LMOUTH_CORNER,         HIGH,            VEC3_ARRAY,        "origLMouthCorner", 2 },
        { CUR_LMOUTH_CORNER,            HIGH,            VEC3_ARRAY,        "curLMouthCorner", 2 },
        { ORIGIN_RMOUTH_CORNER,         HIGH,            VEC3_ARRAY,        "origRMouthCorner", 2 },
        { CUR_RMOUTH_CORNER,            HIGH,            VEC3_ARRAY,        "curRMouthCorner", 2 },
        { ENABLE_WRINKLE,               HIGH,            FLOAT,             "enableWrinkle" },
        { TEXTURE_WRINKLE,              NONE,            TEXTURE2D,         "textureWrinkle" },
        { TEXTURE_FOREHEAD_MASK,        NONE,            TEXTURE2D,         "textureForeheadMask" },
        { TEXTURE_LDECREE_MASK,         NONE,            TEXTURE2D,         "textureLDecreeMask" },
        { TEXTURE_RDECREE_MASK,         NONE,            TEXTURE2D,         "textureRDecreeMask" },
        { FOREHEAD_FACTOR,              LOW,             FLOAT,             "in_forehead_factor" },
        { DECREE_FACTOR,                LOW,             FLOAT,             "in_decree_factor" },
    }

#SHADER_CODE
if (enableWrinkle > 0.5)
{
    vec4 img_color = texture2D(textureImage, vtxTexCoord);
    vec4 img_color_yuv = RGB2YUV(img_color);
    
    float isForeHeadRegion = texture2D(textureForeheadMask, vtxTexCoord).r;
    float isLDecreeRegion = texture2D(textureLDecreeMask, vtxTexCoord).r;
    float isRDecreeRegion = texture2D(textureRDecreeMask, vtxTexCoord).r;

    float cur_wrinkle_extent = 0.0;
    if (isForeHeadRegion > 0.5)
    {
        // get wrinkle extent according to distance change
        cur_wrinkle_extent = GetCurWrinkleExtent(
                                    curForeheadCenter[1], origForeheadCenter[1], 
                                    curForeheadCenter[0], origForeheadCenter[0],
                                    in_forehead_factor);                                     
    }
    else if (isLDecreeRegion > 0.5)
    {
        cur_wrinkle_extent = GetCurWrinkleExtent(
                                    curLMouthCorner[1], origLMouthCorner[1], 
                                    curLMouthCorner[0], origLMouthCorner[0], 
                                    in_decree_factor);
    }
    else if (isRDecreeRegion > 0.5)
    {
        cur_wrinkle_extent = GetCurWrinkleExtent(
                                    curRMouthCorner[1], origRMouthCorner[1], 
                                    curRMouthCorner[0], origRMouthCorner[0],
                                    in_decree_factor);
    }
    
    // wrinkle factor with full extent
    float full_idensity = texture2D(textureWrinkle, vtxTexCoord).r;
    
    // wrinkle factor with current extent
    float cur_wrinkle_factor = mix(1.0, full_idensity, cur_wrinkle_extent);    
    img_color_yuv.r *= cur_wrinkle_factor;

    // generate final color
    gl_FragColor = YUV2RGB(img_color_yuv);
    //gl_FragColor = vec4(cur_wrinkle_extent, cur_wrinkle_extent, cur_wrinkle_extent, 1.0);
}
else
{
    gl_FragColor = texture2D(textureImage, vtxTexCoord);
}

#END_CODE
#END_DEFINE
