#SHADER_DEFINE WarpPerspectiveVertex
    FUNCTION_INPUT = 
	{
		{ ATTRIBUTE_POSITION, 			HIGH,	       VEC2,		"in_Position" },
		{ ATTRIBUTE_COORDNATE0, 		HIGH,	       VEC2,		"in_TexCoord0"},
	}                                                  
                                                       
	FUNCTION_OUTPUT =                                  
	{                                                  
		{ ATTRIBUTE_COORDNATE0,			HIGH,	       VEC2,		"out_TexCoord0" },
	}                                                  
    
#SHADER_CODE
    vec2 out_TexCoord0 = vec2(in_TexCoord0.x, in_TexCoord0.y);
    gl_Position = vec4(in_Position, 0.0, 1.0);
#END_CODE
#END_DEFINE

#SHADER_DEFINE WarpPerspectiveFragment
	FUNCTION_INPUT = 
	{		
        { TEXTURE0,	                     NONE,	        TEXTURE2D,		"in_Tex0" },   
        { ATTRIBUTE_COORDNATE0,	         HIGH,	        VEC2,		    "in_TexCoord0"},
        { HOMOGRAPHYMAT,	             HIGH,	        MAT3,		    "in_HomographyMat"},
        { WIDTH,                         HIGH,          FLOAT,          "in_Width"},
        { HEIGHT,                        HIGH,          FLOAT,          "in_Height"},
	}
  
#SHADER_CODE
    // Texture coordinates will run [0,1],[0,1];
    // Convert to "real world" coordinates
    highp vec3 newCoordinate = vec3(in_TexCoord0.x * in_Width, in_TexCoord0.y * in_Height, 1.0);
    // Determine translated x and y coordinates
    highp vec3  ori = in_HomographyMat * newCoordinate;
    
     // Normalize back to [0,1],[0,1] space
    highp vec2 coords = vec2(ori.x / ori.z / in_Width, ori.y / ori.z / in_Height);
    gl_FragColor = texture2D(in_Tex0, coords);
#END_CODE
#END_DEFINE