#SHADER_DEFINE FaceMorphVertex
    FUNCTION_INPUT = 
	{
		{ ATTRIBUTE_POSITION, 			HIGH,	       VEC2,		"in_Position" },
		{ ATTRIBUTE_COORDNATE0, 		HIGH,	       VEC2,		"in_TexCoord0"},
        { ATTRIBUTE_COORDNATE1,         HIGH,          VEC2,        "in_TexCoord1"},
	}                                                  
                                                       
	FUNCTION_OUTPUT =                                  
	{                                                  
		{ ATTRIBUTE_COORDNATE0,			HIGH,	       VEC2,		"out_TexCoord0" },
        { ATTRIBUTE_COORDNATE1,			HIGH,	       VEC2,		"out_TexCoord1" },
	}                                                  
    
#SHADER_CODE
    vec2 out_TexCoord0 = in_TexCoord0;
    vec2 out_TexCoord1 = in_TexCoord1;
    gl_Position = vec4(in_Position, 0.0, 1.0);
#END_CODE
#END_DEFINE

#SHADER_DEFINE FaceMorphFragment
	FUNCTION_INPUT = 
	{		
        { TEXTURE0,	                     NONE,	        TEXTURE2D,		"in_Tex0" },
        { TEXTURE1,	                     NONE,	        TEXTURE2D,		"in_Tex1" },      
        { ATTRIBUTE_COORDNATE0,	         HIGH,	        VEC2,		    "in_TexCoord0"},
        { ATTRIBUTE_COORDNATE1,	         HIGH,	        VEC2,		    "in_TexCoord1"},
        { ALPHA,                         HIGH,          FLOAT,          "in_BlendFactor"},
	}
  
#SHADER_CODE
    vec4 inputColor0 = texture2D(in_Tex0, in_TexCoord0);
    vec4 inputColor1 = texture2D(in_Tex1, in_TexCoord1);
    gl_FragColor = mix(inputColor0, inputColor1, in_BlendFactor);     
#END_CODE
#END_DEFINE