//@author      : Zhu Fei
//@date        : 2019-06-26
//@description : shader to draw point sprite for line effect
//@version     : 1.0

///////////////// Point Sprite Version

#SHADER_DEFINE BlingSpriteVertex

    FUNCTION_INPUT = 
    {
        {ATTRIBUTE_POSITION,    HIGH, VEC2,  "in_pt_pos"}, //position of point sprite
        {ATTRIBUTE_COORDNATE0, HIGH, FLOAT, "in_pt_size"} //size of point sprite
    }
    FUNCTION_OUTPUT =
    {
        {ATTRIBUTE_COORDNATE1, HIGH, VEC2, "out_frame_tex_coord"} //texture coordinate of the point sprite center on background frame
    }


#SHADER_CODE
    gl_Position  = vec4(in_pt_pos, 0.0, 1.0);
    gl_PointSize = in_pt_size;
    vec2 out_frame_tex_coord = vec2(0.5 * (in_pt_pos.x + 1.0), 1.0 - 0.5 * (in_pt_pos.y + 1.0))
#END_CODE

#END_DEFINE

#SHADER_DEFINE BlingSpriteFragment

    FUNCTION_INPUT =
    {
        {ATTRIBUTE_COORDNATE1, HIGH, VEC2, "in_frame_tex_coord" },
        {POINT_TEXTURE,         NONE, TEXTURE2D, "in_pt_texture"},
        {FRAME_TEXTURE,         NONE, TEXTURE2D, "in_frame_texture"}
    }

#SHADER_CODE
    vec4 base_color   = texture2D(in_frame_texture, in_frame_tex_coord);
    vec4 sprite_color = texture2D(in_pt_texture, gl_PointCoord);
    gl_FragColor      = base_color * sprite_color; 
#END_CODE

#END_DEFINE

///////////////// Billboard Version

#SHADER_DEFINE BlingBillboardVertex

    FUNCTION_INPUT =
    {
        {ATTRIBUTE_POSITION,    HIGH, VEC2, "in_pos"},            //position of billboard vertex
        {ATTRIBUTE_COORDNATE0, HIGH, VEC2, "in_tex_coord"},      //texture coordinate of billboard vertex
        {ATTRIBUTE_COORDNATE1, HIGH, VEC2, "in_frame_tex_coord"} //texture coordinate of billboard center on background frame
    }
    FUNCTION_OUTPUT =
    {
        {ATTRIBUTE_COORDNATE0, HIGH, VEC2, "out_tex_coord"},
        {ATTRIBUTE_COORDNATE1, HIGH, VEC2, "out_frame_tex_coord"}
    }

#SHADER_CODE
    gl_Position              = vec4(in_pos, 0.0, 1.0);
    vec2 out_tex_coord       = in_tex_coord;
    vec2 out_frame_tex_coord = in_frame_tex_coord;
#END_CODE

#END_DEFINE

#SHADER_DEFINE BlingBillboardFragment

    FUNCTION_INPUT =
    {
        {ATTRIBUTE_COORDNATE0, HIGH, VEC2, "in_tex_coord"},
        {ATTRIBUTE_COORDNATE1, HIGH, VEC2, "in_frame_tex_coord"},
        {POINT_TEXTURE,         NONE, TEXTURE2D, "in_pt_texture"},
        {FRAME_TEXTURE,         NONE, TEXTURE2D, "in_frame_texture"}
    }

#SHADER_CODE
    vec4 base_color      = texture2D(in_frame_texture, in_frame_tex_coord);
    vec4 billboard_color = texture2D(in_pt_texture, in_tex_coord);
    gl_FragColor         = 1.2 * base_color * billboard_color;
#END_CODE

#END_DEFINE