



#SHADER_DEFINE MaskVideoVertex_Cutme

	FUNCTION_INPUT = 
	{
		{ ATTRIBUTE_POSITION, 		HIGH,	VEC4,	"in_Position" },
    { ATTRIBUTE_COORDNATE0,			MEDIUM,	VEC2,		"in_Coordinate" },
	}
	FUNCTION_OUTPUT =
	{
    { ATTRIBUTE_COORDNATE0,		MEDIUM,	VEC2,		"Out_Coordinate1" },
    { MASK_COORNIDATE,			  MEDIUM,	VEC2,		"Out_Coordinate2" },
	}

#SHADER_CODE	
    gl_Position = in_Position;
    mediump vec2 Out_Coordinate1 = in_Coordinate;
    mediump float x = (in_Position.x + 1.0) / 2.0;
    mediump float y = 1.0 - (in_Position.y + 1.0) / 2.0;
    mediump vec2 Out_Coordinate2 = vec2(x,y);
#END_CODE
#END_DEFINE


#SHADER_DEFINE MaskVideoFragment_Cutme

	FUNCTION_INPUT = 
	{
    { MASK_TEXTURE,       NONE, TEXTURE2D,   "in_MaskTexture" },
    { CUSTOM_TEXTURE,     NONE, TEXTURE2D,   "in_CustomTexture" },
		{ ATTRIBUTE_COORDNATE0,	MEDIUM,	VEC2,		"in_Coordinate1" },
    { MASK_COORNIDATE,			  MEDIUM,	VEC2,		"in_Coordinate2" },
    { MASK_CHANNEL,           MEDIUM, VEC3,   "in_ChannelMask"},
    { MASK_LOCATION,          HIGH, FLOAT,   "in_MaskLocation"},
    { TEXTURE_SIZE, MEDIUM, VEC2, "in_TextureSize"},
    
	}
  FUNCTION_OUTPUT =
  {
  }
#SHADER_CODE
  //因为base texture为了解决切分处的差值问题移动了一些像素，这里也要做相应的移动，否则base和mask会对应不上

  mediump float texSizeX = in_TextureSize.x;
  mediump float texSizeY = in_TextureSize.y;
    
  
  highp vec4 mask = texture2D(in_MaskTexture, vec2(in_Coordinate2.x, in_Coordinate2.y));
  highp vec4 custom = texture2D(in_CustomTexture, in_Coordinate1);
  //highp vec4 mask = texture2D(in_MaskTexture, vec2(in_Coordinate2.x,in_Coordinate2.y));
  float maskV = mask.b * in_ChannelMask.r + mask.g * in_ChannelMask.g + mask.r * in_ChannelMask.b;
  gl_FragColor = vec4(custom.xyz,maskV * custom.a);
  //gl_FragColor = vec4(custom.xyz,1.0);
  //gl_FragColor = vec4(mask.xyz,1.0);
  //gl_FragColor = vec4(1.0,0.0,0.0,1.0);
  //gl_FragColor = vec4(in_ChannelMask,1.0);
  //gl_FragColor = vec4(1.0,0.0,0.0,1.0);
#END_CODE
#END_DEFINE



#SHADER_DEFINE MaskVideoFragment_Version2_Cutme

	FUNCTION_INPUT = 
	{
    { MASK_TEXTURE,       NONE, TEXTURE2D,   "in_MaskTexture" },
    { CUSTOM_TEXTURE,     NONE, TEXTURE2D,   "in_CustomTexture" },
		{ ATTRIBUTE_COORDNATE0,	MEDIUM,	VEC2,		"in_Coordinate1" },
    { MASK_COORNIDATE,			  MEDIUM,	VEC2,		"in_Coordinate2" },
    { MASK_CHANNEL,           MEDIUM, VEC3,   "in_ChannelMask"},
    { MASK_LOCATION,          MEDIUM, FLOAT,   "in_MaskLocation"},

	}
  FUNCTION_OUTPUT =
  {
  }
#SHADER_CODE

  mediump vec4 custom = texture2D(in_CustomTexture, in_Coordinate1);
  mediump float maskTexCoordX = in_MaskLocation / 3.0 + in_Coordinate2.x / 3.0;
  mediump vec4 mask = texture2D(in_MaskTexture, vec2(maskTexCoordX,in_Coordinate2.y));
  mediump float maskV = mask.r;
  gl_FragColor = vec4(custom.xyz,maskV * custom.a);
  //gl_FragColor = vec4(custom.xyz,1.0);
  //gl_FragColor = vec4(mask.xyz,1.0);
  //gl_FragColor = vec4(1.0,0.0,0.0,1.0);
#END_CODE
#END_DEFINE


