function Disposable(amethodName, acallbackID) {
    var methodName;
    var callbackID;
    {
        methodName = amethodName;
        callbackID = acallbackID;
    }
    this.dispose = function() {
        bgo.streamHandlers[callbackID] = null;
        bgo_bridge.dispose(methodName, callbackID);
    };
}
var uniqueId = 0;
var bgo = {
    callbackHandlers: {},
    streamHandlers: {},
    invokeMethod: function(methodName, params, callback) {
        var callbackID = 'cb_' + (uniqueId++) + '_' + new Date().getTime();
        bgo.callbackHandlers[callbackID] = callback;
        bgo_bridge.invokeMethod(methodName, JSON.stringify(params), callbackID);
    },
    createStream: function(methodName, params, callback) {
        var callbackID = 'cs_' + (uniqueId++) + '_' + new Date().getTime();
        bgo.streamHandlers[callbackID] = callback;
        bgo_bridge.createStream(methodName, JSON.stringify(params), callbackID);
        return new Disposable(methodName, callbackID);
    },
    handleCallback: function(err, data, callbackID) {
        if (bgo.callbackHandlers[callbackID]) {
            bgo.callbackHandlers[callbackID](err, data);
        }
        if (bgo.streamHandlers[callbackID]) {
            bgo.streamHandlers[callbackID](err, data);
        }
    },
};