local filelfs = require "window.editor.widget.assets.fileutility"
local BR = require "bluecore.core.blue_rtti"
local AE = require "apolloengine"
local BD = require "bluecore.bluedefined"
local BU = require "bluecore.blueutility"
local vc = require "venuscore"
local BlueDebug = require "bluecore.debug.bluedebug"
local mathfunction = require "mathfunction"
local Types = require "venuscore.rtti.types"
 
local BlueUtilityEd = {};

BlueUtilityEd.EDITOR_DEBUG_ON = false ;

BlueUtilityEd.OnlyOneNodeMap = {
  ["_OnBeginPlay"] = true,
  ["_OnTick"] = true,
  ["_OnRecordStop"] = true,
  ["_OnRecordStart"] = true,
}



BlueUtilityEd.changedata = {};

function BlueUtilityEd:_RecursiveParseBlueprintClass(directory, prefabList, excludePrefabFile)
  for dir, pFile in pairs(prefabList) do
    if type(pFile) == 'table' then
      self:_RecursiveParseBlueprintClass(directory..dir.."/" , pFile, excludePrefabFile);
    else
      local prefabFullPath = directory..pFile
      if prefabFullPath ~= excludePrefabFile then
        local fullPath = directory..pFile..".meta"
        WARNING("register class from prefab path "..tostring(fullPath))
        local metaData = BU:LoadMetaFile(fullPath);
        ----TODO(hhl) prefab在共享时候,需要处理,多个prefab的classId可能一样的情况.
        if metaData then
          if metaData["clsId"] then
            local ClassInfo = require "bluecore.core.class_info"
            local BlueRtti = require "bluecore.core.blue_rtti"
            local clsInfo = ClassInfo();
            clsInfo:RegisterPrefab(metaData, fullPath)
            BlueRtti.RegisterBluePrintClassInfoEd(clsInfo);
          else
            LOG("prefab does NOT have blueprintClass");
          end
        else
          ERROR("prefab file exists, but prefab.meta file not exists "..fullPath);
        end
      else
        WARNING("_RecursiveParseBlueprintClass prefab file match excludePrefabFile, skip "..tostring(excludePrefabFile))
      end
    end
  end
end

--  一个是刚开编辑器选场景
--  一个是菜单里面打开场景
function BlueUtilityEd:RefreshPrefabBlueprintClass(scenefile, excludeFilePath)

  local parent = filelfs:GetParentDirectory(scenefile);
  local temp = string.split(parent, "/");
  --新素材 proj:assets/newscene/newscene.scene
  --防止老素材(proj:assets/stciker.scene)导入编辑器时错误扫描其他场景prefab
  if temp[#temp] == "assets" then
    WARNING("--------This is Old Sticker and No prefab Exists here--------")
    return;
  end

  WARNING("-------------------------------------")
  WARNING("---- RefreshPrefabBlueprintClass ----")
  WARNING("-------------------------------------")
  -- 清空旧场景的蓝图类信息
  ERROR("------------END oooo--------------------");
  BR.ClearClassEd();
  collectgarbage();
  ERROR("------------END xxxx--------------------");

  -- 读取新场景的prefab类信息
  local prefabFileList = filelfs:GetFilesInDir(parent, true, {"prefab"} );

  self:_RecursiveParseBlueprintClass(parent, prefabFileList, excludeFilePath);

  WARNING("-------------------------------------")
  WARNING("-------------------------------------")
end


-- 清空旧场景的蓝图类信息
function BlueUtilityEd:ClearBlueprintClass()
  BR.ClearClassEd();
end


-- 从target这个开始,根据indexContext索引到最终处理的target
function BlueUtilityEd:IndexContext(target, indexContext)
  if indexContext ~= nil then
    for _, ctx in ipairs(indexContext) do -- indexContext 必须是数组
      target = target[ctx];
      if target == nil then
        ERROR("fail to find key :"..ctx );
        ERROR("fail to find full:"..TableToStr(indexContext) );
        return nil
      end
    end
  end
  return target;
end

-- Prefab中不能修改全局函数
function BlueUtilityEd:PushBlueLibToPrefab()
  local EditorSystem = require "window.editor.system.editsystem"

  local sceneEdit = EditorSystem:GetEditScene()
  local rootNodeEdit = sceneEdit:GetRootNode();
  local rootBlueCompEdit = rootNodeEdit:GetComponent(AE.Node.CT_BLUEPRINT)
  if rootBlueCompEdit ~= nil then

    local blueSceneEdit = BU.GetIns(rootBlueCompEdit);

    if blueSceneEdit ~= nil then

      self.blueFtnLibMapInEditor = blueSceneEdit:GetLibs()

      local sceneGame = EditorSystem:GetGameScene()
      local rootNodeGame = sceneGame:GetRootNode()
      local rootBlueCompGame = rootNodeGame:GetComponent(AE.Node.CT_BLUEPRINT)
      local blueSceneGame = BU.GetIns(rootBlueCompGame);

      self.blueFtnLibMapInGame = blueSceneGame:GetLibs()

      -- 删除大场景的的引用列表 新场景还需要Awake
      for id, lib in pairs(self.blueFtnLibMapInGame) do
        lib:LeaveCurrentSceneEd(); -- 离开当前场景
      end

      for id, lib in pairs(self.blueFtnLibMapInGame) do
        lib:LeaveCurrentSceneEd();
      end

      return
    end

  end

  self.blueFtnLibMapInGame = nil
  self.blueFtnLibMapInEditor = nil
  WARNING("big scene do NOT has blue scene")
  -- 大场景没有函数库
end

function BlueUtilityEd:PopBlueLibFromPrefab()
  -- 如果prefab沒有场景蓝图 需要创建场景蓝图

  if self.blueFtnLibMapInEditor ~= nil then

    local EditorSystem = require "window.editor.system.editsystem"
    local CreateComponentCmd = require "window.editor.command.commands.node.create_component_command"
    local CommandManager = require "window.editor.command.command_manager"
    local AddBlueprintClassCmd = require "window.editor.command.commands.blueprintcomponent.add_blueprint_class_command"

    local scene = EditorSystem:GetEditScene()
    local rootNode = scene:GetRootNode();
    local rootBlueComp = rootNode:GetComponent(AE.Node.CT_BLUEPRINT)
    if rootBlueComp == nil then
      WARNING("-------------------------------------")
      WARNING("----create blueScene/level script!---")
      WARNING("-------------------------------------")
      local cmd2 = CreateComponentCmd(rootNode:GetContentPath(), AE.Node.CT_BLUEPRINT);
      CommandManager:DoIt(cmd2);
      rootBlueComp = rootNode:GetComponent(AE.Node.CT_BLUEPRINT)
      local cmd3 = AddBlueprintClassCmd(rootBlueComp:GetContentPath(), BD.ScenePath);
      CommandManager:DoIt(cmd3);
      WARNING("-------------------------------------")
      WARNING("--blueScene/level script setup done--")
      WARNING("-------------------------------------")
    end


    -- 直接拷贝函数库到prefab编辑器
    local sceneEdit = EditorSystem:GetEditScene()
    local rootNodeEdit = sceneEdit:GetRootNode();
    local rootBlueCompEdit = rootNodeEdit:GetComponent(AE.Node.CT_BLUEPRINT)
    local blueSceneEdit = BU.GetIns(rootBlueCompEdit);
    for id, lib in pairs(self.blueFtnLibMapInEditor) do
      lib:EnterNextSceneEd(rootNodeEdit); -- 离开当前场景
    end
    blueSceneEdit:SetLibsEd(self.blueFtnLibMapInEditor);
    self.blueFtnLibMapInEditor = nil

    local sceneGame = EditorSystem:GetGameScene()
    local rootNodeGame = sceneGame:GetRootNode()
    local rootBlueCompGame = rootNodeGame:GetComponent(AE.Node.CT_BLUEPRINT)
    local blueSceneGame = BU.GetIns(rootBlueCompGame);
    for id, lib in pairs(self.blueFtnLibMapInGame) do
      lib:EnterNextSceneEd(rootNodeGame);
    end
    blueSceneGame:SetLibsEd(self.blueFtnLibMapInGame)
    self.blueFtnLibMapInGame = nil
  end

end


function BlueUtilityEd:_CheckClassIdConflictEd(blueprint)

  -- 处理把场景物体(非prefab实例)拖到asset目录后,不保存场景,导致了有两个地方的classID一样
  -- BlueprintClass 应该跟 PrefabClass的 信息一样
  if not (blueprint:IsPrefabNilEd() or blueprint:IsPrefabEd()) then
    -- IsPrefabNilEd 如果 prefab标记没有设置 也暂时跳过检查

    local BlueRtti = require "bluecore.core.blue_rtti"
    local classInfo = BlueRtti.GetClassesByIdEd(blueprint:GetClassId())

    if classInfo ~= nil then

      local isBlueprintClass =  classInfo:IsBlueprintClass()

      if not isBlueprintClass then
        -- 如果不是prefab实例 但是有prefab文件(从prefab注册类信息prefabClass）
        WARNING("-----       ----- ----- -----       -----")
        WARNING("----- -----       ----- ----- ----- -----")
        WARNING("----- ----- -----             ----- -----")
        WARNING("   ----- Prefab File Not Match   -----  -")

        local metaFileFullPath = BlueRtti.ClearPrefabClassEd(blueprint);

        -- 需要删除prefab文件和prefab.meta文件
        local prefabPath = string.sub(metaFileFullPath,1, -6) -- [1, -6]
        local prefabMetaPath = prefabPath .. ".meta"

        -- move file to proj:RecycleBin/  会删除同名的文件
        local targetDir = vc.IFileSystem:PathAssembly("proj:recycle_bin/")
        WARNING(" targetDir "..tostring(targetDir))
        filelfs:MkDir(targetDir);
        filelfs:copy(prefabPath, targetDir );
        filelfs:copy(prefabMetaPath, targetDir);
        os.remove(prefabPath);
        os.remove(prefabMetaPath);

        WARNING("remove >>>>>>>>>>>>>>>>> "..tostring(prefabPath))
        WARNING("remove >>>>>>>>>>>>>>>>> "..tostring(prefabPath .. ".meta"))

        WARNING("----- ----- ----- ----- -----       -----")
        WARNING("----- -----       ----- ----- ----- -----")
        WARNING("----- ----- ----- -----       ----- -----")
      end

    end -- 代表没有prefab文件

  end
end

 
function BlueUtilityEd:BlueDebugYield(blueNode)
  if blueNode.debugStatus and blueNode.graph.isrunning then
    local node = blueNode.graph.Node;
    local editSystem = require "window.editor.system.editsystem"
    local Command = require "window.editor.command.command"
    local scene = editSystem:GetEditScene();
    local cmd = Command();
    cmd:SetSceneID(scene:GetStaticID());
    local nodeEdit =  cmd:GetContent(node:GetContentPath());
    editSystem:Select(nodeEdit);

    if BlueDebug:GetAllowYield() then
      self.changedata[1] = blueNode.graph;
      self.changedata[2] = blueNode.uid;
    end

    BlueDebug:DebugYield();
  end
end

function BlueUtilityEd:PushChangeData()
  local data = self.changedata;
  self.changedata = {};
  return data;
end

function BlueUtilityEd:GetIconColor(pinInfoRtti)
  --pin : 是否有执行引脚
  --  -- 绘制多个输出输入执行引脚 (多输入-时间轴节点 多输出-for逻辑节点/事件节点presskey)
  --      -- 白色
  --是否有输入引脚(节点左侧)
  --  -- 根据参数类型,找到对应的颜色
  --      -- vector 黄色 (UE4 只有浮点vector??)
  --      -- 浮点数  绿色
  --      -- 复杂类型 蓝色
  --      -- 布尔型   红色
  --      -- 枚举类型 深绿色
  --      -- 矩阵     橙色
  --  -- 显示名字
  if pinInfoRtti == Types.ExecPinType then
    return mathfunction.vector4(1, 1, 1, 1);    -- 执行引脚 白色
  elseif pinInfoRtti == Types.BoolType then
    return mathfunction.vector4(1,  0,  0, 1);      -- bool  红色
  elseif pinInfoRtti == Types.FloatType then
    return mathfunction.vector4(0.38, 1.0, 0.7, 1);  -- 浮点  浅绿色
  elseif pinInfoRtti == Types.IntType  then
    return mathfunction.vector4(0, 0.5, 0.3, 1);     -- 整型 明绿色
  elseif pinInfoRtti == Types.StringType  then
    return mathfunction.vector4(1.0, 0.5, 1.0, 1);   -- 字符串 紫红色
  elseif pinInfoRtti == mathfunction.Quaternion:RTTI() then
    return mathfunction.vector4(1.0, 0.64, 0.28, 1); -- 四元素 橙色
  elseif pinInfoRtti == Types.FilePathType  then
    return mathfunction.vector4(0, 0.886, 1, 1);
  elseif  pinInfoRtti == mathfunction.vector1:RTTI()
    or  pinInfoRtti == mathfunction.vector2:RTTI()
    or  pinInfoRtti == mathfunction.vector3:RTTI()
    or  pinInfoRtti == mathfunction.vector4:RTTI() then --vector类型 黄色
    return mathfunction.vector4(1, 1, 0, 1);
  elseif  pinInfoRtti == mathfunction.Matrix22:RTTI()
    or  pinInfoRtti == mathfunction.Matrix33:RTTI()
    or  pinInfoRtti == mathfunction.Matrix44:RTTI() then --matrix类型
    return mathfunction.vector4(1, 0.65, 0, 1);
  elseif pinInfoRtti == Types.AnyType or pinInfoRtti == Types.AnyArrayType then
    return mathfunction.vector4(0.4, 0.4, 0.4, 1);    -- 任意类型 灰色
  elseif pinInfoRtti:isArray() then
    return self:GetIconColor(pinInfoRtti:GetElementType());
  elseif type(pinInfoRtti) == 'userdata' then         --复杂类型 天蓝色 rtti 是个scriptvalue userdata
    return mathfunction.vector4(0.5, 1.0, 1.0, 1.0)
  elseif pinInfoRtti:isTypeOrDriverType(Types.EventDelegateType) then
    return mathfunction.vector4(1,  0,  0, 1);        --委托类型  红色
  elseif pinInfoRtti:isTypeOrDriverType(Types.BlueprintType) then
    return mathfunction.vector4(0.5,  0.5, 1,  1);        -- 蓝图类类型
  else
    local num = tostring(pinInfoRtti);
    return mathfunction.vector4(0.75, 0.75, 0.75, 1); -- 其他类型 灰色 FIXME(hjh) 枚举类型在脚本如何区分？
  end
end


function BlueUtilityEd:GetInsByNode(node)
  local comp = node:GetComponent(AE.Node.CT_BLUEPRINT);
  if comp ~= nil then
    local t = comp.Instances;
    if t ~= nil then
      local _, ins = next(t)
      if ins ~= nil then
        return ins
      end
    end
  end
  return nil
end


--引脚标记检查(把执行输出/执行输入引脚作为链表的节点， 事件节点的执行输出引脚为头结点)
--FIXME(hjh) 目前是编译期检测环  如果有两个执行输入引脚 且两个执行输入引脚都可能在走到执行输出引脚 这种情况构成的循环无法检测
function BlueUtilityEd:CheckExecRing(headNode, pinList)
  local res = false;
  local ringNode = nil;
  local execOutputs = headNode.execOutputs
  --几个执行输出引脚,就分几路去检查

  --TODO输入依赖环检测.... inputs

  --先顺序过一遍执行输出引脚（For_Loop_Break节 execIn->LoopBody/Compileted->Print_In->Print_Out->Break）
  for _,execOutput in pairs(execOutputs) do
    --如果输出引脚有遍历标记(Do_N节点execIn->execOut->..->Reset表示检查过了并且一定是检查过该节点的所有执行输出)
    --或者是noRingLabel有标记(两个事件节点的执行流有重叠的地方) 就不用往下找了
    if  execOutput.scanLabel or execOutput.noRingLabel then
      if execOutput.scanLabel then
        WARNING("[skip] execOut.."..tostring(execOutput.uid))
      else
        WARNING("[noRingLabel] execOut.."..tostring(execOutput.uid))
      end
      return false, 0;
    end
  end

  for _,execOutput in pairs(execOutputs) do

    if execOutput.links[1] then

      local pinMarkList = {}; --return之前都要清除掉标记

      execOutput.scanLabel = true;
      table.insert(pinMarkList, execOutput);
      WARNING("execOut.."..tostring(execOutput.uid))

      --找执行输出引脚连接的执行输入引脚(一个)
      local execInput = pinList[execOutput.links[1].pinUid];
      local nextNode = pinList[execOutput.links[1].nodeUid];
      --如果输入引脚有遍历标记，则判断为检测到环
      if execInput.scanLabel then
        WARNING("Ring!!  execInput.."..tostring(execInput.uid))
        for _,pin in pairs(pinMarkList) do
          pin.scanLabel = nil;
        end
        return true, nextNode;
      else
        execInput.scanLabel = true;
        table.insert(pinMarkList, execInput);
        WARNING("execInput.."..tostring(execInput.uid))

        res, ringNode = self:CheckExecRing(nextNode, pinList)
        if res then --发现环 不再往下检测。
          for _,pin in pairs(pinMarkList) do
            pin.scanLabel = nil;
          end
          return res, ringNode;
        end
      end

      for _,pin in pairs(pinMarkList) do
        pin.scanLabel = nil;
        pin.noRingLabel = true;
        --清除的时候可以来多一个标记 就算被清除 下次解析到这个地方可以不用往下解析
      end

    end

  end
  return res, ringNode;
end

function BlueUtilityEd:ClearPinExtraLabel(pinList)
  --WARNING("---------"..name.."-----------");
  for _,v in pairs(pinList) do
    --if v.scanLabel then
    --  WARNING("scan Label Exist.."..tostring(v.uid));
    --end
    v.noRingLabel = nil;
  end
  --WARNING("------------------------------");
end

local CallNodeList =
{
  [BD.FUNCTION_CALL_NODE] = true ,
  [BD.GLOBAL_CALL_NODE] = true ,
  [BD.EVENT_CALL_NODE] = true ,
  [BD.DISPATCHER_CALL_NODE] = true ,
};

function BlueUtilityEd:IsCallNode(node)
  if node == nil then return false end ;
  local nodeType = node:GetFunctionType();
  return CallNodeList[nodeType] or false ;
end

return BlueUtilityEd ;