
local libvenuscore = require "libvenuscore"
local Types = require "venuscore.rtti.types"
local BlueDefined = require "bluecore.bluedefined"
local BlueUtility = require "bluecore.blueutility"
local BR = require "bluecore.core.blue_rtti"

local BluePinInfo = libvenuscore.Object:extend("BluePinInfo");


function BluePinInfo:new(pinType, argId, rtti, name, tips, default, delAble, groupName, abort)
  self.pinType = pinType or BlueDefined.PIN_DATA_INPUT
  self.argId = argId or 0 ;
  self.rtti = rtti or Types.AnyType ; -- 动态设置 不参与序列化
  self.name = name or "unknown";
  self.tips = tips or "unknown tips";
  if self.pinType == BlueDefined.PIN_DATA_INPUT then
    self.default = default or BlueUtility:GetDefaultByRtti(self.rtti);
  else
    self.default = default ;          -- 如果外部不传入默认值,就是nil(由于输出pin没有default)
  end
  self.abort = abort or false         -- 如果是执行引脚 这个用来判断是否可以

  self.delAble = delAble;
  self.groupName = groupName;

  self.baseRttiName =  BR.GetRealTypeName(self.rtti);
  self.isArray = self.rtti:isArray();
end

function BluePinInfo:ChangeRtti(rtti, default)
  if rtti == nil then
    error("BluePinInfo:ChangeRtti rtti is nil");
  end
  if self.pinType == BlueDefined.PIN_DATA_INPUT and default == nil then
    -- 对于Node Component BlueprintType类型来说 输入的默认值的确是nil 字面值为nil 必须连接
    local BU = require "bluecore.blueutility"
    assert(BU:GetDefaultByRtti(rtti) == nil, "BluePinInfo:ChangeRtti default is needed for input");
  end

  self.rtti = rtti
  self.isArray = self.rtti:isArray();
  if self.isArray then
    local baseRtti =  self.rtti:GetElementType();
    self.baseRttiName = BR.GetRealTypeName(baseRtti);
  else
    --self.baseRtti = rtti ;
    self.baseRttiName = BR.GetRealTypeName(self.rtti);
  end
  self.default = default ;

end

function BluePinInfo:ChangeNameAndHint(_name, _tips)
  self.name = _name
  self.tips = _tips
end

function BluePinInfo:ChangeName(_name)
  self.name = _name
end

function BluePinInfo:ChangeDefault(default)
  self.default = default ;
end

function BluePinInfo:GetDefault()
  return self.default ;
end

function BluePinInfo:GetRtti()
  return self.rtti
end

function BluePinInfo:_OnDeserialize()
  local rtti, rttiOfArray = BR.GetRtti(self.baseRttiName, self.isArray);
  if self.isArray then
    self.rtti = rttiOfArray
  else
    self.rtti = rtti
  end
end

function BluePinInfo:GetBaseRttiName()
  if self.rtti:isArray() then
    return BR.GetRealTypeName(self.rtti:GetElementType())
  else
    return BR.GetRealTypeName(self.rtti)
  end
end

function BluePinInfo:SetBaseRttiName(baseRttiName)
  self.baseRttiName = baseRttiName
end

function BluePinInfo:GetIsArray()
  return self.rtti:isArray();
end

function BluePinInfo:SetIsArray(isArray)
  self.isArray = isArray
end

BluePinInfo:MemberRegister("pinType")
BluePinInfo:MemberRegister("argId")
BluePinInfo:MemberRegister("name")
BluePinInfo:MemberRegister("tips")
BluePinInfo:MemberRegister("default")
BluePinInfo:MemberRegister("abort")

BluePinInfo:MemberRegister("baseRttiName", Types.BaseType(BluePinInfo.GetBaseRttiName, BluePinInfo.SetBaseRttiName))
BluePinInfo:MemberRegister("isArray", Types.BaseType(BluePinInfo.GetIsArray, BluePinInfo.SetIsArray))

BluePinInfo:MemberRegister("delAble")   -- 目前序列化没有作用 因为会设置到pin中  -- 用于编辑器状态blue_anytype_node和 blue_dynamic_anytype_pins_node
BluePinInfo:MemberRegister("groupName")  -- 目前序列化没有作用 因为会设置到blue_anytype_node pinGroup

return BluePinInfo ;
