local BD = require "bluecore.bluedefined"
local BlueNode = require "bluecore.bluenode"
local mf = require "mathfunction"

local ReverseVec2 = BlueNode:extend();

function ReverseVec2:new(...)
  ReverseVec2.super.new(self, ...)
end

function ReverseVec2:_OnUpdate(args)
  local old = args[1]
  return mf.vector2(-old:x(), -old:y()) ;
end

ReverseVec2:RegisterInput(1, mf.vector2:RTTI(), "in", "vector2(x,y)", mf.vector2(0.0,0.0));
ReverseVec2:RegisterOutput(1, mf.vector2:RTTI(), "reverse", "reverse");

ReverseVec2:SetFunctionName("reverse");
ReverseVec2:SetFunctionType(BD.STATIC_FUNCTION_NODE);

return ReverseVec2;

