local apolloengine = require "apolloengine"

local BlueSelf = require "bluecore.blueself"
local Types = require "venuscore.rtti.types"
local BlueUtility = require "bluecore.blueutility"
local SetParameterNode = require "bluecore.setparameternode"

local SetTexture2D = SetParameterNode:extend();
--Unreal Engine: Set Texture Parameter Value
--这里区分Texture2D类型  
--PS:常量值是字符串 方便交互的时候同步game和scene常量值（同步对象不支持userdata?）
--   运行期根据输入值判断为entity还是path处理

---- 游戏运行模式
function SetTexture2D:new(...)
  SetTexture2D.super.new(self, ...)

end

function SetTexture2D:_OnUpdate(args)

	local tex = args[3]; 
	local entity = nil;

	if not tex then --连线的输入为空
		self.errorWarning = "nil input texture";
		return;
	elseif type(tex) == "string" then

		local filepath = tex
	  --传入路径 根据路径后缀判断是什么类型纹理 加载对应元数据  
		local devresourceType = BlueUtility:GetDevResourceType(filepath) --DEVICE_CAPTURE 或者 LAST_QUEUE
		local extension = filepath:match(".+%.(%w+)$"); --得到后缀
	  if extension ~= nil then
	    extension = string.lower(extension);
	  end
	  extension = extension or devresourceType;
	  entity = BlueUtility:CreateEntity(filepath, extension);	
	end

	local texture = type(tex) == "string" and entity or tex;

	if texture:RTTI() == apolloengine.RenderTargetEntity:RTTI() then --如果输入为fbo
		local rttex = texture:GetAttachment(apolloengine.RenderTargetEntity.TA_COLOR_0);
		if rttex:GetTextureType() ~= apolloengine.TextureEntity.TT_TEXTURE2D then
			self.errorWarning = "input texture isnt TEXTURE 2D(fbo)";
			return;
		end
	elseif texture:GetTextureType() ~= apolloengine.TextureEntity.TT_TEXTURE2D then
		self.errorWarning = "input texture isnt TEXTURE 2D(tex)";
		return;
 	end

 	local inputArgs = {args[1], args[2], texture};

 	local paraType = self:GetParameterType(inputArgs);
  self:SetParameter(inputArgs, paraType, apolloengine.MaterialEntity.VT_TEXTURE2D);
end

---- 编辑器模式
SetTexture2D:RegisterInput(1, apolloengine.MaterialEntity:RTTI(), "Material", "材质实体", BlueSelf());
SetTexture2D:RegisterInput(2, Types.StringType, "ParaName", "参数名字", "_MainTex");
SetTexture2D:RegisterInput(3, apolloengine.TextureEntity:RTTI(), "ParaValue", "参数值", "DEVICE_CAPTURE");

SetTexture2D:RegisterExecInput(1, "exec", "执行");
SetTexture2D:RegisterExecOutput(1, "exec", "执行");
SetTexture2D:SetFunctionName("SetTexture2D");

return SetTexture2D ;

