local AE = require "apolloengine"
local BlueNode = require "bluecore.bluenode"
local Types = require "venuscore.rtti.types"
local RttiOfME = AE.MaterialEntity:RTTI();
local BlueRtti = require "bluecore.core.blue_rtti"

local CreateMat = BlueNode:extend();
--Unreal Engine: Create Dynamic Material Instance
--FIXME(hjh) 后面需要加上Constant Material Instance？(venus Mat本身允许运行期改变参数)
--FIXME(hjh) 如果按照Unreal来的话 venus应该选择material 运行期创建一个mat(运行期创建的逻辑代码打包成venusroot不可见)
--若整成编辑器创建的话只要鼠标选中一次,就create一次mat 也要解决同名情况

--目前做法是选中assets目录下创建好的mat 创建materialEntity

---- 游戏运行模式
function CreateMat:new(...)
  CreateMat.super.new(self, ...)
  --new的时候创建一个默认材质实例
end

function CreateMat:_OnUpdate(args)
	local material = BlueRtti.Create(RttiOfME, args[1])
  return material;
end

---- 编辑器模式
CreateMat:RegisterInput(1, Types.MatPathType, "MatPath", "材质路径", "comm:documents/material/unlit.mat");
CreateMat:RegisterOutput(1, RttiOfME, "Mat", "输出材质实例");
CreateMat:RegisterExecInput(1, "exec", "执行");
CreateMat:RegisterExecOutput(1, "exec", "执行");
CreateMat:SetFunctionName("CreateMat");

return CreateMat ;

