local AE = require "apollocore"
local BD = require "bluecore.bluedefined"
local Base = require "bluecore.base.overlay_base_regex"
local EndOverlayRegex = Base:extend();

function EndOverlayRegex:new(...)
  EndOverlayRegex.super.new(self, ...)
end

-- unreal will trigger
function EndOverlayRegex:_OnUpdate(eventParam)

  local otherComp = eventParam.otherComp ;
  local otherNode = eventParam.otherNode ;
  local otherName = eventParam.otherName ;

  local found = string.find(otherName, self.regexString)

  if found == nil then
    self.nextExecIdx = Base.BREAK
    return
  end

  self.nextExecIdx = Base.TRIGGER
  return otherNode, otherComp;
end

function EndOverlayRegex:_GetType()
  return BD.Event.CollisionEvent.EndOverlay
end

EndOverlayRegex:RegisterOutput(1, AE.Node:RTTI(), "node" , "other node")
EndOverlayRegex:RegisterOutput(2, AE.RigidBodyComponent:RTTI(), "comp", "other component")
EndOverlayRegex:SetFunctionName("End Overlay");

return EndOverlayRegex;
