local Types = require "venuscore.rtti.types"
local BlueDebug = require "bluecore.debug.bluedebug"
local BlueDynamicAnyTypePinsNode = require "bluecore.base.blue_dynamic_anytype_pins_node"
local BD = require "bluecore.bluedefined"
local libvenuscore = require "libvenuscore"
local BluePinInfo = require "bluecore.bluepininfo"
local SwitchOnString = BlueDynamicAnyTypePinsNode:extend();

--Unreal的字符串同名编译时会报错~



---- 游戏运行模式
function SwitchOnString:new(...)
  SwitchOnString.super.new(self, ...)
  self.nextBranch = 1.0;
  self.repeatTbl = {};


end



function SwitchOnString:_OnUpdate(args)
  local inputStr = args[1];
  self.nextBranch = self.repeatTbl[inputStr] or 1.0;

end

function SwitchOnString:_OnNextBranch()
  return self.nextBranch
end




---- 编辑器模式
--FIXME(hjh)这套逻辑要面对所有的成员变量的过滤 后期如果node需要反射很多的内容 可能需要修改反射逻辑？
--该node只反射输出执行引脚的引脚信息的name
function SwitchOnString.ReflectFilterFtn(obj, member, value)
 
  if obj:GetTypeID() == SwitchOnString:GetTypeID() and member == BD.EXEC_OUTPUTS_INFO then 
    return true ;
  end 

  if obj:GetTypeID() == BluePinInfo:GetTypeID() and member == "name"  and  value ~= "Default"  then 
    return true 
  end 
    
end 

-- 在编辑器交互上创建时候回调 (避免数据和反序列化重叠 e.g table.insert操作)
function SwitchOnString:_OnCreateWithEditor()
  SwitchOnString.super._OnCreateWithEditor(self);
end

--检查是否有重复字符串
function SwitchOnString:_OnCompile()
  self.repeatTbl = {}; --每次compile都置空 reset就不处理了
  for k,v in pairs(self[BD.EXEC_OUTPUTS_INFO]) do --ArgId Info
    if self.repeatTbl[v.name] then
      self.errorWarning = "repeat string appeared!";
      return false;
    else
      self.repeatTbl[v.name] = k;
    end
  end
  return true;
  -- body
end

SwitchOnString._OnAdd = function(thisNode)
  
  local pinUid = thisNode.graph:_NextID();
  local nodeUid = thisNode.uid;
  local newArgId = 1
  for _ , __ in pairs(thisNode[BD.EXEC_OUTPUTS_INFO]) do
    newArgId = newArgId + 1
  end
  local execOutputPin = thisNode:AppendExecOutput(Types.ExecPinType, "Case   "..tostring(newArgId-2), "exec it case  "..tostring(newArgId-2), nil, pinUid, nodeUid, true);

  return execOutputPin
end


SwitchOnString._OnDel = function(thisNode, execOutputPin)
  thisNode:RemoveExecOutput(execOutputPin);
  return true
end

SwitchOnString:RegisterExecInput(1, "exec", "Execute");
SwitchOnString:RegisterExecOutput(1, "Default", "Default Execute");
SwitchOnString:RegisterMoreExecOutput("exec", BD.OP_ADD, "增加输出执行节点引脚", SwitchOnString._OnAdd, BD.OP_DEL, "删除输出执行节点引脚", SwitchOnString._OnDel);

SwitchOnString:RegisterInput(1, Types.StringType, "Selection", "字符串", "None");

SwitchOnString:SetFunctionName("SwitchOnString");

return SwitchOnString ;

