local mathfunction = require "mathfunction"
local BD = require "bluecore.bluedefined"
local Types = require "venuscore.rtti.types"
local GetScriptValue = require "bluecore.base.get_script_value"
local GetScriptQuaternion = GetScriptValue:extend();


---- 游戏运行模式
function GetScriptQuaternion:new(...)
  GetScriptQuaternion.super.new(self, ...)

end

function GetScriptQuaternion:_OnUpdate(args)

  local scriptIns = args[1];
  local para = args[2];  
  --return scriptIns[para];
  return scriptIns:GetScriptValue(para);
end



function GetScriptQuaternion:_IsRightType(key, value, scriptIns)
  return type(value) == "userdata" and value:RTTI() == mathfunction.Quaternion():RTTI();
end



GetScriptQuaternion:RegisterInput(1, Types.ScriptInsRefType, "Script_Instance", "behaviour", Types.NotNullType());
GetScriptQuaternion:RegisterInput(2, Types.ComboType, "ParaName", "参数名字", BD.EMPTY_STRING); --instance可选的Quaternion变量

GetScriptQuaternion:RegisterOutput(1, mathfunction.Quaternion:RTTI(), "Quaternion", "获取参数值");



GetScriptQuaternion:SetFunctionName("GetScriptQuaternion");


return GetScriptQuaternion ;

