local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local BD = require "bluecore.bluedefined"
local Types = require "venuscore.rtti.types"
local GetPostEffectValue = require "bluecore.base.get_posteffect_value"
local GetPostEffectVector2 = GetPostEffectValue:extend();


---- 游戏运行模式
function GetPostEffectVector2:new(...)
  GetPostEffectVector2.super.new(self, ...)
end




function GetPostEffectVector2:_IsRightType(value)
  return type(value) == "userdata" and value:RTTI() == mathfunction.vector2():RTTI();
end



GetPostEffectVector2:RegisterInput(1, Types.CameraPostEffectRefType, "postEffect", "后处理", Types.NotNullType());
GetPostEffectVector2:RegisterInput(2, Types.ComboType, "ParaName", "参数名字", BD.EMPTY_STRING); 

GetPostEffectVector2:RegisterOutput(1, mathfunction.vector2:RTTI(), "ParaValue", "参数值");



GetPostEffectVector2:SetFunctionName("GetPostEffectVector2");


return GetPostEffectVector2 ;

