local BluePinInfo = require "bluecore.bluepininfo"
local BlueNode = require "bluecore.bluenode"
local BD = require "bluecore.bluedefined"

local BlueDynamicNoDesNode = BlueNode:extend("BlueDynamicNoDesNode");


-- 用途:引脚数量不变 但是rtti/tips/name等会在编辑时修改 又不需要序列化保存引脚信息的节点类(BlueDynamicNode包含序列化)
function BlueDynamicNoDesNode:new(...)
  BlueDynamicNoDesNode.super.new(self, ...)
end

-- 编辑器下创建Node后回调,反序列化过程会恢复infoTable所以不用执行
function BlueDynamicNoDesNode:_OnBeginCreateEd(...)
  self:_SetupInstanceInfoTable();
end

function BlueDynamicNoDesNode:_SetupInstanceInfoTable()
  -- override BlueNode infoTable, create instance's own infoTable
  local staticDataInputsInfo  = self.infoTable[BD.PIN_DATA_INPUT]
  local staticDataOutputsInfo = self.infoTable[BD.PIN_DATA_OUTPUT]
  local staticExecInputsInfo  = self.infoTable[BD.PIN_EXEC_INPUT]
  local staticExecOutputsInfo = self.infoTable[BD.PIN_EXEC_OUTPUT]

  self.infoTable = {}
  self.infoTable[BD.PIN_DATA_INPUT] = {}
  self.infoTable[BD.PIN_DATA_OUTPUT] = {}
  self.infoTable[BD.PIN_EXEC_INPUT]  = {}
  self.infoTable[BD.PIN_EXEC_OUTPUT] =  {}

  for idx, pinInfo in pairs(staticDataInputsInfo) do
    self.infoTable[BD.PIN_DATA_INPUT][idx] =
      BluePinInfo(BD.PIN_DATA_INPUT, pinInfo.argId, pinInfo.rtti, pinInfo.name, pinInfo.tips, pinInfo.default, pinInfo.delAble, pinInfo.groupName);
  end

  for idx, pinInfo in pairs(staticDataOutputsInfo) do
    self.infoTable[BD.PIN_DATA_OUTPUT][idx] =
      BluePinInfo(BD.PIN_DATA_OUTPUT, pinInfo.argId, pinInfo.rtti, pinInfo.name, pinInfo.tips, nil, pinInfo.delAble, pinInfo.groupName);
  end

  for idx, pinInfo in pairs(staticExecInputsInfo) do
    self.infoTable[BD.PIN_EXEC_INPUT][idx] =
      BluePinInfo(BD.PIN_EXEC_INPUT, pinInfo.argId, pinInfo.rtti, pinInfo.name, pinInfo.tips, nil, pinInfo.delAble, pinInfo.groupName);
  end

  for idx , pinInfo in pairs(staticExecOutputsInfo) do
    self.infoTable[BD.PIN_EXEC_OUTPUT][idx] =
      BluePinInfo(BD.PIN_EXEC_OUTPUT, pinInfo.argId, pinInfo.rtti, pinInfo.name, pinInfo.tips, nil, pinInfo.delAble, pinInfo.groupName);
  end
end

function BlueDynamicNoDesNode:_OnDeserialize()
  -- 到这里已经完成了 BlueNode.inputs .outputs .execinputs .execoutputs
  self:_SetupInstanceInfoTable();
end

function BlueDynamicNoDesNode:_OnDeserializePost()

end


return BlueDynamicNoDesNode