local venuscore = require "venuscore"
local mathfunction = require "mathfunction"
local AE = require "apolloengine"

local ScreenImage = venuscore.VenusBehavior:extend("ScreenImage");

function ScreenImage:new()
  self.hostCamera = nil;
  --self.WindowAspect = 1.0;
  --self.TexAspect = 1.0;
  --self.StretchMode = 0;
  --self.StretchModeChange = false;
  --self.HorizonAlign = 0;
  --self.VerticalAlign = 0;
end


function ScreenImage:_OnAwake()
 
end

function ScreenImage:GetHostCameraResolution()
  local resolution;
  if venuscore.isNil(self.hostCamera) then
    if _KRATOSEDITOR then
      local scene = AE.SceneManager:GetOrCreateScene("facecuteScene"); --previewscene
      local fbo = scene:GetDefaultRenderTarget();
      local tex = fbo:GetAttachment(AE.RenderTargetEntity.TA_COLOR_0);
      resolution = tex:GetSize();
    else
      resolution = AE.Framework:GetResolution();
    end
  else
    resolution = self.hostCamera.CameraResolution;
  end
  return resolution;
end

function ScreenImage:_OnUpdate(def)
  --FIXME(hjh) 编辑器Update好几次才能拿到正确的分辨率...
  local renderCom = self.Node:GetComponent(AE.Node.CT_RENDER);
  local screenTransCom = self.Node:GetComponent(AE.Node.CT_SCREENTRANSFORM);
  if not renderCom or not screenTransCom then
    return;
  end
  local resolution = self:GetHostCameraResolution();
  renderCom:SetParameter("_WindowRatio", mathfunction.vector1(resolution.mx/resolution.my));
  screenTransCom.WindowAspect = resolution.mx/resolution.my;

  local slotNameList, slot = renderCom:GetUniformParameter(1);
  local isTexRatioChange= false;
  local TexRatioValue = nil;
  local imgSize = nil;
  --如果纹理是fbo 会依赖屏幕分辨率宽高比
  --每次update这里检查当前材质参数_BluendTex的fbo或者tex的分辨率是否改变 来修改shader参数
  if slot["_BlendTex"]:isTypeOrDriverType(AE.RenderTargetEntity:RTTI())  then
    local tex = slot["_BlendTex"]:GetAttachment(AE.RenderTargetEntity.TA_COLOR_0);
    imgSize = tex:GetSize();
  else
    imgSize = slot["_BlendTex"]:GetSize();
  end 
  if imgSize.mx/imgSize.my ~= screenTransCom.TexAspect then
    isTexRatioChange = true;
    TexRatioValue = imgSize.mx/imgSize.my;
    screenTransCom.TexAspect = TexRatioValue;
    renderCom:SetParameter("_TextureRatio", mathfunction.vector1(TexRatioValue));
  end


  if _KRATOSEDITOR then
    --解决编辑器的Game/Scene不一致
    --同步Scene场景
    local editSystem = require "window.editor.system.editsystem";
    local Command = require "window.editor.command.command";
    local editScene = editSystem:GetEditScene();
    local cmd = Command();
    cmd:SetSceneID(editScene:GetStaticID());
    local renderComScene =  cmd:GetContent(renderCom:GetContentPath());
    local screenTransComScene =  cmd:GetContent(screenTransCom:GetContentPath());
    renderComScene:SetParameter("_WindowRatio", mathfunction.vector1(resolution.mx/resolution.my));
    screenTransComScene.WindowAspect = resolution.mx/resolution.my;
    if isTexRatioChange then
      screenTransComScene.TexAspect = TexRatioValue;
      renderComScene:SetParameter("_TextureRatio", mathfunction.vector1(TexRatioValue));
    end
  end
end

function ScreenImage:PhotoUploadRecall(tex, redirectName) 
  local renderCom = self.Node:GetComponent(AE.Node.CT_RENDER);
  local screenTransCom = self.Node:GetComponent(AE.Node.CT_SCREENTRANSFORM);
  local slotNameList, slot = renderCom:GetUniformParameter(1); --screenImageNode只有一个matentity
  if slot["_BlendTex"]:GetName() == redirectName then --所用的纹理是改变的重定向纹理
    local texSize = tex:GetSize();
    renderCom:SetParameter("_TextureRatio", mathfunction.vector1(texSize.mx/texSize.my)); --设置给shader...
    screenTransCom.TexAspect = texSize.mx/texSize.my; --计算local scale

    local resolution = self:GetHostCameraResolution();

    renderCom:SetParameter("_WindowRatio", mathfunction.vector1(resolution.mx/resolution.my));
    screenTransCom.WindowAspect = resolution.mx/resolution.my;
  --else
  --  LOG("not match");
  end
  -- body

end

function ScreenImage:GetCamera()
  return self.hostCamera;
end

function ScreenImage:SetCamera(hostCamera)
  self.hostCamera = hostCamera;
end

ScreenImage:MemberRegister("hostCamera",
  venuscore.ScriptTypes.ReferenceType(
    AE.CameraComponent:RTTI(),    
    ScreenImage.GetCamera,
    ScreenImage.SetCamera
)); 




--注册要写在最下面，不然没有TestBehavior.GetCombo这些函数
--这些数据实际上可以全删掉
--[[ScreenImage:MemberRegister("WindowAspect");
ScreenImage:MemberRegister("TexAspect");
ScreenImage:MemberRegister("HorizonAlign");
ScreenImage:MemberRegister("VerticalAlign");
ScreenImage:MemberRegister("StretchModeChange");

ScreenImage:MemberRegister("StretchMode",
    venuscore.ScriptTypes.ComboType(
        {
          {
            key = "Fit",
            value = 0
          },
          {
            key = "Fill",
            value = 1
          },
          {
            key = "Stretch",
            value = 2
          },
          {
            key = "FitHeight",
            value = 3
          },
          {
            key = "FitWidth",
            value = 4
          },
          {
            key = "FillAndCut",
            value = 5
          }
        }
    ));
]]--

return ScreenImage;