require "utility"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"
local wavefilter = {}

wavefilter.renderObject = nil;
wavefilter.queue = 100;

function wavefilter:Initialize(host, size)
  self.material = host:CreateMaterial("comm:documents/shaders/posteffect/wavefilter.material");
  self.renderObject = host:CreateRenderObject()
  
  self.MaskTex = apolloengine.TextureEntity();
  self.Phase = mathfunction.vector1(0.02);
  self.OffsetMount = mathfunction.vector1(0.0);
  self.FrameIndex = mathfunction.vector1(1.0);
  self.RegionCount = mathfunction.vector1(4.0);
  
  host:RegisterScriptParameter(self, "MaskTex");
  host:RegisterScriptParameter(self, "Phase");
  host:RegisterScriptParameter(self, "OffsetMount");
  host:RegisterScriptParameter(self, "FrameIndex");
  host:RegisterScriptParameter(self, "RegionCount");
  return self.queue;
end

function wavefilter:Resizeview(size)
--firstmaterialentity:SetParameter("_MainTex", tex);
end

function wavefilter:Process(context, Original, Scene, Output)
  context:BeginRenderPass(Output, apolloengine.RenderTargetEntity.CF_COLOR);
  
  local material = self.material;

  material:SetParameter("_MainTex", Scene:GetAttachment(apolloengine.RenderTargetEntity.TA_COLOR_0));
  material:SetParameter("_MaskTex", self.MaskTex);
  material:SetParameter("_Phase", self.Phase);
  material:SetParameter("_OffsetMount", self.OffsetMount);
  material:SetParameter("_FrameIndex", self.FrameIndex);
  material:SetParameter("_RegionCount", self.RegionCount);
  
  context:Draw(self.renderObject, self.material);
  context:EndRenderPass();
end

return wavefilter;