local ae = require "apolloengine"
local mf = require "mathfunction"
local vc = require "venuscore"

local MedianBlur = {}

function MedianBlur:_UpdateParameter()
  local rad = self.angle / 180.0 * math.pi
  self.step = mf.vector2(
    math.cos(rad),
    math.sin(rad)
  ) * self.length
end

function MedianBlur:Initialize(host, size)
  local uniforms = 
  {
    "_MainTex", "_MainSize", "_Step",
  }
  for i = 1, #uniforms do
    self[uniforms[i]] = ae.IMaterialSystem:NewParameterSlot(
      ae.ShaderEntity.UNIFORM,
      uniforms[i]
    )
  end

  self.angle = 0
  self.length = 0.0
  self.step = mf.vector2(0.0, 0.0)
  
  self:_UpdateParameter()
  
  self.roMedianMaterial = host:CreateMaterial("comm:documents/material/median.material");
  self.roMedianRenderObj = host:CreateRenderObject();
  self.roMedianMaterial:SetParameter(self._MainSize, size)
  self.roMedianMaterial:SetParameter(self._Step, self.step)
  
  host:RegisterScriptParameter(self, "angle")
  host:RegisterScriptParameter(self, "length")

  return 310
end



function MedianBlur:Resizeview(size)
  self.roMedianMaterial:SetParameter(self._MainSize, size)
end

function MedianBlur:Process(context, Original, Scene, Output)
  self:_UpdateParameter()


  context:BeginRenderPass(Output, ae.RenderTargetEntity.CF_COLOR);
  self.roMedianMaterial:SetParameter(self._Step, self.step)
  self.roMedianMaterial:SetParameter(
    self._MainTex,
    Scene:GetAttachment(ae.RenderTargetEntity.TA_COLOR_0)
  )
  context:Draw(self.roMedianRenderObj, self.roMedianMaterial);

  context:EndRenderPass()
end

return MedianBlur