

#DEFPARAMS
#END

#DEFTAG
ShaderName = "SuperMeBloomCombine"
RenderQueue = "PostEffect"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

Texture2D TEXTURE_DIFFUSE;
Texture2D TEXTURE_BLUR1;
Texture2D TEXTURE_BLUR2;
Texture2D TEXTURE_BLUR3;
SamplerState TEXTURE_DIFFUSE_Sampler;
SamplerState TEXTURE_BLUR1_Sampler;
SamplerState TEXTURE_BLUR2_Sampler;
SamplerState TEXTURE_BLUR3_Sampler;
float BLOOM_PARAM;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv.xy;

	return o;
}

void frag(in v2f i, out float4 mainColor : SV_Target0)
{
    float4 blurColor = TEXTURE_DIFFUSE.Sample( TEXTURE_DIFFUSE_Sampler, i.uv );
    float4 color = TEXTURE_BLUR1.Sample( TEXTURE_BLUR1_Sampler, i.uv );
    blurColor = color * (0.5) + blurColor;
    color = TEXTURE_BLUR2.Sample( TEXTURE_BLUR2_Sampler, i.uv );
    blurColor = color * (0.25) + blurColor;
    color = TEXTURE_BLUR3.Sample( TEXTURE_BLUR3_Sampler, i.uv );
    blurColor = color * (0.125) + blurColor;
    mainColor = blurColor;
}
ENDCG
#END
