#DEFPARAMS
BLUR_SOURCE   = {"BLUR_SOURCE", TEXTURE2D, "BLUR_SOURCE"},
TEXEL_SIZE    = {"TEXEL_SIZE", VEC2, "64.0, 64.0"},
#END

#DEFTAG
ShaderName  = "BlurStep"
RenderQueue = "PostEffect"
#END

#DEFPASS Always
COLOR_MASK   = COLOR_RGBA
ALPAH_MODE   = { ALPAH_OFF }
DRAW_MODE    = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE   = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
    float4 vertex : POSITION;
    float2 uv : TEXCOORD0;
};

struct v2f
{
    float2 center_uv: TEXCOORD0;
    float2 left_uv:   TEXCOORD1;
    float2 right_uv:  TEXCOORD2;
    float2 top_uv:    TEXCOORD3;
    float2 bottom_uv: TEXCOORD4;

    float4 vertex : SV_POSITION;
};

Texture2D BLUR_SOURCE;
SamplerState BLUR_SOURCE_Sampler;
float2    TEXEL_SIZE;

v2f vert(appdata v)
{
    v2f o;
    o.vertex = UniformNDC(v.vertex);

    o.center_uv = v.uv.xy;
    o.left_uv   = o.center_uv - float2(TEXEL_SIZE.x, 0.0);
    o.right_uv  = o.center_uv + float2(TEXEL_SIZE.x, 0.0);
    o.top_uv    = o.center_uv + float2(0.0, TEXEL_SIZE.y);
    o.bottom_uv = o.center_uv - float2(0.0, TEXEL_SIZE.y);

    return o;
}

void frag(in v2f i, out float4 mainColor : SV_Target0)
{
    float4 sum = float4(0.0,0.0,0.0,0.0);
    sum += BLUR_SOURCE.Sample(BLUR_SOURCE_Sampler, i.left_uv);
    sum += BLUR_SOURCE.Sample(BLUR_SOURCE_Sampler, i.right_uv);
    sum += BLUR_SOURCE.Sample(BLUR_SOURCE_Sampler, i.top_uv);
    sum += BLUR_SOURCE.Sample(BLUR_SOURCE_Sampler, i.bottom_uv);
    sum *= 0.25;
    mainColor = sum;
}
ENDCG
#END