#pragma once

float3 RGBtoHCV(float3 rgb)
{
	float4 p = (rgb.g < rgb.b) ? float4(rgb.bg, -1.0, 2.0/3.0) : float4(rgb.gb, 0.0, -1.0/3.0);
	float4 q = (rgb.r < p.x) ? float4(p.xyw, rgb.r) : float4(rgb.r, p.yzx);
	
  float c = q.x - min(q.w, q.y);
	float h = abs((q.w - q.y) / (6.0*c + 1e-7) + q.z);
	float v = q.x;
	
	return float3(h, c, v);
}

float3 RGBToHSL(float3 rgb)
{
	float3 hcv = RGBtoHCV(rgb);
	float lum = hcv.z - hcv.y * 0.5;
	float sat = hcv.y / (1.0 - abs(2.0*lum - 1.0) + 1e-7);
	
	return float3(hcv.x, sat, lum);
}

float3 HUEtoRGB(float hue)
{
	float r = abs(6.0*hue - 3.0) - 1.0;
	float g = 2.0 - abs(6.0*hue - 2.0);
	float b = 2.0 - abs(6.0*hue - 4.0);
	float3 blackColor = float3(0.0, 0.0, 0.0);
	float3 whiteColor = float3(1.0, 1.0, 1.0);
	return clamp(float3(r, g, b), blackColor, whiteColor);
}

float3 HSLToRGB(float3 hsl)
{
	float3 rgb = HUEtoRGB(hsl.x);
	float c = (1.0 - abs(2.0 * hsl.z - 1.0)) * hsl.y;
	rgb = (rgb - 0.5) * c + hsl.z;
	return rgb;
}

float3 BlendExclusion(float3 base, float3 blend)
{
	return (base + blend - 2.0 * (base) * (blend));
}

float BlendOverlayf(float base, float blend)
{
  return (base < 0.5 ? (2.0 * (base) * (blend)) : (1.0 - 2.0 * (1.0 - (base)) * (1.0 - (blend))));
}

float3 BlendOverlay(float3 base, float3 blend)
{
	return float3(BlendOverlayf(base.r, blend.r), BlendOverlayf(base.g, blend.g), BlendOverlayf(base.b, blend.b));
}

float3 BlendHardLight(float3 base, float3 blend)
{
	return BlendOverlay(blend, base);
}

float BlendSoftLightf(float base, float blend)
{
    return ((1.0 - 2.0 * (blend))*(base)*(base) + 2.0 * (base) * (blend));
}

float BlendColorDodgef(float base, float blend)
{
  return ((blend == 1.0) ? blend : min((base) / (1.0 - (blend)), 1.0));
}

float BlendColorBurnf(float base, float blend)
{
  return ((blend == 0.0) ? blend : max((1.0 - ((1.0 - (base)) / (blend))), 0.0));
}

float BlendVividLightf(float base, float blend)
{
  if(blend < 0.5)
	{
    return BlendColorBurnf(base, 2.0 * blend);
  }
    else
	{
    return BlendColorDodgef(base, 2.0 * (blend - 0.5));
  }
}

float3 BlendVividLight(float3 base, float3 blend)
{
	return float3(BlendVividLightf(base.r, blend.r), BlendVividLightf(base.g, blend.g), BlendVividLightf(base.b, blend.b));
}

float3 BlendColorBurn(float3 base, float3 blend)
{
	return float3(BlendColorBurnf(base.r, blend.r), BlendColorBurnf(base.g, blend.g), BlendColorBurnf(base.b, blend.b));
}

float3 BlendColorDodge(float3 base, float3 blend)
{
	return float3(BlendColorDodgef(base.r, blend.r), BlendColorDodgef(base.g, blend.g), BlendColorDodgef(base.b, blend.b));
}

float3 BlendSoftLight(float3 base, float3 blend)
{
	return float3(BlendSoftLightf(base.r, blend.r),BlendSoftLightf(base.g, blend.g),BlendSoftLightf(base.b, blend.b));
}

float BlendHardMixf(float base, float blend)
{
  if(BlendVividLightf(base, blend) < 0.5)
  {
    return 0.0;
  }
  else
  {
    return 1.0;
  }
}

float3 BlendHardMix(float3 base, float3 blend)
{
	return float3(BlendHardMixf(base.r, blend.r), BlendHardMixf(base.g, blend.g), BlendHardMixf(base.b, blend.b));
}

float BlendLightenf(float base, float blend)
{
  return max(blend, base);
}

float BlendDarkenf(float base, float blend)
{
  return min(blend, base);
}

float BlendPinLightf(float base, float blend) 
{
  if(blend < 0.5)
	{
    return BlendDarkenf(base, 2.0 * blend);
  }
    else
	{
    return BlendLightenf(base, 2.0 * (blend - 0.5));
  }
}

float3 BlendPinLight(float3 base, float3 blend)
{
	return float3(BlendPinLightf(base.r, blend.r), BlendPinLightf(base.g, blend.g), BlendPinLightf(base.b, blend.b));
}

float BlendLinearBurnf(float base, float blend)
{
  return max(base + blend - 1.0, 0.0);
}

float BlendLinearDodgef(float base, float blend)
{
  return min(base + blend, 1.0);
}

float BlendLinearLightf(float base, float blend)
{
  if(blend < 0.5)
	{
    return BlendLinearBurnf(base, 2.0 * blend);
  }
  else 
	{
    return BlendLinearDodgef(base, 2.0 * (blend - 0.5));
  }
}

float3 BlendLinearLight(float3 base, float3 blend)
{
	return float3(BlendLinearLightf(base.r, blend.r), BlendLinearLightf(base.g, blend.g), BlendLinearLightf(base.b, blend.b));
}

float3 BlendDiff(float3 base, float3 blend)
{
	return abs(base - blend);
}

float3 BlendLinearBurn(float3 base, float3 blend)
{
	return float3(BlendLinearBurnf(base.r, blend.r), BlendLinearBurnf(base.g, blend.g), BlendLinearBurnf(base.b, blend.b));
}

float3 BlendSub(float3 base, float3 blend)
{
	return max(base - blend, float3(0.0, 0.0, 0.0));
}
