

#DEFPARAMS
FRAME_I    = { "FRAME_I",  TEXTURE2D,  "white"    },
FRAME_II   = { "FRAME_II",  TEXTURE2D,  "white"     },
FRAME_III  = { "FRAME_III",  TEXTURE2D,  "white"     },
WEIGHTS    = { "WEIGHTS",  VEC3, "0.33, 0.33, 0.33"   },
#END

#DEFTAG
ShaderName = "temporal_filter" 
RenderQueue = "PostEffect"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;

};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

Texture2D FRAME_I;
Texture2D FRAME_II;
Texture2D FRAME_III;
SamplerState FRAME_I_Sampler;
SamplerState FRAME_II_Sampler;
SamplerState FRAME_III_Sampler;
float3 WEIGHTS;


v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv;

	return o;
}

void frag(in v2f i, out float4 mainColor : SV_Target0)
{
    
    float4 colorI   = FRAME_I.Sample(FRAME_I_Sampler, i.uv);
    float4 colorII  = FRAME_II.Sample(FRAME_II_Sampler, i.uv);
    float4 colorIII = FRAME_III.Sample(FRAME_III_Sampler, i.uv);

    mainColor = colorI * WEIGHTS.x + colorII * WEIGHTS.y + colorIII * WEIGHTS.z;
    
}
ENDCG
#END
