#DEFPARAMS
[Keywords(ALPHAPREMULTIPLY_ON, ALPHAPREMULTIPLY_OFF)]
_AlphaPreMultiply = {"Alpha Pre Multiply", FLOAT, "1.0"},
[Keywords(ALPHATEST_ON, ALPHATEST_OFF)]
_ALPHATEST_ON = {"Alpha Test On", FLOAT, "1.0"},

[Enum(BlendOnOff)]
_BlendState = {"belnd state", FLOAT, "0.0"},
[Enum(BlendFactor)]
_BlendSrc = {"blendsrc", FLOAT, "1.0"},
[Enum(BlendFactor)]
_BlendDst = {"blenddst", FLOAT, "1.0"},
#END

#DEFTAG
ShaderName = "StandardPbrDeferred"
RenderQueue = "%_RenderQueue"
#END


#DEFPASS DeferredShading
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { "%_BlendState", "%_BlendSrc", "%_BlendDst", ONE, ONE }
DRAW_MODE = { CULL_FACE_BACK, DEPTH_MASK_OFF, DEPTH_TEST_OFF, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_ON, 0,  
STENCIL_FUNCTION_EQUAL, 1, -1, STENCIL_OPERATION_KEEP, STENCIL_OPERATION_KEEP, STENCIL_OPERATION_KEEP,
STENCIL_FUNCTION_EQUAL, 1, -1, STENCIL_OPERATION_KEEP, STENCIL_OPERATION_KEEP, STENCIL_OPERATION_KEEP }
LIGHT_MODE = { FORWARDBASE }

CGPROGRAM

#define USE_GLES_FBF_DEFERRED (VENUS_MRT_FRAMEBUFFER_FETCH && (SHADER_API_GLES || SHADER_API_GLES3))
#define USE_PLS_DEFERRED (VENUS_MRT_PLS && (SHADER_API_GLES || SHADER_API_GLES3))

#pragma vertex vert
#pragma fragment frag
#pragma multi_compile_fwdadd
#pragma multi_compile_mrt_fbfetch
#include "lightpbr.inc"
#include "lightdeferred.inc"

struct appdata
{
    float4 vertex : POSITION;
    float2 uv : TEXCOORD0;
};

struct v2f
{
    float2 uv : TEXCOORD0;
    float4 vertex : SV_POSITION;
};

Texture2D TEXTURE_GBUFFER_A;
Texture2D TEXTURE_GBUFFER_B;
Texture2D TEXTURE_GBUFFER_C;
Texture2D TEXTURE_GBUFFER_DEPTH;

SamplerState TEXTURE_GBUFFER_A_SAMPLER;
SamplerState TEXTURE_GBUFFER_B_SAMPLER;
SamplerState TEXTURE_GBUFFER_C_SAMPLER;
SamplerState TEXTURE_GBUFFER_DEPTH_SAMPLER;

v2f vert(appdata v)
{
    v2f o;
    o.vertex = UniformNDC(v.vertex);
    o.uv = v.uv.xy;
    return o;
}


void FetchGBuffer(in float2 UV, out float4 GBufferA, out float4 GBufferB, out float4 GBufferC, out float SceneDepth)
{
#if USE_PLS_DEFERRED
    GBufferA = GLFramebufferFetch0(); 
	GBufferB = GLFramebufferFetch1(); 
	GBufferC = GLFramebufferFetch2();
    SceneDepth = ConvertFromDeviceZ(GLFramebufferFetchDepth());
#elif USE_GLES_FBF_DEFERRED
    GBufferA = GLFramebufferFetch0(); 
	GBufferB = GLFramebufferFetch1(); 
	GBufferC = GLFramebufferFetch2(); 

#if USE_SCENE_DEPTH_ON
	SceneDepth = ConvertFromDeviceZ(GLFramebufferFetchDepth());
#else
    SceneDepth = ConvertFromDeviceZ(GLFramebufferFetch3());
#endif // USE_SCENE_DEPTH_ON

#else
    GBufferA = TEXTURE_GBUFFER_A.Sample(TEXTURE_GBUFFER_A_SAMPLER, UV);
	GBufferB = TEXTURE_GBUFFER_B.Sample(TEXTURE_GBUFFER_B_SAMPLER, UV);
	GBufferC = TEXTURE_GBUFFER_C.Sample(TEXTURE_GBUFFER_C_SAMPLER, UV);
    SceneDepth = ConvertFromDeviceZ(TEXTURE_GBUFFER_DEPTH.Sample(TEXTURE_GBUFFER_DEPTH_SAMPLER, UV).r);
#endif 
}

void frag(in v2f i
#if !(USE_PLS_DEFERRED || USE_GLES_FBF_DEFERRED)
, out float4 outColor : SV_Target0
#endif
)
{
    float depth = 0;
    float4 GBufferA = 0; 
	float4 GBufferB = 0; 
	float4 GBufferC = 0; 

    float2 UV = i.uv;
    FetchGBuffer(UV, GBufferA, GBufferB, GBufferC, depth);
    GBufferData gbufferData = DataToGBuffer(GBufferA, GBufferB, GBufferC);

    float3 worldPos = WorldPosFromDepth(depth, UV);

    float4 shadowCoord;
    SHADOW_DEFERRED(float4(worldPos,1.0), shadowCoord);
    float atten = SHADOW_ATTEN_DEFERRED(shadowCoord);

    float4 mainColor;
    if(depth == 1.0)
    {
        mainColor.xyzw = float4(0,0,0,0);
    }
    else
    {
        SurfaceStandardInput input;
        input.albedo = gbufferData.base_color;
        input.metallic = gbufferData.metalness;
        input.smoothness = gbufferData.smoothness;
        input.worldNormal = gbufferData.world_normal;
        input.worldPos = worldPos;
        input.emission = float3(0.0, 0.0, 0.0);
        input.alpha = gbufferData.alpha;
        input.specularIbl = float3(0.0, 0.0, 0.0);
        input.diffuseIbl = float3(0.0, 0.0, 0.0);
        input.atten = atten;

        mainColor.xyz = PBR_LightCalc(input);

        #if ALPHATEST_ON
            mainColor.w = 1.0;
            if (col.a - _CutOff <= 0) {discard; }
            #else
                #if ALPHAPREMULTIPLY_ON
                    mainColor.w = input.alpha *  _Opacity;
                #else
                    mainColor.w = 1.0;
            #endif
        #endif

#if !(USE_PLS_DEFERRED || USE_GLES_FBF_DEFERRED)
        outColor = mainColor;
#else
        GLFramebufferFetchWrite0(mainColor + GBufferA);
#endif
    }


}

ENDCG

#END






