//最普通的参数输出最基本的数据
#SHADER_DEFINE BaseOutlineTransfrom

	FUNCTION_INPUT = 
	{
		{ LOCALSCREEN_TRANSVIEWPROJ,	HIGH,	MAT4,		"in_WorldViewPorj" },
		{ LOCALWORLD_ROTATION,			HIGH,	MAT3,		"in_WorldRotation" },
		{ ATTRIBUTE_POSITION, 			HIGH,	VEC4,		"in_Position" },
		{ ATTRIBUTE_NORMAL, 			HIGH,	VEC3,		"in_Normal" },
    { CAMERA_VIEWPROJ,			HIGH,	MAT4,		"in_ViewPorj" },
    { CAMERA_PROJECTION,			HIGH,	MAT4,		"in_Porj" },
    { ATTRIBUTE_COLOR0, 		HIGH,	VEC4,		"in_Color0" },
    {EDGE_WIDTH,HIGH,FLOAT,"in_edgewidth"},
    {OFFSET_SCALE,HIGH,FLOAT,"in_offsetscale"},
    { LOCALWORLD_TRANSFORM,		HIGH,	MAT4,		"in_Transfrom" },
    
    {MIN_WIDTH,HIGH,FLOAT,"in_minwidth"},
    {RANGE_DISTANCE,HIGH,FLOAT,"in_rangedis"},
    
        
	}

	FUNCTION_OUTPUT = 
	{
		{ SCREENSPACE_POSITION, 		HIGH,	VEC4,		"out_Position" },
	//	{ WORLDSPACE_NORMAL, 			HIGH,	VEC3,		"out_Normal" },
    { INTERNAL_COLOR0, 		HIGH,	VEC4,		"out_Color0" },
	}

#SHADER_CODE

  vec4 out_Color0 = in_Color0;
  vec4 out_Position = in_WorldViewPorj * in_Position;
  vec3 outNormal = in_WorldRotation * in_Normal;
  float r = in_Color0.r;
  float _EdgeThickness =in_edgewidth*(1.0-r);
  float INV_EDGE_THICKNESS_DIVISOR =  0.00285;
  vec4 projSpacePos = out_Position;
	vec4 projSpaceNormal = ( in_ViewPorj*vec4(outNormal.xyz,0.0));
  projSpaceNormal.xy = normalize(projSpaceNormal.xy);
  vec4 wpos = in_Transfrom*in_Position;
  float zcof = abs(wpos.z);
  float zmax = in_rangedis;
  if(zcof>zmax)
  {
    zcof = zmax;
  }
  
  zcof= zcof/zmax;
  zcof =1.0-zcof;
  float widthjudge = in_minwidth/in_edgewidth;
  if(zcof<widthjudge)
  {
   zcof = widthjudge;
  }
  
  zcof =min(1.0,zcof);
  vec4 scaledNormal = _EdgeThickness * INV_EDGE_THICKNESS_DIVISOR * projSpaceNormal*abs(wpos.z)*zcof*1.5; 
  out_Position.xy = projSpacePos.xy + scaledNormal.xy;
  float scale = 0.2;
  out_Position.z = out_Position.z+0.0003*scale*in_offsetscale;
  
#END_CODE
#END_DEFINE


#SHADER_DEFINE CharaOutlineFragment
	FUNCTION_INPUT = 
	{
    {Main_Color,MEDIUM ,VEC4,"in_MainColor"},

	}
  FUNCTION_OUTPUT = 
	{
		{ SURFACE_COLOR,	LOW,	VEC4,		"out_TextureColor" },
	}
#SHADER_CODE
   vec4 out_TextureColor = in_MainColor;
#END_CODE
#END_DEFINE