#SHADER_DEFINE AddVertex

    FUNCTION_INPUT = 
    {
        { ATTRIBUTE_POSITION,        HIGH,    VEC4,        "in_Position" },
        { ATTRIBUTE_COORDNATE0,      HIGH,    VEC2,        "in_TexCoordinate" },
    }
    FUNCTION_OUTPUT =
    {
        { ATTRIBUTE_COORDNATE0,      HIGH,    VEC2,        "out_TexCoordinate" },
    }

#SHADER_CODE

    gl_Position = in_Position;
    vec2 out_TexCoordinate = in_TexCoordinate.xy;

#END_CODE
#END_DEFINE


#SHADER_DEFINE  AddFragment

    FUNCTION_INPUT = 
    {
        { TEXTURE_DIFFUSE,           NONE,      TEXTURE2D,   "in_DiffuseTexture" },
        { TEXTURE_BLEND,             NONE,      TEXTURE2D,   "in_BlendTexture"},
        { ATTRIBUTE_COORDNATE0,      HIGH,      VEC2,        "in_TexCoordinate" },
    
    }

#SHADER_CODE
    vec3 basecolor = texture2D(in_DiffuseTexture, in_TexCoordinate).rgb;
    vec3 blendcolor = texture2D(in_BlendTexture,  in_TexCoordinate).rgb;
    vec3 rgb = vec3(min(1.0,basecolor.r+blendcolor.r),min(1.0,basecolor.g+blendcolor.g),min(1.0,basecolor.b+blendcolor.b));
    gl_FragColor = vec4(rgb, 1.0);
#END_CODE
#END_DEFINE