

#DEFPARAMS

#END

#DEFTAG
ShaderName = "Gauss"
RenderQueue = "PostEffect"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

Texture2D TEXTURE_DIFFUSE;
SamplerState TEXTURE_DIFFUSE_Sampler;
float2 TARGETSIZE;
float SIGMA;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv.xy;

	return o;
}

void frag(in v2f i, out float4 mainColor : SV_Target0)
{
    float2 size = TARGETSIZE;
    float2 uv = i.uv;
    float twoSigma2 = 2.0 * (SIGMA )*(SIGMA );
    float halfWidth = 2.0* SIGMA;
    float3 acum = TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, uv).rgb;
    float norm = 1.0;
// 水平方向高斯模糊
// i=0的时候系数为0
    for ( float i = 1.0; i <= halfWidth; i++ )
    {
        float kern = exp( -i*i/ twoSigma2 );
        float3 loca = TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, uv + float2(i,0.0) / size).rgb+TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, uv + float2(-i,0.0) / size).rgb;
        norm += 2.0*kern;
        acum += kern * loca;
    }
    acum = acum/norm;
    mainColor = float4(acum, TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, uv ).w);
}
ENDCG
#END
