


local renderqueue = require "apolloutility.renderqueue"
local basedetect = require "videodecet.basevideodetect";
local apollonode = require "apolloutility.apollonode"
local Faceinfo = require "videodecet.faceinfo";
local Actioninfo = require "videodecet.actioninfo";
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"
local likeapp = require "likeapp"
local defined = require "facecute.defined"
local videodefined = require"videodecet.defined"
local bitop = require "bit"
local videodecet = {}
setmetatable(videodecet, basedetect);
local colorspaceconverter = require "colorspaceconverter"
--local cnnseg= require "videodecet.cnnseg"
local faceseg = require "videodecet.faceseg"
--第一个人脸的特征点(106*2 定义见商汤文档) 
--倾斜角度(pitch roll yaw ) 
-- ... 紧接着第二个人脸特征点 ....
local facepointcount = 215;
local keypointcount = 106*2;
local bodykeypoints = 14*2;
local extrakeypointcount = 134*2;
--第一个人的动作个数 + 动作ID + C + C + R + R + R + R  + 动作ID + C + C + R + R +R +R +..... 第二个人的动作个数+ 动作ID ....  ?
local actionpointcount = 7;

function videodecet:Initialize(imagedoc, imagefile, pointfile)
  
  self.converter = colorspaceconverter.new();
  self.needUpdateLandmark = false;
  -- FIXME(hhl) DEBUG ONLY +++
  self.useBVTSignal = true ;
  -- FIXME(hhl) DEBUG ONLY ---

  -- 在加载完成贴纸时候,再设置到faceseg打开或者关闭检测项目
  self.stickerActions = {} ;

  

  -- 创建一个伪摄像头数据,用于反序列化加载素材,在真正渲染之前会更新
  self.mCamTexStream = apolloengine.TextureStream();
  self.mCamTexStream:SetStreamType(mathfunction.vector2(16, 16), apolloengine.TextureEntity.PF_R8G8B8);
  self.mCamTexEntity = apolloengine.TextureEntity();
  self.mCamTexEntity:PushMetadata(
          apolloengine.TextureBufferMetadata(
                  apolloengine.TextureEntity.TU_WRITE,
                  1, false,
                  apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
                  apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
                  apolloengine.TextureEntity.TF_LINEAR,
                  apolloengine.TextureEntity.TF_LINEAR,
                  self.mCamTexStream ));
  self.mCamTexEntity:SetKeepSource(true);
  self.mCamTexEntity:CreateResource();
  apolloengine.DeviceResource:PushDeviceResource(
          apolloengine.DeviceResource.DEVICE_CAPTURE,
          self.mCamTexEntity);

    --新帧回调
  self.newframecallback = {}
  setmetatable(self.newframecallback, {__mode = "v"})
  self.node = apollonode.QuadNode()
  self.node:CreateResource("comm:documents/material/imageblit.material");
  --renderqueue:Before(self.node);
  renderqueue:Prev(self.node)
  self.cnnSegMark = false;
  self.isShowBaseVide = true;
  self.isAdvanced = false;

end


function videodecet:Swicth2LinearSpace(isAdvanced)
  LOG("VIDEO::sRGB::TRANSFER::START");
  if isAdvanced == true then
    local viewSize = apolloengine.Framework:GetResolution();
    local isSRGB2Linear = true;
    local LayerMask = "andVideoDetectGTL";
    self.converter:Initialize_sRGB_Transfer(nil, isSRGB2Linear, mathfunction.vector2(viewSize:x(), viewSize:y()), LayerMask);
    self.converter:SetCamTexEntity(self.mCamTexEntity);
  else
    self.converter:Delete_sRGB_Transfer();
  end
  self.isAdvanced = isAdvanced;
end


function videodecet:ShowKeypoint(isshow)  
end

function videodecet:AddNewframeCallback(func)
  table.insert(self.newframecallback, func);
end


function videodecet:RemoveNewframeCallback(func)
  local len = #self.newframecallback
  for i = 1, len do
    if func == self.newframecallback[i] then
      table.remove(self.newframecallback, i)
    end
  end
end


function videodecet:_UpdateLandmark()

  self.keyPointArray = mathfunction.vector2array();
  self.extrakeyPointArray = mathfunction.vector2array();
  local inputs = likeapp.AI:GetRawarray();
  local extraPoints = likeapp.AI:GetExtraFacePoints();
  local facecount = #inputs / facepointcount;
  for f=1, facecount do
    local fi = Faceinfo(self.size);
    local beginindex = (f-1)*facepointcount;
    local extrapointIndex = (f-1)*extrakeypointcount;
    
    for i=1, keypointcount, 2 do
      fi:PushKeypoint(inputs[beginindex + i], inputs[beginindex + i + 1]);
      local point = mathfunction.vector2(inputs[beginindex + i], inputs[beginindex + i + 1]);
      self.keyPointArray:PushBack(point);
    end
    
    if extraPoints ~= nil and #extraPoints > 0 then 
      for i = 1, extrakeypointcount, 2 do
        fi:PushExtraKeypoint(extraPoints[extrapointIndex + i], extraPoints[extrapointIndex + i + 1]);
        local point = mathfunction.vector2(extraPoints[extrapointIndex + i], extraPoints[extrapointIndex + i + 1]);
        self.extrakeyPointArray:PushBack(point);
      end
    end

    fi:PushRotation(inputs[beginindex + keypointcount + 1], inputs[beginindex + keypointcount + 2], inputs[beginindex + keypointcount + 3]);
    table.insert(self.faces, fi);
  end

end

function videodecet:PushNewFaceLandMark()
  local newFaceLandMarks = {};
  local index = 1 ;
  for _, face in pairs(self.faces) do
    local keypointArray = face:GetKeypointArray();
    for _, one in pairs(keypointArray) do
      local x, y = face:toAbsoluteCoordinates(one);
      newFaceLandMarks[index]   = x;
      newFaceLandMarks[index+1] = y;
      index = index + 2 ;
    end
    local pry = face:GetRotation()
    newFaceLandMarks[index] = pry[1]
    newFaceLandMarks[index + 1] = pry[2]
    newFaceLandMarks[index + 2] = pry[3]
    index = index + 3
  end
  
  if #newFaceLandMarks % (106 * 2 + 3) == 0 then 
    likeapp.AI:PushNewFaceLandMark(newFaceLandMarks);
  end
end

function videodecet:PushNewFaceAdavanceLandmark()
  local newFaceAdavanceLandmark = {};
  local index = 1 ;
  for _, face in pairs(self.faces) do
    local extraKeypointArray = face:GetExtraKeypointArray();
    for _, one in pairs(extraKeypointArray) do
      local x, y = face:toAbsoluteCoordinates(one);
      newFaceAdavanceLandmark[index]   = x;
      newFaceAdavanceLandmark[index+1] = y;
      index = index + 2 ;
    end
  end
  if #newFaceAdavanceLandmark % (134 * 2) == 0 then
    likeapp.AI:PushNewFaceAdavanceLandmark(newFaceAdavanceLandmark);
  end
end


function videodecet:_UpdateActions()
  self.actioninfos = {}
  for i=1, defined.max_head_target_count do--和windows行为一直，有人脸就插入空动作数组
    local actions = {};
    table.insert(self.actioninfos, actions);
  end
  local inputs = likeapp.AI:GetMotionResult();
  if inputs and #inputs ~= 0 then
    --LOG("_UpdateActions" .. #inputs );
    --for i=1, #inputs, 0 do
    local i = 1 ;
    local headcount = 1;
    while( i <= #inputs )
    do
      --LOG("i = " .. i );
      local count = inputs[i];
      local actions = self.actioninfos[headcount];
      headcount = headcount + 1;
      i = i + 1;
      for j=1,count do
        local actionid = inputs[i];
        local cx = inputs[i + 1];
        local cy = inputs[i + 2];
        local rl = inputs[i + 3];
        local rt = inputs[i + 4];
        local rr = inputs[i + 5];
        local rb = inputs[i + 6];
        i = i + actionpointcount;
        local ai = Actioninfo(self.size);
        ai:PushActionID(actionid);
        ai:PushCenter(cx, cy);
        ai:PushRect(rl, rt, rr, rb);
        table.insert(actions, ai);
      end
    end
  end


  -- 如果需要手势分类 设置手势动作
  if faceseg:GetSegmentMark(videodefined.detectType.HandClassify) then
    local handData = faceseg:GetSegKeypointArray(videodefined.detectType.HandClassify)
    if handData ~= nil and handData:Size() > 1 then -- Size==1 只有头部,代表没有有效手势
      local header  = handData:Get(1);
      local handNums = header:x();
      --LOG("handNums "..handNums)
      if( (handData:Size()-1) == handNums * 5 ) then

        local personID = 1

        for i = 2, handNums*5+1, 5 do

          local actions = self.actioninfos[personID]; -- bvt不区分人 暂时把手势分布在各个人动作中
          if actions == nil then
            actions = {}
            table.insert(self.actioninfos, actions);
          end
          personID = personID + 1 ;


          local handinfo = handData:Get( i );
          local handId = handinfo:x();
          local handAction = handinfo:y();
          local handRectXY = handData:Get( i + 1 );
          local handRectWH  = handData:Get( i + 2 );
          local handCenterXY = handData:Get( i + 3 );
          local handFingerUp = handData:Get(i + 4);
          --LOG("handId "..handId..";handAction "..handAction)
          --LOG("handRectXY "..handRectXY:x().." "..handRectXY:y());
          --LOG("handRectWH "..handRectWH:x().." "..handRectWH:y());
          --LOG("handCenterXY "..handCenterXY:x().." "..handCenterXY:y());

          local ai = Actioninfo(self.size);
          ai:PushActionID(handAction);
          ai:PushCenter( handCenterXY:x(), handCenterXY:y() );
          ai:PushRect( handRectXY:x(), handRectXY:y(), handRectXY:x()+handRectWH:x(), handRectXY:y()+handRectWH:y());
          ai:PushHandFingerUp(handFingerUp:y());
          table.insert(actions, ai);

        end
      else
        ERROR("Size Not Match handNums="..tostring(handNums).." handData="..tostring(handData:Size()))
      end
    --elseif handData ~= nil then
    --  WARNING("HandSize is  "..handData:Size() );
    end

  end
end

function videodecet:_UpdateBodyPoints()
  self.bodypoints = {}
  local inputs = likeapp.AI:GetKeyPoints();
  for i=1, bodykeypoints do
    table.insert(self.bodypoints, inputs[i]);
  end  
end

function videodecet:SetCnnSegMark(mark)
  self.cnnSegMark = mark;
  --cnnseg:SetCnnSegMark(mark);
end



function videodecet:Update(def)

  self.actioninfos = {}
  self.faces = {}

  if self.size then
    self.needUpdateLandmark = true;
    --self:_UpdateLandmark();
    --(hhl)由于手势检测在UpdateActions中(检测并更新actioninfos),需要先更新图像数据(faceseg:Update)
    --(hhl)faceseg::Update会标记newUpdate和更新yuv图像ts，标记newUpdate之后GetSegTextureAndBox就会检测
    --(hhl)另外染发分割依赖人脸检测,所以updateLandMark依旧要保证在faceseg::Update之前
    --self:_UpdateActions(); --hhl

    --[[local cnnSegMark = cnnseg:GetSegmentMark();
    if(not cnnseg:IsInitialize() and cnnSegMark)
    then
      cnnseg:Initialize(self.size[1], self.size[2]);
    end
    if(cnnSegMark)
    then
        cnnseg:Update(nil,def);
    end]]

    faceseg:Initialize(self.size[1], self.size[2]);
    faceseg:Update(self.mCamTexStream,def);

    self:_UpdateActions();

  end
  for _, func in ipairs(self.newframecallback) do
    func();
  end
  return true;
end

--得到当前的人脸信息
function videodecet:GetFaces()
  if self.needUpdateLandmark then
    self:_UpdateLandmark();
    self.needUpdateLandmark = false;
  end
  return self.faces;
end

--只要关键点？猜测如此，要不然接口就不是vector2array了
function videodecet:GetPixelFacekeypointArray()
  return self.keyPointArray;
end


function videodecet:GetExtraPixelFacekeypointArray()
  return self.extrakeyPointArray;
end



function videodecet:SetTexture(size, texid)  
  LOG("video size w: "..size[1].." h: "..size[2]);
  self.size = size;
  if size and texid then
    local tex = apolloengine.TextureEntity();
    tex:PushMetadata(
      apolloengine.TextureResourceMetadata(
        mathfunction.vector2(size[1], size[2]),
        texid,
        apolloengine.TextureEntity.PF_YUV420P,
        true -- C++ ITextureResource::RefrenceTexture
      ));
    tex:CreateResource();
    self.mCamTexEntity = tex;
    self.mCamTexStream = tex:GetSourceStream();

    
     if self.isAdvanced == true then
     self.converter:SetCamTexEntity(self.mCamTexEntity);
     self.node:SetParameter(apolloengine.ShaderEntity.TEXTURE_DIFFUSE, self.converter.sRGB_Transfer.texture);
    else
      self.node:SetParameter(apolloengine.ShaderEntity.TEXTURE_DIFFUSE, self.mCamTexEntity);
    end

  else
    ERROR("empty size or texid");
  end
end

function videodecet:ActiveActions(actions)
  for _ , value in pairs(actions) do
    table.insert(self.stickerActions,value)
  end
end

--加载玩素材之后 根据素材的配置 启动相关检测
function videodecet:launchDetectFlag()

  local actions = self.stickerActions ;
  if likeapp.AI.ActiveActions then
    -- FIXME(hhl) DEBUG ONLY+++
    if self.useBVTSignal then
      -- FIXME(hhl) DEBUG ONLY---

      LOG("actions "..#actions);

      local newAction = {}
      for key, value in pairs(actions) do
        local handDetectFlag = bitop.band(value,videodefined.handActionType) ;
        local faceDynamicExpressDetectFlag = bitop.band(value,videodefined.faceDynamicExpressType)
        LOG("value = "..value..", hand = "..handDetectFlag..", face = "..faceDynamicExpressDetectFlag );
        if handDetectFlag ~= 0 then
          LOG("Hand Detect ON");
          faceseg:SetSegMark(videodefined.detectType.HandClassify,true);
        --elseif faceDynamicExpressDetectFlag ~= 0 then
          -- TODO(hhl) Android/IOS disable FaceDetect in venus
          --LOG("Face Detect ON");
          --faceseg:SetSegMark(videodefined.detectType.Face,true);
        else --过滤掉所有的手势动作
          table.insert(newAction,value);
        end
      end

      if #newAction ~= 0 then
        likeapp.AI:ActiveActions(newAction);
      else
        WARNING("ActiveActions actions filter none callback");
      end
      -- FIXME(hhl) DEBUG ONLY+++
    else
      likeapp.AI:ActiveActions(actions);
    end
    -- FIXME(hhl) DEBUG ONLY---
  else
    WARNING("function likeapp.AI.ActiveActions not found");
  end

end

--释放素材时候 清理所有的检测标记
function videodecet:resetDetectFlag()
  self.stickerActions = {} ;
  faceseg:SetSegMark(videodefined.detectType.HandClassify,false);
  if _PLATFORM_WINDOWS then
    faceseg:SetSegMark(videodefined.detectType.Face,false);
  end
end

function videodecet:GetActions()
  return self.actioninfos;
end

function videodecet:GetBodyPoints()
  return self.bodypoints;
end

--得到当前的视屏纹理 TextureEntity
function videodecet:GetVideoTexture()
  return self.mCamTexEntity;
end


function videodecet:GetVideoSRGBTexture()
  return self.converter:GetVideoSRGBTexture();
end

-- FIXME(hhl) DEBUG ONLY +++
function videodecet:switchHandSignal(useBVT)
  ERROR( "videodecet:switchHandSignal = "..tostring(useBVT) );
  self.useBVTSignal = useBVT ;
end
-- FIXME(hhl) DEBUG ONLY ---

function videodecet:SetShow(isShow)
  if self.isShowBaseVideo ~= isShow then
    self.isShowBaseVideo = isShow;
    self.node:SetShow(isShow);
  end
end

function videodecet:GetVideoSize()
  return self.size;
end

-- 返回Camera对应TextureEntity中的TextureStream
function videodecet:GetVideoFrame()
  return self.mCamTexStream;
end

function videodecet:GetVideoFrameRGB()
  return self.mCamTexStream;
end

function videodecet:SetBodyPoints()
  
end

function videodecet:GetExtrapoints()
  return likeapp.AI:GetExtraFacePoints();
end

return videodecet;
