local venuscore = require "venuscore"
local apolloengine = require "apolloengine"

require "utility"

local SmartEnhanceProxy = {}

local DISABLE = 0;
local TRANSITION = 1;
local ENABLE = 2;

function SmartEnhanceProxy:Init(camera)
    if self:IsInit() ~= true then
        self.post = camera:CreatePostEffect();
        self.post:CreateResource("comm:script/apolloengine/posteffect/smart_enhance.lua")
        self.state = DISABLE;
    end
end

function SmartEnhanceProxy:IsInit()
    if self.post ~= nil then
        return true
    else
        return false
    end
end

function SmartEnhanceProxy:Enable(level, shiftMs)
    if self:IsInit() == true and self.state == DISABLE then
        self.post:SetScriptParameter("model_level", level);
        self.post:Enable();
        if shiftMs > 0 then
            self.firstUpdated = true;
            self.shiftMs = shiftMs;
            self.state = TRANSITION;
            self.post:SetScriptParameter("split_ratio", 0.0);
        else
            self.state = ENABLE;
            self.post:SetScriptParameter("split_ratio", 1.0);
        end
    end
end

function SmartEnhanceProxy:Disable()
    if self:IsInit() == true and self.state ~= DISABLE then
        self.post:Disable();
        self.state = DISABLE;
    end
end

function SmartEnhanceProxy:OnUpdated(deltaTs)
    if self:IsInit() == true and self.state == TRANSITION then
        if self.firstUpdated == true then   --过滤掉首次回调deltaTs可能过大
            self.firstUpdated = false;
            self.timeOffset = 0;
        else
            self.timeOffset = self.timeOffset + deltaTs;
        end
        if self.timeOffset * 1000 < self.shiftMs then
            --LOG("[OnUpdated] timeOffset = "..tostring(self.timeOffset));
            self.post:SetScriptParameter("split_ratio", self.timeOffset * 1000 / self.shiftMs);
        else
            self.post:SetScriptParameter("split_ratio", 1.0);
            self.state = ENABLE;
        end
    end
end

return SmartEnhanceProxy
