local venusjson = require "venusjson"
local venuscore = require "venuscore"
local apollonode = require "apolloutility.apollonode"
local renderqueue = require "apolloutility.renderqueue"

local posteffectfilter = {}

function posteffectfilter:Initialize(cameraLayer)
  self.filter = nil;
  self.cameraLayer = cameraLayer
end

function posteffectfilter:_SplitConfig(rootconfig) 
  self.scriptfile = rootconfig.script;
  self.config = rootconfig.config;
end

function posteffectfilter:_GetFileDir(path)
  return string.match(path, "(.+)/[^/]*%.%w+$");
end

function posteffectfilter:_GetFileName(path)
  return string.match(path, "[^/]+$");
end

function posteffectfilter:LoadConfig(path)
  local fileDir = self:_GetFileDir(path);
  local rootdir = fileDir.."/";   
  local rootconfig = venusjson.LaodJsonFile(path);
  if rootconfig == nil then
    return false
  end

  if rootconfig.posteffectfilter == nil then
    return false
  end
  
  self:_SplitConfig(rootconfig.posteffectfilter);

  if (not self.scriptfile) then
    self.post = nil;
    return false;
  end

  venuscore.IFileSystem:SetResourcePath(rootdir);

  local scriptpath = self.scriptfile;
  local func,errorstr = loadfile(venuscore.IFileSystem:PathAssembly(scriptpath));
  if not errorstr then
    local filter = func();
    
    filter:Initialize(self.cameraLayer, self.config);
    self.filter = filter;
  else
    ERROR("Can not load script file "..scriptpath)
    return false
  end
  return true;
end 

function posteffectfilter:Update(def)
  if self.filter then
    self.filter:Update(def);
  end
end

function posteffectfilter:ReleaseResource()
  if self.filter then
    self.filter:Exit();
    self.filter = nil;
  end
end

function posteffectfilter:SetShow(show)
  if self.filter then
    self.filter:SetShow(show)
  end
end

return posteffectfilter;
