local rendernode = require "apolloutility.apollonode.rendernode"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"
local facedefined = require "facecute.facechange.facedefined"
local trianglenode = rendernode:extend();
function trianglenode:new()
  trianglenode.super.new(self);
 --[[ self.vertexstream = apolloengine.VertexStream();--创建顶点流
  self.vertexstream:SetVertexType(apolloengine.ShaderEntity.ATTRIBUTE_POSITION,
    apolloengine.VertexBufferEntity.DT_FLOAT,
    apolloengine.VertexBufferEntity.DT_HALF_FLOAT,
    4);
  
  	self.vertexstream:SetVertexType(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0,
		apolloengine.VertexBufferEntity.DT_FLOAT,
		apolloengine.VertexBufferEntity.DT_HALF_FLOAT,
		2);
  
   apolloengine.ShaderEntity.ATTRIBUTE_FACECOORDNATESTD =
    apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.ATTRIBUTE,
      "ATTRIBUTE_FACECOORDNATESTD");
    
    self.vertexstream:SetVertexType(apolloengine.ShaderEntity.ATTRIBUTE_FACECOORDNATESTD,
		apolloengine.VertexBufferEntity.DT_FLOAT,
		apolloengine.VertexBufferEntity.DT_HALF_FLOAT,
		2);
    
    
    
  self.indicesstream = apolloengine.IndicesStream();--创建索引流 
  self.indicesstream:SetIndicesType(
    apolloengine.IndicesBufferEntity.IT_UINT16);
  
  self.indexCount = 0;
  self.isFullFace = false;]]
end

local function IsTriOk(faceTexPoints,index1,index2,index3)--faceTexPoints start from 0
  
--if(true) then
  -- return true;
--end
  
 --[[ if(faceTexPoints[2*index1]>0 or  faceTexPoints[2*index2]>0 or faceTexPoints[2*index3]>0 )
  then
    return true;
  else
    return false;
  end
  
  return false;]]
  
  if(faceTexPoints[2*index1]<0 and  faceTexPoints[2*index2]<0 and faceTexPoints[2*index3]<0)
  then
    return false;
  end
  
  if(faceTexPoints[2*index1]>1 and  faceTexPoints[2*index2]>1 and faceTexPoints[2*index3]>1)
  then
    return false;
  end
  
  
  if(faceTexPoints[2*index1+1]<0 and  faceTexPoints[2*index2+1]<0 and faceTexPoints[2*index3+1]<0)
  then
    return false;
  end
  
  if(faceTexPoints[2*index1+1]>1 and  faceTexPoints[2*index2+1]>1 and faceTexPoints[2*index3+1]>1)
  then
    return false;
  end
  
  return true;
  
end


function trianglenode:IsFullFace(faceTexPoints)
   local len = (table.getn(faceTexPoints)+1)/2;
   local minx=100;
   local maxx=-100;
   for i=1,len do
     if(faceTexPoints[2*(i-1)]<minx)
     then
       minx = faceTexPoints[2*(i-1)];
     end
    if(faceTexPoints[2*(i-1)]>maxx)
     then
       maxx = faceTexPoints[2*(i-1)];
     end
   end
   
   
   local dx = maxx-minx;
   if(dx>1.1)
   then
      return false;
   end
   return true;
      
   
end



function trianglenode:CreateRenderResource(materialpath, rendermode, vertexstream, indicesstream, isMakeup)
  self.render:PushMetadata(
    apolloengine.RenderObjectMaterialMetadata(
      apolloengine.PathMetadata(materialpath)));
  
  if indicesstream then
    if isMakeup == true then
      self.render:PushMetadata(
	       	apolloengine.RenderObjectMeshMetadate( 
			rendermode,
      apolloengine.ReferenceVertexSharedMetadata(        
        apolloengine.VertexBufferEntity.MU_DYNAMIC,--使用可以修改的显存区域
        vertexstream,facedefined.makeupfaceSharedStr[1]..self.headIndex),
      apolloengine.ReferenceIndicesSharedMetadata(
        apolloengine.VertexBufferEntity.MU_STATIC,--使用不可修改的显存区域
        indicesstream,facedefined.makeupfaceSharedStr[2])));
    else
      self.render:PushMetadata(
	       	apolloengine.RenderObjectMeshMetadate( 
			rendermode,
      apolloengine.ReferenceVertexSharedMetadata(        
        apolloengine.VertexBufferEntity.MU_DYNAMIC,--使用可以修改的显存区域
        vertexstream,facedefined.faceSharedStr[1]..self.headIndex),
      apolloengine.ReferenceIndicesSharedMetadata(
        apolloengine.VertexBufferEntity.MU_STATIC,--使用不可修改的显存区域
        indicesstream,facedefined.faceSharedStr[2])));
    end
  else
    self.render:PushMetadata(
		apolloengine.RenderObjectMeshMetadate( 
			rendermode,
      apolloengine.ReferenceVertexMetadata(        
        apolloengine.VertexBufferEntity.MU_DYNAMIC,--使用可以修改的显存区域
        vertexstream)));
  end  
  return self.render:CreateResource();
end
--
function trianglenode:CreateResource(faceVecPoints, faceTexs,faceTexPtAdd,faceTris, material,imgSize,screencen2)
  
 --[[ local pointcount = facedefined.facePointCount+facedefined.facePointInterCount;
  local addPtCount = table.getn(faceTexPtAdd)/2;
  --self.vertexstream:ReserveBuffer(pointcount+addPtCount);--预先分配pointcount个顶点的内存
  local  triIndexCount = facedefined.faceTriIndexCount;
  local  addIndexCount = table.getn(facedefined.faceIndexAdd);
  self.indicesstream:ReserveBuffer(triIndexCount+addIndexCount);--预先分配triIndexCount个索引
  local imgWidth = imgSize[1];
  local imgHeight = imgSize[2];
  
  for i=1, pointcount do
      self.vertexstream:PushVertexData(
      apolloengine.ShaderEntity.ATTRIBUTE_POSITION,
      mathfunction.vector4(faceVecPoints[2*i-1],faceVecPoints[2*i],0,1)
      );
  end
  
  for i=1, addPtCount do
      self.vertexstream:PushVertexData(
      apolloengine.ShaderEntity.ATTRIBUTE_POSITION,
      mathfunction.vector4(screencen2[1],screencen2[2],0,1));     
  end
  local faceTexPoints ={};
  local faceDtCount = facedefined.facePointCount;
  for i=0,faceDtCount-1 do
      faceTexPoints[2*i]   =  faceTexs[2*(i+1)-1]/imgWidth;
      faceTexPoints[2*i+1] =  faceTexs[2*(i+1)]/imgHeight;
  end
  
  local offset = 0;
  faceTexPoints[(faceDtCount + 0+offset) * 2 + 0] = faceTexPoints[(33+offset) * 2 + 0] + (faceTexPoints[(33+offset) * 2 + 0] - faceTexPoints[(52+offset) * 2 + 0]) * 0.35;
  faceTexPoints[(faceDtCount + 0+offset) * 2 + 1] = faceTexPoints[(33+offset) * 2 + 1] + (faceTexPoints[(33+offset) * 2 + 1] - faceTexPoints[(52+offset) * 2 + 1]) * 0.35;
  faceTexPoints[(faceDtCount + 1+offset) * 2 + 0] = faceTexPoints[(42+offset) * 2 + 0] + (faceTexPoints[(42+offset) * 2 + 0] - faceTexPoints[(61+offset) * 2 + 0]) * 0.35;
  faceTexPoints[(faceDtCount + 1+offset) * 2 + 1] = faceTexPoints[(42+offset) * 2 + 1] + (faceTexPoints[(42+offset) * 2 + 1] - faceTexPoints[(61+offset) * 2 + 1]) * 0.35;
  faceTexPoints[(faceDtCount + 2+offset) * 2 + 0] = faceTexPoints[(34+offset) * 2 + 0] + (faceTexPoints[(34+offset) * 2 + 0] - faceTexPoints[(64+offset) * 2 + 0]) * 1.0;
  faceTexPoints[(faceDtCount + 2+offset) * 2 + 1] = faceTexPoints[(34+offset) * 2 + 1] + (faceTexPoints[(34+offset) * 2 + 1] - faceTexPoints[(64+offset) * 2 + 1]) * 1.0;
  faceTexPoints[(faceDtCount + 3+offset) * 2 + 0] = faceTexPoints[(35+offset) * 2 + 0] + (faceTexPoints[(35+offset) * 2 + 0] - faceTexPoints[(65+offset) * 2 + 0]) * 1.0;
  faceTexPoints[(faceDtCount + 3+offset) * 2 + 1] = faceTexPoints[(35+offset) * 2 + 1] + (faceTexPoints[(35+offset) * 2 + 1] - faceTexPoints[(65+offset) * 2 + 1]) * 1.0;
  faceTexPoints[(faceDtCount + 4+offset) * 2 + 0] = faceTexPoints[(36+offset) * 2 + 0] + (faceTexPoints[(36+offset) * 2 + 0] - faceTexPoints[(66+offset) * 2 + 0]) * 1.0;
  faceTexPoints[(faceDtCount + 4+offset) * 2 + 1] = faceTexPoints[(36+offset) * 2 + 1] + (faceTexPoints[(36+offset) * 2 + 1] - faceTexPoints[(66+offset) * 2 + 1]) * 1.0;
  faceTexPoints[(faceDtCount + 5+offset) * 2 + 0] = faceTexPoints[(37+offset) * 2 + 0] + (faceTexPoints[(37+offset) * 2 + 0] - faceTexPoints[(67+offset) * 2 + 0]) * 2.0;
  faceTexPoints[(faceDtCount + 5+offset) * 2 + 1] = faceTexPoints[(37+offset) * 2 + 1] + (faceTexPoints[(37+offset) * 2 + 1] - faceTexPoints[(67+offset) * 2 + 1]) * 2.0;
  faceTexPoints[(faceDtCount + 6+offset) * 2 + 0] = faceTexPoints[(38+offset) * 2 + 0] + (faceTexPoints[(38+offset) * 2 + 0] - faceTexPoints[(68+offset) * 2 + 0]) * 2.0;
  faceTexPoints[(faceDtCount + 6+offset) * 2 + 1] = faceTexPoints[(38+offset) * 2 + 1] + (faceTexPoints[(38+offset) * 2 + 1] - faceTexPoints[(68+offset) * 2 + 1]) * 2.0;
  faceTexPoints[(faceDtCount + 7+offset) * 2 + 0] = faceTexPoints[(39+offset) * 2 + 0] + (faceTexPoints[(39+offset) * 2 + 0] - faceTexPoints[(69+offset) * 2 + 0]) * 1.0;
  faceTexPoints[(faceDtCount + 7+offset) * 2 + 1] = faceTexPoints[(39+offset) * 2 + 1] + (faceTexPoints[(39+offset) * 2 + 1] - faceTexPoints[(69+offset) * 2 + 1]) * 1.0;
  faceTexPoints[(faceDtCount + 8+offset) * 2 + 0] = faceTexPoints[(40+offset) * 2 + 0] + (faceTexPoints[(40+offset) * 2 + 0] - faceTexPoints[(70+offset) * 2 + 0]) * 1.0;
  faceTexPoints[(faceDtCount + 8+offset) * 2 + 1] = faceTexPoints[(40+offset) * 2 + 1] + (faceTexPoints[(40+offset) * 2 + 1] - faceTexPoints[(70+offset) * 2 + 1]) * 1.0;
  faceTexPoints[(faceDtCount + 9+offset) * 2 + 0] = faceTexPoints[(41+offset) * 2 + 0] + (faceTexPoints[(41+offset) * 2 + 0] - faceTexPoints[(71+offset) * 2 + 0]) * 1.0;
  faceTexPoints[(faceDtCount + 9+offset) * 2 + 1] = faceTexPoints[(41+offset) * 2 + 1] + (faceTexPoints[(41+offset) * 2 + 1] - faceTexPoints[(71+offset) * 2 + 1]) * 1.0;
  
  for i=0,pointcount-1 do
		  self.vertexstream:PushVertexData(
      apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0,
      mathfunction.vector2(faceTexPoints[2*i],faceTexPoints[2*i+1]));
  end
  
  local texLen = (table.getn(faceTexPoints)+1)/2;
  local texPtAddLen = table.getn(faceTexPtAdd)/2;
  for i =1,texPtAddLen do
        self.vertexstream:PushVertexData(
      apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0,
      mathfunction.vector2(faceTexPtAdd[2*i-1],faceTexPtAdd[2*i]));
    faceTexPoints[2*(texLen+i-1)]=faceTexPtAdd[2*i-1];
    faceTexPoints[2*(texLen+i-1)+1]=faceTexPtAdd[2*i];
  end
  
  local facetexstd = self.facecoverpri.faceTexPri;
  local texstdlen = #facetexstd/2;
   for i =1,texstdlen do
        self.vertexstream:PushVertexData(
      apolloengine.ShaderEntity.ATTRIBUTE_FACECOORDNATESTD,
      mathfunction.vector2(facetexstd[2*i-1],facetexstd[2*i]));
  end
  
  
  
  self.isFullFace = self:IsFullFace(faceTexPoints);
  
 if(true or self.isFullFace) 
 then
   local indiceAdd = facedefined.faceIndexAdd;
   local len = table.getn(indiceAdd);
    for j=1,len/3 do
       if(  IsTriOk(faceTexPoints,indiceAdd[3*j-2],indiceAdd[3*j-1],indiceAdd[3*j]))
        then
          self.indicesstream:PushIndicesData(indiceAdd[3*j-2]);
          self.indicesstream:PushIndicesData(indiceAdd[3*j-1]);
          self.indicesstream:PushIndicesData(indiceAdd[3*j]);
          self.indexCount =   self.indexCount +3;
        end
    end
  end
  
  local tri={};
  for j=1,triIndexCount/3 do
      tri[0]=faceTris[3*j-2]-1;
      tri[1]=faceTris[3*j-1]-1;
      tri[2]=faceTris[3*j]-1;
      if( IsTriOk(faceTexPoints,tri[0],tri[1],tri[2]))
      then 
        if( (true or self.isFullFace) and((tri[0]>105 and tri[0]<116) or(tri[1]>105 and tri[1]<116) or (tri[2]>105 and tri[2]<116)))
        then
        else
           self.indicesstream:PushIndicesData(tri[0]);
           self.indicesstream:PushIndicesData(tri[1]);
           self.indicesstream:PushIndicesData(tri[2]);
           self.indexCount =   self.indexCount +3;
            
        end
      end
  end
  
  if(true or self.isFullFace) 
  then
    local indiceAux ={33,64,34,41,71,42};
    local adLen = table.getn(indiceAux)
    for i=1,adLen/3 do
        if( IsTriOk(faceTexPoints,indiceAux[3*i-2],indiceAux[3*i-1],indiceAux[3*i]))
        then
          self.indicesstream:PushIndicesData(indiceAux[3*i-2]);
          self.indicesstream:PushIndicesData(indiceAux[3*i-1]);
          self.indicesstream:PushIndicesData(indiceAux[3*i]);
          self.indexCount =   self.indexCount +3;
        end
    end
  end]]
--local indiceAdd ={116,37,38,117,0,33,117,33,34,117,34,35,117,35,36,116,36,37,117,36,116,116,38,39,116,39,40,118,40,41,118,41,42,118,42,32,116,40,118,117,119,0,119,1,0,119,2,1,119,3,2,119,4,3,119,5,4,119,6,5,119,7,6,119,8,7,119,9,8,121,9,119,121,10,9,121,11,10,121,12,11,121,13,12,121,14,13,121,15,14,121,16,15,118,32,120,120,32,31,120,31,30,120,30,29,120,29,28,120,28,27,120,27,26,120,26,25,120,25,24,120,24,23,120,23,122,122,23,22,122,22,21,122,21,20,122,20,19,122,19,18,122,18,17,122,17,16,122,16,121,117,116,123,123,116,118};
  -- LOG( self.indexCount)
  --LOG("---------")
  --加入渲染数据
  --第三个参数修改为索引模式（RM_TRIANGLES等）

 --[[ trianglenode.super.CreateResource(
    self,
    material,
    apolloengine.RenderComponent.RM_TRIANGLES,
    self.vertexstream,
    self.indicesstream);]]
  self.vertexstream = self.facecoverpri.vertexstream;
  self.indicesstream = self.facecoverpri.indicesstream;  
  
  if self.indicesstream == nil then 
    self.indicesstream  = self.facecoverpri.makeupindicesstream;
    self:CreateRenderResource(
    material,
    apolloengine.RenderComponent.RM_TRIANGLES,
    self.vertexstream,
    self.indicesstream,true);
  else
    self:CreateRenderResource(
    material,
    apolloengine.RenderComponent.RM_TRIANGLES,
    self.vertexstream,
    self.indicesstream);
  end
    
end
return trianglenode;