local url       = require "socket.url"
local ltn12     = require "ltn12"

local _U = {}

local function fmt(p, ...)
    if select('#', ...) == 0 then
        return p
    end
    return string.format(p, ...)
end

local function tprintf(t, p, ...)
    t[#t+1] = fmt(p, ...)
end

local function parse_image_file(image_path)
  local file_name = string.match(image_path, "[^/]+$")  
  local file_ext = string.match(image_path, "[^.]+$")  
  file_ext:lower()
  local content_type = nil
  if (string.match(file_ext, "png")) then
    content_type = "image/png"
  elseif string.match(file_ext, "jpg") or string.match(file_ext, "jpeg") then
    content_type = "image/jpeg"
  end
  return file_name, content_type;
end

local function encode_header(form_name, image_path, boundary)
  local r = {}
  tprintf(r, "--%s\r\n", boundary)
  tprintf(r, "content-disposition: form-data; name=\"%s\"", form_name)
  local file_name, contect_type = parse_image_file(image_path)
  tprintf(r, "; filename=\"%s\"", file_name)
  tprintf(r, "\r\ncontent-type: %s", contect_type)
  tprintf(r, "\r\n\r\n")
  local s = table.concat(r)
  return ltn12.source.string(s), #s
end

function _U.gen_boundary()
  local t = {"BOUNDARY-"}
  for i=2,17 do t[i] = string.char(math.random(65, 90)) end
  t[18] = "-BOUNDARY"
  return table.concat(t)
end

function _U.encode(form_name, image_path, boundary)
  local fh = io.open(image_path, "rb")
  local fh_length = fh:seek("end")
  fh:seek("set", 0)
  
  local len = 0
  local end_flag = fmt("--%s--\r\n", boundary)
  
  local sources, n = {}, 1 
  sources[n], len = encode_header(form_name, image_path, boundary)
  sources[n+1] = ltn12.source.file(fh)
  sources[n+2] = ltn12.source.string("\r\n")
  sources[n+3] = ltn12.source.string(end_flag)
  local unpack = unpack or table.unpack
  local source = ltn12.source.cat(unpack(sources))
  local content_len = len + fh_length + 2 + #end_flag
  --io.close(fh)
  return source, content_len
end

return _U;