local makeup_base = require "behavior.makeup.makeup_base"
local apolloengine = require "apolloengine"
local makeup_common = require "behavior.makeup.makeup_common"
local cv = require "computervisionfunction"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"
local vc = require "venuscore"

local makeup_bvtmask = makeup_base:extend("makeup_bvtmask")

local mask_InfoBvt = mathfunction.vector4(0,0,0,1);
local useBvtMask = mathfunction.vector1(1);
local videoSize = mathfunction.vector2(0,0);

function makeup_bvtmask:new()
  makeup_bvtmask.super.new(self);
  self.segment = nil;
  self.EdgeFeatherRadius = 1;
end
--处理SegmentComponent组件初始化
function makeup_bvtmask:IInitialParameters()

end
--处理SegmentComponent组件数据
function makeup_bvtmask:IUpdateParameters()
  self.segment = self:GetSegmentComponent();
  self.render = self:BGetRender();
  if self.render and self.segment then
    self.segment.EdgeFeatherRadius = self.EdgeFeatherRadius;
    local materialEntity = self.render.MaterialEntities[1];
    local pos = self.segment:GetData(cv.SegmentComponent.mlRectPosition)[cv.SegmentComponent.mlRectPosition];
    local size = self.segment:GetData(cv.SegmentComponent.mlRectSize)[cv.SegmentComponent.mlRectSize];

    if pos and size then
      mask_InfoBvt:Set(pos[1],pos[2],size[1],size[2]);
      materialEntity:SetParameter("_MaskInfoBvt",mask_InfoBvt);
    end 
    materialEntity:SetParameter("_UseBvtMask",useBvtMask);
    materialEntity:SetParameter("_MaskMap",self.segment:GetMask());
    self.recognition = self:BGetRecongnition();
    if self.recognition then
      local videoFrame = self.recognition:GetDetectSize();
      if videoFrame then
        videoSize:Set(videoFrame:x(),videoFrame:y());
        materialEntity:SetParameter("_VideoSize",videoSize);
      end
    end
  end
end

function makeup_bvtmask:GetSegmentComponent()
  if nil ~= self.Node then
    self.segment = self.Node:GetComponent(apolloengine.Node.CT_CV_SEGMENT);
    if nil == self.segment then
      ERROR("[makeup_bvtmask]"..makeup_common.makeup_types[self:BGetMakeupType()].key..": We Have No Segment Component!")
    end
    return self.segment;
  end
end
function makeup_bvtmask:ISetFaceID()
  self.segment = self:GetSegmentComponent();
  if self.segment then
    self.segment.FaceID = self.FaceID;
  end
end

makeup_bvtmask:MemberRegister("EdgeFeatherRadius",venuscore.ScriptTypes.IntType());

-- function makeup_bvtmask:SetExpandRatioX(in_expandRatioX)
--   self.expandRatioX = in_expandRatioX;
--   if self.segment then
--     self.segment.ExpandRatioX_FaceParse = self.expandRatioX;
--   end
-- end
-- function makeup_bvtmask:GetExpandRatioX()
--   return self.expandRatioX;
-- end

-- function makeup_bvtmask:SetExpandRatioY(in_expandRatioY)
--   self.expandRatioY = in_expandRatioY;
--   if self.segment then
--     self.segment.ExpandRatioY_FaceParse = self.expandRatioY;
--   end
-- end
-- function makeup_bvtmask:GetExpandRatioY()
--   return self.expandRatioY;
-- end
-- makeup_bvtmask:MemberRegister(
--      "Expand RatioX",
--      vc.ScriptTypes.FloatType(
--        1.0, 1.1,
--        makeup_bvtmask.GetExpandRatioX,
--        makeup_bvtmask.SetExpandRatioX
-- ));
-- makeup_bvtmask:MemberRegister(
--      "Expand RatioY",
--      vc.ScriptTypes.FloatType(
--        1.0, 1.1,
--        makeup_bvtmask.GetExpandRatioY,
--        makeup_bvtmask.SetExpandRatioY
-- ));
return makeup_bvtmask