local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"
local Object = require "classic"
local apolloDefine = require "apolloutility.defined"


local PointRender = Object:extend();

function PointRender:new(count, color)
  local scene = apolloengine.SceneManager:GetOrCreateScene(apolloDefine.default_scene_name);
  self.node = scene:CreateNode(apolloengine.Node.CT_NODE);
  --self.node = apolloengine.Node();--创建基础节点
  self.render = self.node:CreateComponent(apolloengine.Node.CT_RENDER);--创建基础渲染组建
  self.vertexstream = apolloengine.VertexStream();--创建顶点流
  --设置顶点流提供位置以及纹理坐标两个属性，且原始数据格式为float格式，目标格式（显存中的数据格式）为半浮点，数据的个数为4个float和2个float
  
  self.vertexstream:SetVertexType(apolloengine.ShaderEntity.ATTRIBUTE_POSITION,
    apolloengine.VertexBufferEntity.DT_FLOAT,
    apolloengine.VertexBufferEntity.DT_HALF_FLOAT,4);
  self.vertexstream:ReserveBuffer(count);--预先分配4个顶点的内存
  
  --初始化顶点
  for i=1, count do
    self.vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_POSITION, mathfunction.vector4(0,0,0,0));
  end  

  
  self.render:PushMetadata(--传入材质原始数据
    apolloengine.RenderObjectMaterialMetadata(
      apolloengine.PathMetadata("comm:documents/material/pointrender.material")));
  
  self.render:PushMetadata(--创建可以渲染的顶点流
		apolloengine.RenderObjectMeshMetadate( 
			apolloengine.RenderComponent.RM_POINTS,
      apolloengine.ReferenceVertexMetadata(
        apolloengine.VertexBufferEntity.MU_DYNAMIC,
        self.vertexstream)));  
  self.render:CreateResource();
  
  self.render:SetParameter(
    apolloengine.ShaderEntity.POINT_COLOR,
    color);
end

function PointRender:SetShow(isshow)
  if isshow then
    self.render:SetRenderProperty(apolloengine.RenderComponent.RP_SHOW);
  else
    self.render:EraseRenderProperty(apolloengine.RenderComponent.RP_SHOW);
  end  
end

function PointRender:Update(points_table)
  local newpoint =  mathfunction.vector4(0, 0, 0, 1);
  local index = self.vertexstream:GetAttributeIndex(apolloengine.ShaderEntity.ATTRIBUTE_POSITION);
  for i=1, #points_table do
    local point = points_table[i];
    newpoint:Set(point[1], point[2], 0, 1);
    self.vertexstream:ChangeVertexDataWithAttributeFast(
      index,
      i,
      newpoint);
  end
  self.vertexstream:SetReflushInterval(1, #points_table);
  self.render:ChangeVertexBuffer(self.vertexstream);
end

return PointRender;