local rendernode = require "apolloutility.apollonode.rendernode"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local Object = require "classic"
--模型节点

local matInlucdestr=[[
%s

#OUTPUT TRUE

]]

local matModelString=[[
#%s 		%s
#MATERIAL_DEFINE %s
	RENDER_QUEUE = %s
	COLOR_MASK = %s
	ALPAH_MODE =%s
	DRAW_MODE =  %s
	STENCIL_MODE = %s
	
	VERTEX_SHADER = 
    %s
	FRAGMENT_SHADER = 
    %s
#END_DEFINE //材质定义结束

]]

local toonshader = Object:extend();

function toonshader:new()
  toonshader.super.new(self)
   self.slots ={};
   self.renderstr={};
end

function toonshader:AddProperty(slotname,t,val)
 
  local s =apolloengine.IMaterialSystem:NewParameterSlot(
    apolloengine.ShaderEntity.UNIFORM,
    slotname);
    self.slots[slotname]={s,t,val};
end

function toonshader:CreateTex(strpath)
  
    if(strpath==nil)
    then
      return nil;
    end

    local tex = apolloengine.TextureEntity();
    tex:PushMetadata(apolloengine.TextureFileMetadata(apolloengine.TextureEntity.TU_STATIC,
      apolloengine.TextureEntity.PF_AUTO,1, true,
      apolloengine.TextureEntity.TW_REPEAT,
      apolloengine.TextureEntity.TW_REPEAT,
      apolloengine.TextureEntity.TF_LINEAR,
      apolloengine.TextureEntity.TF_LINEAR_MIPMAP_LINEAR,
      strpath));
      


    local res = tex:CreateResource();
    return res and tex or nil;
end
function toonshader:GetValByType(t,val)
  
   if(t=="2d")
   then
     local tex = self:CreateTex(val);
     return tex;
     
   elseif(t=="vec4" or t=="color")
   then
     local clr =  mathfunction.vector4(val[1], val[2],val[3],val[4]);
     return clr;
   elseif(t=="vec1")
   then
     
     local t = (type(val)=="number") and val or val[1];
     local clr =  mathfunction.vector1(t);
     return clr;
   end
   
   return nil;
end

function toonshader:AddProperties(t)
 
 local len =#t;
 for i=1 ,len do

   local val = self:GetValByType(t[i][2],t[i][3]);
   self:AddProperty(t[i][1],t[i][2],val);
   
 end
end

function toonshader:SetVal(render,slotname, val)
   render:SetParameter(self.slots[slotname][1], val);  
end

function toonshader:GetMatSrc()
  
  local res = self.strInclude;
  local len = #self.renderstr;  
  for i=1,len do
    res = res..self.renderstr[i];
  end
  return res;
end

function toonshader:SetIncudeStr(str)
  self.strInclude = str;
end

function toonshader:AddRenderStr(strt)
  
  local vertexshaderstr = self.vertexshaderstr and self.vertexshaderstr or strt.vertexShaderStr;
  local fragshaderstr = self.fragshaderstr and self.fragshaderstr or strt.fragShaderStr;
  local str = string.format(matModelString,strt.renderPathName,strt.renderName,strt.renderName,
         strt.trasnparentStr,strt.colorModeStr,strt.alphaModeStr,strt.drawModeStr,strt.stencilModeStr,vertexshaderstr,fragshaderstr);
  table.insert(self.renderstr,str);
end

function toonshader:UpdateProperty(slotname,val)  
end

function toonshader:InitProperty(render)  
 -- local len = self.slots;
  --for i=1,len do
   -- self:SetVal(render,)
 --end
 
 for key, value in pairs(self.slots) do    
   
     render:SetParameter(value[1],value[3]);
    --self:SetVal(render,value[1],value[3]);
 end  
end


function toonshader:SetVertexShaderStr(str)
  self.vertexshaderstr = str;
end

function toonshader:SetFragShaderStr(str)
  self.fragshaderstr = str;
end

function toonshader:GetVertexShaderStr()
  return self.vertexshaderstr;
end

function toonshader:GetFragShaderStr()
  return self.fragshaderstr;
end


function toonshader:Parse(tb,tbpro)
  
  if(tb and tb.Shader and tb.Shader.IncludeStr)
  then
    self:SetIncudeStr(tb.Shader.IncludeStr);
  end
  
  if(tb and tb.Shader and tb.Shader.RenderPaths)
  then
    local len = #tb.Shader.RenderPaths;
    for i=1,len do
      self:AddRenderStr(tb.Shader.RenderPaths[i]);
    end
  end
  
  if(tbpro)
  then
    self:AddProperties(tbpro);
  end
  
  
end


return toonshader;
