

#SHADER_DEFINE InProgress

	FUNCTION_INPUT = 
	{
		{ EASING_PROGRESS_PRE, 		MEDIUM,	FLOAT,	"in_ProgressPre" },
	}
	FUNCTION_OUTPUT =
	{
    { EASING_PROGRESS,           MEDIUM, FLOAT,  "out_PreProgress"},
	}

#SHADER_CODE	
    float out_PreProgress = in_ProgressPre;
#END_CODE
#END_DEFINE

#SHADER_DEFINE OutProgress

	FUNCTION_INPUT = 
	{
		{ EASING_PROGRESS_POST, 		MEDIUM,	FLOAT,	"in_ProgressPost" },
	}
	FUNCTION_OUTPUT =
	{
    { EASING_PROGRESS,           MEDIUM, FLOAT,  "out_PostProgress"},
	}

#SHADER_CODE	
    float out_PostProgress = in_ProgressPost;
#END_CODE
#END_DEFINE

#SHADER_DEFINE TweenVertex

	FUNCTION_INPUT = 
	{
		{ ATTRIBUTE_POSITION, 		HIGH,	VEC4,	"in_Position" },
        { ATTRIBUTE_COORDNATE0,			MEDIUM,	VEC2,		"in_Coordinate" },
        { ATTRIBUTE_COLOR0,         MEDIUM, VEC4,   "in_Color" },
        { OUTLINE_OFFSET,              MEDIUM, VEC4,    "offset"},
        { RECT_SCALE,                MEDIUM, FLOAT,    "scale"},
	}
	FUNCTION_OUTPUT =
	{
        { SCREENSPACE_POSITION, 		HIGH,	VEC4,		"out_ScreenSpacePositionVertex" },
        { ATTRIBUTE_COORDNATE0,			MEDIUM,	VEC2,		"Out_Coordinate1" },
        { ATTRIBUTE_COLOR0,         MEDIUM, VEC4,   "out_Color" },
	}

#SHADER_CODE
    vec4 out_ScreenSpacePositionVertex = in_Position + offset * scale;
    mediump vec2 Out_Coordinate1 = in_Coordinate;
    vec4 out_Color = in_Color;
#END_CODE
#END_DEFINE


#SHADER_DEFINE TweenFragment

	FUNCTION_INPUT = 
	{
        { TEXTURE_DIFFUSE,		NONE,	TEXTURE2D,	"in_DiffuseTexture" },
		{ ATTRIBUTE_COORDNATE0,	MEDIUM,	VEC2,		 "in_Coordinate1" },
		{ RECT_SCALE,                MEDIUM, FLOAT,    "scale"},
        { OUTLINE_COLOR,             MEDIUM, VEC4,     "outlineColor"},
        { USE_INSERT_COLOR,   HIGH, FLOAT,         "useInsertColor"},
        { USE_ORIGIN_COLOR,   HIGH, FLOAT,    "useOriginColor"},
        { ATTRIBUTE_COLOR0,         MEDIUM, VEC4,   "in_Color" },
	}
  FUNCTION_OUTPUT =
  {
    { SURFACE_COLOR,	MEDIUM,	VEC4,		"out_SamplingColor" },
    { INSERT_COLOR,     HIGH,   VEC4,        "insertColor"},
  }
#SHADER_CODE
      vec4 out_SamplingColor = texture2D(in_DiffuseTexture,in_Coordinate1);
      if(useInsertColor > 0.0 && useOriginColor < 1.0){
        out_SamplingColor = vec4(in_Color.rgb, out_SamplingColor.a * in_Color.a);
        if(scale != 0.0){
            out_SamplingColor = vec4(outlineColor.rgb, out_SamplingColor.a * outlineColor.a);
        }
      }else{
        if(scale != 0.0){
            out_SamplingColor.a = out_SamplingColor.a * outlineColor.a;
        }
      }
      vec4 insertColor = vec4(1.0);
#END_CODE
#END_DEFINE


#SHADER_DEFINE TweenVertexOutput

	FUNCTION_INPUT = 
	{
		{ SCREENSPACE_POSITION,		HIGH,	VEC4,	"in_ScreenPosition" },
		{ RECT_SCALE,                MEDIUM, FLOAT,    "in_scale"},
        { DEVICE_COORDINATE_Y_FLIP,    MEDIUM, FLOAT,       "in_yflip" },
	}
	FUNCTION_OUTPUT =
    {
	    { RECT_SCALE,                MEDIUM, FLOAT,    "out_scale"},
    }

#SHADER_CODE
    vec4 scale = vec4(
        1.0f,
        in_yflip,
        1.0f,
        1.0f
    );
    float out_scale = in_scale;
    gl_Position = scale * in_ScreenPosition;
#END_CODE
#END_DEFINE


#SHADER_DEFINE TweenFragmentOutput

	FUNCTION_INPUT = 
	{
    { SURFACE_COLOR,	LOW,	VEC4,	"in_SurfaceColor" },
    { ATTRIBUTE_COLOR0,         MEDIUM, VEC4,   "in_Color" },
    { USE_ORIGIN_COLOR,   HIGH, FLOAT,    "useOriginColor"},
    { RECT_SCALE,                MEDIUM, FLOAT,    "scale"},
    { OUTLINE_COLOR,             MEDIUM, VEC4,     "outlineColor"},
    { USE_INSERT_COLOR,   HIGH, FLOAT,         "useInsertColor"},
	}
  FUNCTION_OUTPUT =
  {
  }
#SHADER_CODE
    if(scale > 0.0){
        gl_FragColor = vec4(outlineColor.rgb * (1.0 - useInsertColor) + in_SurfaceColor.rgb * useInsertColor, in_SurfaceColor.a);
    }else{
        gl_FragColor = vec4((in_SurfaceColor.rgb * useOriginColor + (in_Color.rgb * (1.0 - useInsertColor) + in_SurfaceColor.rgb * useInsertColor) * (1.0 - useOriginColor)),in_SurfaceColor.a);
    }
#END_CODE
#END_DEFINE


#SHADER_DEFINE AlphaIn

	FUNCTION_INPUT = 
	{
    { ALPHA_EASING_VALUE,              MEDIUM, FLOAT,  "in_Easing"},
    { AlphaInStartV,             MEDIUM, FLOAT,  "in_AlphaStartVIn" },
    { AlphaInEndV,               MEDIUM, FLOAT,  "in_AlphaEndVIn" },
	}
	FUNCTION_OUTPUT =
	{
    { ALPHA_VALUE_PRE,                 MEDIUM, FLOAT,  "out_AlphaPre" },
	}

#SHADER_CODE	
    float alphaVIn = in_AlphaStartVIn + (in_AlphaEndVIn - in_AlphaStartVIn) * in_Easing;
    float out_AlphaPre = alphaVIn;
#END_CODE
#END_DEFINE

#SHADER_DEFINE AlphaOut

	FUNCTION_INPUT = 
	{
    { ALPHA_EASING_VALUE,              MEDIUM, FLOAT,  "in_Easing"},
    { SURFACE_COLOR,				    MEDIUM,	VEC4,		"in_SurfaceColor" },
    { AlphaOutStartV,             MEDIUM, FLOAT,  "in_AlphaStartVOut" },
    { AlphaOutEndV,               MEDIUM, FLOAT,  "in_AlphaEndVOut" },
    { ALPHA_VALUE_PRE,                 MEDIUM, FLOAT,  "in_AlphaPre" },
	}
	FUNCTION_OUTPUT =
	{
    { SURFACE_COLOR,				    MEDIUM,	VEC4,		"out_SurfaceColor" },
	}

#SHADER_CODE	
    float alphaVOut = in_AlphaStartVOut + (in_AlphaEndVOut - in_AlphaStartVOut) * in_Easing;
    alphaVOut = alphaVOut * in_AlphaPre;
    vec4 out_SurfaceColor = vec4(in_SurfaceColor.rgb,in_SurfaceColor.a * alphaVOut);
#END_CODE
#END_DEFINE

#SHADER_DEFINE PositionTweenConst

	FUNCTION_INPUT = 
	{
    { SCREENSPACE_POSITION, 		HIGH,	VEC4,		  "in_ScreenSpacePosition" },
	}
	FUNCTION_OUTPUT =
	{
    { POSITION_PRE, 		            HIGH,	VEC4,		  "out_PositionPre" },
	}

#SHADER_CODE	
    vec4 out_PositionPre = in_ScreenSpacePosition;
#END_CODE
#END_DEFINE

#SHADER_DEFINE PositionIn

	FUNCTION_INPUT = 
	{
    { SCREENSPACE_POSITION, 		HIGH,	VEC4,		  "in_ScreenSpacePositionIn" },
    { POSITION_EASING_VALUE,              MEDIUM, FLOAT,  "in_EasingV"},
    { PositionInStartV,             MEDIUM, VEC3,  "in_PositionStartVIn" },
    { PositionInEndV,               MEDIUM, VEC3,  "in_PositionEndVIn" },
    { RECT_CENTER,               MEDIUM, VEC4,      "rectCenter"},
	}
	FUNCTION_OUTPUT =
	{
    { POSITION_PRE, 		            HIGH,	VEC4,		  "out_PositionPre" },
    { SCREENSPACE_POSITION, 		HIGH,	VEC4,		  "out_ScreenSpacePositionIn" },
    { RECT_CENTER,               MEDIUM, VEC4,      "out_rectCenter"},
	}

#SHADER_CODE	
    vec3 moveValueIn = in_PositionStartVIn + (in_PositionEndVIn - in_PositionStartVIn) * in_EasingV;
    vec4 out_ScreenSpacePositionIn = vec4(in_ScreenSpacePositionIn.xyz + moveValueIn,in_ScreenSpacePositionIn.w);
    vec4 out_rectCenter = vec4(rectCenter.xyz + moveValueIn,rectCenter.w);
    //vec2 moveValuePre = 0.2 * in_EasingV * vec2(0.0,1.0); //写死，最多移动20个像素
    //vec4 out_PositionPre = vec4(in_ScreenSpacePosition.x + moveValuePre.x,in_ScreenSpacePosition.y + moveValuePre.y,in_ScreenSpacePosition.z,in_ScreenSpacePosition.w);
#END_CODE
#END_DEFINE

#SHADER_DEFINE PositionOut

	FUNCTION_INPUT = 
	{
    { SCREENSPACE_POSITION, 		HIGH,	VEC4,		  "in_ScreenSpacePositionOut" },
    { POSITION_EASING_VALUE,              MEDIUM, FLOAT,  "in_EasingV"},
    { POSITION_PRE, 		        HIGH,	VEC4,		  "in_PositionPre" },
    { PositionOutStartV,             MEDIUM, VEC3,  "in_PositionStartVOut" },
    { PositionOutEndV,               MEDIUM, VEC3,  "in_PositionEndVOut" },
	}
	FUNCTION_OUTPUT =
	{
    { SCREENSPACE_POSITION, 		    HIGH,	VEC4,		  "out_ScreenSpacePositionOut" },
	}

#SHADER_CODE	
    vec3 moveValueOut = in_PositionStartVOut + (in_PositionEndVOut - in_PositionStartVOut) * in_EasingV;
    vec4 out_ScreenSpacePositionOut = vec4(in_ScreenSpacePositionOut.xyz + moveValueOut, in_ScreenSpacePositionOut.w);
    //vec2 endPositionPost = vec2(in_ScreenSpacePosition.x,in_ScreenSpacePosition.y + 0.2);
    //vec2 moveValuePost = startPositionPost + (endPositionPost - startPositionPost) * vec2(0.0,1.0) * in_EasingV;
    //vec4 out_ScreenSpacePosition = vec4(moveValuePost.x,moveValuePost.y,in_ScreenSpacePosition.z,in_ScreenSpacePosition.w);
    
#END_CODE
#END_DEFINE

#SHADER_DEFINE SliceLTRIn

	FUNCTION_INPUT =
	{
        { SLICE_EASING_VALUE,              MEDIUM, FLOAT,  "in_Easing"},
        { SliceInStartV,             MEDIUM, FLOAT,  "in_SliceStartVIn" },
        { SliceInEndV,               MEDIUM, FLOAT,  "in_SliceEndVIn" },
        { ATTRIBUTE_COORDNATE0,	MEDIUM,	VEC2,		 "in_Coordinate1" },
        { SURFACE_COLOR,				    MEDIUM,	VEC4,		"in_SurfaceColor" },
	}
	FUNCTION_OUTPUT =
	{
        { SURFACE_COLOR,				    MEDIUM,	VEC4,		"out_SurfaceColor" },
	}

#SHADER_CODE
    float distanceIn = 0.3;
    vec4 out_SurfaceColor = in_SurfaceColor;
    if(in_Easing < 1.0){
        float sliceVIn = in_SliceStartVIn + (in_SliceEndVIn - in_SliceStartVIn) * in_Easing;
        if(in_Easing < 0.3){
            distanceIn = in_Easing;
        }
        float pre_Alpha = 1.0 - smoothstep(sliceVIn, sliceVIn + distanceIn, in_Coordinate1.x);
        pre_Alpha = in_SurfaceColor.a * pre_Alpha;
        out_SurfaceColor = vec4(in_SurfaceColor.rgb,pre_Alpha);
    }
#END_CODE
#END_DEFINE

#SHADER_DEFINE SliceLTROut

	FUNCTION_INPUT =
	{
        { SLICE_EASING_VALUE,              MEDIUM, FLOAT,  "in_Easing"},
        { SURFACE_COLOR,				    MEDIUM,	VEC4,		"in_SurfaceColor" },
        { SliceOutStartV,             MEDIUM, FLOAT,  "in_SliceStartVOut" },
        { SliceOutEndV,               MEDIUM, FLOAT,  "in_SliceEndVOut" },
        { ATTRIBUTE_COORDNATE0,	MEDIUM,	VEC2,		 "in_Coordinate1" },
	}
	FUNCTION_OUTPUT =
	{
        { SURFACE_COLOR,				    MEDIUM,	VEC4,		"out_SurfaceColor" },
	}

#SHADER_CODE
    float distanceOut = 0.3;
    vec4 out_SurfaceColor = in_SurfaceColor;
    if(in_Easing > 0.0){
        float SliceVOut = in_SliceStartVOut + (in_SliceEndVOut - in_SliceStartVOut) * in_Easing;
        if(in_Easing < 0.3){
                    distanceOut = in_Easing;
           }
        float targetAlpha = smoothstep(SliceVOut, SliceVOut + distanceOut, in_Coordinate1.x);
        targetAlpha = in_SurfaceColor.a * targetAlpha;
        out_SurfaceColor = vec4(in_SurfaceColor.rgb,targetAlpha);
    }
#END_CODE
#END_DEFINE


#SHADER_DEFINE SliceRTLIn

	FUNCTION_INPUT =
	{
        { SLICE_EASING_VALUE,              MEDIUM, FLOAT,  "in_Easing"},
        { SliceInStartV,             MEDIUM, FLOAT,  "in_SliceStartVIn" },
        { SliceInEndV,               MEDIUM, FLOAT,  "in_SliceEndVIn" },
        { ATTRIBUTE_COORDNATE0,	MEDIUM,	VEC2,		 "in_Coordinate1" },
        { SURFACE_COLOR,				    MEDIUM,	VEC4,		"in_SurfaceColor" },
	}
	FUNCTION_OUTPUT =
	{
        { SURFACE_COLOR,				    MEDIUM,	VEC4,		"out_SurfaceColor" },
	}

#SHADER_CODE
    float distanceIn = 0.3;
    vec4 out_SurfaceColor = in_SurfaceColor;
    if(in_Easing < 1.0){
        float sliceVIn = in_SliceStartVIn + (in_SliceEndVIn - in_SliceStartVIn) * in_Easing;
        if(in_Easing > 0.7){
            distanceIn = 1.0 - in_Easing;
        }
        float pre_Alpha = smoothstep(sliceVIn, sliceVIn + distanceIn, in_Coordinate1.x);
        pre_Alpha = in_SurfaceColor.a * pre_Alpha;
        out_SurfaceColor = vec4(in_SurfaceColor.rgb,pre_Alpha);
    }
#END_CODE
#END_DEFINE

#SHADER_DEFINE SliceRTLOut

	FUNCTION_INPUT =
	{
        { SLICE_EASING_VALUE,              MEDIUM, FLOAT,  "in_Easing"},
        { SURFACE_COLOR,				    MEDIUM,	VEC4,		"in_SurfaceColor" },
        { SliceOutStartV,             MEDIUM, FLOAT,  "in_SliceStartVOut" },
        { SliceOutEndV,               MEDIUM, FLOAT,  "in_SliceEndVOut" },
        { ATTRIBUTE_COORDNATE0,	MEDIUM,	VEC2,		 "in_Coordinate1" },
	}
	FUNCTION_OUTPUT =
	{
        { SURFACE_COLOR,				    MEDIUM,	VEC4,		"out_SurfaceColor" },
	}

#SHADER_CODE
    float distanceOut = 0.3;
    vec4 out_SurfaceColor = in_SurfaceColor;
    if(in_Easing > 0.0){
        float SliceVOut = in_SliceStartVOut + (in_SliceEndVOut - in_SliceStartVOut) * in_Easing;
        if(in_Easing > 0.7){
            distanceOut = 1.0 - in_Easing;
        }
        float targetAlpha = 1.0 - smoothstep(SliceVOut, SliceVOut + distanceOut, in_Coordinate1.x);
        targetAlpha = in_SurfaceColor.a * targetAlpha;
        out_SurfaceColor = vec4(in_SurfaceColor.rgb,targetAlpha);
    }
#END_CODE
#END_DEFINE

#SHADER_DEFINE ScaleS2BIn

	FUNCTION_INPUT =
	{
        { SCREENSPACE_POSITION, 		HIGH,	VEC4,		  "in_ScreenSpacePositionIn" },
        { SCALE_EASING_VALUE,              MEDIUM, FLOAT,  "in_EasingV"},
        { ScaleInStartV,             MEDIUM, FLOAT,  "in_ScaleStartVIn" },
        { ScaleInEndV,               MEDIUM, FLOAT,  "in_ScaleEndVIn" },
        { RECT_CENTER,               MEDIUM, VEC4,      "rectCenter"},
	}
	FUNCTION_OUTPUT =
	{
        { SCREENSPACE_POSITION, 		HIGH,	VEC4,		  "out_ScreenSpacePositionIn" },
	}

#SHADER_CODE
    vec4 out_ScreenSpacePositionIn = in_ScreenSpacePositionIn;
    out_ScreenSpacePositionIn = in_ScreenSpacePositionIn + (in_ScreenSpacePositionIn - rectCenter) * (in_ScaleEndVIn - in_ScaleStartVIn) * in_EasingV;
#END_CODE
#END_DEFINE

#SHADER_DEFINE ScaleS2BOut

	FUNCTION_INPUT =
	{
        { SCREENSPACE_POSITION, 		HIGH,	VEC4,		  "in_ScreenSpacePositionOut" },
        { SCALE_EASING_VALUE,              MEDIUM, FLOAT,  "in_EasingV"},
        { ScaleOutStartV,             MEDIUM, FLOAT,  "in_ScaleStartVOut" },
        { ScaleOutEndV,               MEDIUM, FLOAT,  "in_ScaleEndVOut" },
        { RECT_CENTER,               MEDIUM, VEC4,      "rectCenter"},
	}
	FUNCTION_OUTPUT =
	{
        { SCREENSPACE_POSITION, 		    HIGH,	VEC4,		  "out_ScreenSpacePositionOut" },
	}

#SHADER_CODE
    vec4 out_ScreenSpacePositionOut = in_ScreenSpacePositionOut;
    if(in_EasingV > 0.0){
        out_ScreenSpacePositionOut = in_ScreenSpacePositionOut + (in_ScreenSpacePositionOut - rectCenter) * (in_ScaleEndVOut - in_ScaleStartVOut) / in_ScaleStartVOut * in_EasingV;
    }
#END_CODE
#END_DEFINE

#SHADER_DEFINE ScaleB2SIn

	FUNCTION_INPUT =
	{
        { SCREENSPACE_POSITION, 		HIGH,	VEC4,		  "in_ScreenSpacePositionIn" },
        { SCALE_EASING_VALUE,              MEDIUM, FLOAT,  "in_EasingV"},
        { ScaleInStartV,             MEDIUM, FLOAT,  "in_ScaleStartVIn" },
        { ScaleInEndV,               MEDIUM, FLOAT,  "in_ScaleEndVIn" },
        { RECT_CENTER,               MEDIUM, VEC4,      "rectCenter"},
	}
	FUNCTION_OUTPUT =
	{
        { SCREENSPACE_POSITION, 		HIGH,	VEC4,		  "out_ScreenSpacePositionIn" },
	}

#SHADER_CODE
    vec4 out_ScreenSpacePositionIn = in_ScreenSpacePositionIn;
    out_ScreenSpacePositionIn = in_ScreenSpacePositionIn + (in_ScreenSpacePositionIn - rectCenter) * (in_ScaleStartVIn - in_ScaleEndVIn) * (1.0 - in_EasingV);
#END_CODE
#END_DEFINE

#SHADER_DEFINE ScaleB2SOut

	FUNCTION_INPUT =
	{
        { SCREENSPACE_POSITION, 		HIGH,	VEC4,		  "in_ScreenSpacePositionOut" },
        { SCALE_EASING_VALUE,              MEDIUM, FLOAT,  "in_EasingV"},
        { ScaleOutStartV,             MEDIUM, FLOAT,  "in_ScaleStartVOut" },
        { ScaleOutEndV,               MEDIUM, FLOAT,  "in_ScaleEndVOut" },
        { RECT_CENTER,               MEDIUM, VEC4,      "rectCenter"},
	}
	FUNCTION_OUTPUT =
	{
        { SCREENSPACE_POSITION, 		    HIGH,	VEC4,		  "out_ScreenSpacePositionOut" },
	}

#SHADER_CODE
    vec4 out_ScreenSpacePositionOut = in_ScreenSpacePositionOut;
    if(in_EasingV > 0.0){
        out_ScreenSpacePositionOut = in_ScreenSpacePositionOut + (in_ScreenSpacePositionOut - rectCenter) * (in_ScaleEndVOut - in_ScaleStartVOut) / in_ScaleStartVOut  *  in_EasingV;
    }
#END_CODE
#END_DEFINE



#SHADER_DEFINE CutHorizontalLTRIn

	FUNCTION_INPUT =
	{
        { CUT_HORIZONTAL_EASING_VALUE,              MEDIUM, FLOAT,  "in_Easing"},
        { CutHorizontalInStartV,             MEDIUM, FLOAT,  "in_SliceStartVIn" },
        { CutHorizontalInEndV,               MEDIUM, FLOAT,  "in_SliceEndVIn" },
        { ATTRIBUTE_COORDNATE0,	MEDIUM,	VEC2,		 "in_Coordinate1" },
        { SURFACE_COLOR,				    MEDIUM,	VEC4,		"in_SurfaceColor" },
        { TEXTURE_DIFFUSE,		NONE,	TEXTURE2D,	"in_DiffuseTexture" },
        { RECT_SCALE,                MEDIUM, FLOAT,    "scale"},
        { OUTLINE_COLOR,             MEDIUM, VEC4,     "outlineColor"},
	}
	FUNCTION_OUTPUT =
	{
        { SURFACE_COLOR,				    MEDIUM,	VEC4,		"out_SurfaceColor" },
	}

#SHADER_CODE
    vec4 out_SurfaceColor = in_SurfaceColor;
    if(in_Easing < 1.0){
        float sliceVIn = in_SliceStartVIn + (in_SliceEndVIn - in_SliceStartVIn) * in_Easing;
        float pre_AlphaIn = 1.0 - smoothstep(sliceVIn, sliceVIn, in_Coordinate1.x);
        vec3 tempCutColor = in_SurfaceColor.rgb;
        if(pre_AlphaIn == 1.0){
            vec2 temp = vec2(clamp(in_Coordinate1.x + 1.0 - sliceVIn, 0.0, 1.0),in_Coordinate1.y);
           vec4 offsetColor = texture2D(in_DiffuseTexture,temp);
           in_SurfaceColor.a = offsetColor.a;
           tempCutColor = offsetColor.rgb;
           if(scale != 0.0){
               in_SurfaceColor.a = in_SurfaceColor.a * outlineColor.a;
           }
       }
       pre_AlphaIn = in_SurfaceColor.a * pre_AlphaIn;
       out_SurfaceColor = vec4(tempCutColor,pre_AlphaIn);
    }
#END_CODE
#END_DEFINE

#SHADER_DEFINE CutHorizontalLTROut

	FUNCTION_INPUT =
	{
        { CUT_HORIZONTAL_EASING_VALUE,              MEDIUM, FLOAT,  "in_Easing"},
        { CutHorizontalOutStartV,             MEDIUM, FLOAT,  "in_SliceStartVOut" },
        { CutHorizontalOutEndV,               MEDIUM, FLOAT,  "in_SliceEndVOut" },
        { ATTRIBUTE_COORDNATE0,	MEDIUM,	VEC2,		 "in_Coordinate1" },
        { SURFACE_COLOR,				    MEDIUM,	VEC4,		"in_SurfaceColor" },
        { TEXTURE_DIFFUSE,		NONE,	TEXTURE2D,	"in_DiffuseTexture" },
        { RECT_SCALE,                MEDIUM, FLOAT,    "scale"},
        { OUTLINE_COLOR,             MEDIUM, VEC4,     "outlineColor"},
        { INSERT_COLOR,     HIGH,   VEC4,        "insertColor"},
        { USE_INSERT_COLOR,   HIGH, FLOAT,         "useInsertColor"},
	}
	FUNCTION_OUTPUT =
	{
        { SURFACE_COLOR,				    MEDIUM,	VEC4,		"out_SurfaceColor" },
	}

#SHADER_CODE
    vec4 out_SurfaceColor = in_SurfaceColor;
    if(in_Easing > 0.0){
        float sliceVOut = in_SliceStartVOut + (in_SliceEndVOut - in_SliceStartVOut) * in_Easing;
        float pre_AlphaOut = smoothstep(sliceVOut, sliceVOut, in_Coordinate1.x);
        vec3 tempCutColor = in_SurfaceColor.rgb;
        if(pre_AlphaOut == 1.0){
            vec2 temp = vec2(clamp(in_Coordinate1.x - sliceVOut, 0.0, 1.0),in_Coordinate1.y);
            vec4 offsetColor = texture2D(in_DiffuseTexture,temp);
            in_SurfaceColor.a = offsetColor.a;
            tempCutColor = offsetColor.rgb;
            if(useInsertColor > 0.0){
                tempCutColor = insertColor.rgb;
                in_SurfaceColor.a *= insertColor.a;
            }
            if(scale != 0.0 && useInsertColor <= 0.0){
                in_SurfaceColor.a = in_SurfaceColor.a * outlineColor.a;
            }
        }
        pre_AlphaOut = in_SurfaceColor.a * pre_AlphaOut;
        out_SurfaceColor = vec4(tempCutColor,pre_AlphaOut);
    }
#END_CODE
#END_DEFINE

#SHADER_DEFINE CutHorizontalRTLIn

	FUNCTION_INPUT =
	{
        { CUT_HORIZONTAL_EASING_VALUE,              MEDIUM, FLOAT,  "in_Easing"},
        { CutHorizontalInStartV,             MEDIUM, FLOAT,  "in_SliceStartVIn" },
        { CutHorizontalInEndV,               MEDIUM, FLOAT,  "in_SliceEndVIn" },
        { ATTRIBUTE_COORDNATE0,	MEDIUM,	VEC2,		 "in_Coordinate1" },
        { SURFACE_COLOR,				    MEDIUM,	VEC4,		"in_SurfaceColor" },
        { TEXTURE_DIFFUSE,		NONE,	TEXTURE2D,	"in_DiffuseTexture" },
        { RECT_SCALE,                MEDIUM, FLOAT,    "scale"},
         { OUTLINE_COLOR,             MEDIUM, VEC4,     "outlineColor"},
	}
	FUNCTION_OUTPUT =
	{
        { SURFACE_COLOR,				    MEDIUM,	VEC4,		"out_SurfaceColor" },
	}

#SHADER_CODE
    vec4 out_SurfaceColor = in_SurfaceColor;
    if(in_Easing < 1.0){
        float sliceVIn = in_SliceStartVIn + (in_SliceEndVIn - in_SliceStartVIn) * in_Easing;
        float pre_AlphaIn = smoothstep(sliceVIn, sliceVIn, in_Coordinate1.x);
        vec3 tempCutColor = in_SurfaceColor.rgb;
        if(pre_AlphaIn == 1.0){
            vec2 temp = vec2(clamp(in_Coordinate1.x - sliceVIn, 0.0, 1.0),in_Coordinate1.y);
           vec4 offsetColor = texture2D(in_DiffuseTexture,temp);
          in_SurfaceColor.a = offsetColor.a;
          tempCutColor = offsetColor.rgb;
          if(scale != 0.0){
              in_SurfaceColor.a = in_SurfaceColor.a * outlineColor.a;
          }
      }
      pre_AlphaIn = in_SurfaceColor.a * pre_AlphaIn;
      out_SurfaceColor = vec4(tempCutColor,pre_AlphaIn);
    }
#END_CODE
#END_DEFINE

#SHADER_DEFINE CutHorizontalRTLOut

	FUNCTION_INPUT =
	{
        { CUT_HORIZONTAL_EASING_VALUE,              MEDIUM, FLOAT,  "in_Easing"},
        { CutHorizontalOutStartV,             MEDIUM, FLOAT,  "in_SliceStartVOut" },
        { CutHorizontalOutEndV,               MEDIUM, FLOAT,  "in_SliceEndVOut" },
        { ATTRIBUTE_COORDNATE0,	MEDIUM,	VEC2,		 "in_Coordinate1" },
        { SURFACE_COLOR,				    MEDIUM,	VEC4,		"in_SurfaceColor" },
        { TEXTURE_DIFFUSE,		NONE,	TEXTURE2D,	"in_DiffuseTexture" },
        { RECT_SCALE,                MEDIUM, FLOAT,    "scale"},
        { OUTLINE_COLOR,             MEDIUM, VEC4,     "outlineColor"},
        { INSERT_COLOR,     HIGH,   VEC4,        "insertColor"},
        { USE_INSERT_COLOR,   HIGH, FLOAT,         "useInsertColor"},
	}
	FUNCTION_OUTPUT =
	{
        { SURFACE_COLOR,				    MEDIUM,	VEC4,		"out_SurfaceColor" },
	}

#SHADER_CODE
    vec4 out_SurfaceColor = in_SurfaceColor;
    if(in_Easing > 0.0){
        float sliceVOut = in_SliceStartVOut + (in_SliceEndVOut - in_SliceStartVOut) * in_Easing;
        float pre_AlphaOut = 1.0 - smoothstep(sliceVOut, sliceVOut, in_Coordinate1.x);
        vec3 tempCutColor = in_SurfaceColor.rgb;
        if(pre_AlphaOut == 1.0){
            vec2 temp = vec2(clamp(in_Coordinate1.x + 1.0 - sliceVOut, 0.0, 1.0),in_Coordinate1.y);
            vec4 offsetColor = texture2D(in_DiffuseTexture,temp);
            in_SurfaceColor.a = offsetColor.a;
            tempCutColor = offsetColor.rgb;
            if(useInsertColor > 0.0){
                tempCutColor = insertColor.rgb;
                in_SurfaceColor.a *= insertColor.a;
            }
            if(scale != 0.0 && useInsertColor <= 0.0){
                in_SurfaceColor.a = in_SurfaceColor.a * outlineColor.a;
            }
        }
        pre_AlphaOut = in_SurfaceColor.a * pre_AlphaOut;
        out_SurfaceColor = vec4(tempCutColor,pre_AlphaOut);
    }
#END_CODE
#END_DEFINE

#SHADER_DEFINE CutVerticalT2BIn

	FUNCTION_INPUT =
	{
        { CUT_VERTICAL_EASING_VALUE,              MEDIUM, FLOAT,  "in_Easing"},
        { CutVerticalInStartV,             MEDIUM, FLOAT,  "in_SliceStartVIn" },
        { CutVerticalInEndV,               MEDIUM, FLOAT,  "in_SliceEndVIn" },
        { ATTRIBUTE_COORDNATE0,	MEDIUM,	VEC2,		 "in_Coordinate1" },
        { SURFACE_COLOR,				    MEDIUM,	VEC4,		"in_SurfaceColor" },
        { TEXTURE_DIFFUSE,		NONE,	TEXTURE2D,	"in_DiffuseTexture" },
        { RECT_SCALE,                MEDIUM, FLOAT,    "scale"},
         { OUTLINE_COLOR,             MEDIUM, VEC4,     "outlineColor"},
	}
	FUNCTION_OUTPUT =
	{
        { SURFACE_COLOR,				    MEDIUM,	VEC4,		"out_SurfaceColor" },
	}

#SHADER_CODE
    vec4 out_SurfaceColor = in_SurfaceColor;
    if(in_Easing < 1.0){
        float sliceVIn = in_SliceStartVIn + (in_SliceEndVIn - in_SliceStartVIn) * in_Easing;
        float pre_AlphaIn = smoothstep(sliceVIn, sliceVIn, in_Coordinate1.y);
        vec3 tempCutColor = in_SurfaceColor.rgb;
        if(pre_AlphaIn == 1.0){
            vec2 temp = vec2(in_Coordinate1.x,clamp(in_Coordinate1.y + sliceVIn, 0.0, 1.0));
             vec4 offsetColor = texture2D(in_DiffuseTexture,temp);
              in_SurfaceColor.a = offsetColor.a;
              tempCutColor = offsetColor.rgb;
              if(scale != 0.0){
                  in_SurfaceColor.a = in_SurfaceColor.a * outlineColor.a;
              }
          }
          pre_AlphaIn = in_SurfaceColor.a * pre_AlphaIn;
          out_SurfaceColor = vec4(tempCutColor,pre_AlphaIn);
    }
#END_CODE
#END_DEFINE

#SHADER_DEFINE CutVerticalT2BOut

	FUNCTION_INPUT =
	{
        { CUT_VERTICAL_EASING_VALUE,              MEDIUM, FLOAT,  "in_Easing"},
        { CutVerticalOutStartV,             MEDIUM, FLOAT,  "in_SliceStartVOut" },
        { CutVerticalOutEndV,               MEDIUM, FLOAT,  "in_SliceEndVOut" },
        { ATTRIBUTE_COORDNATE0,	MEDIUM,	VEC2,		 "in_Coordinate1" },
        { SURFACE_COLOR,				    MEDIUM,	VEC4,		"in_SurfaceColor" },
        { TEXTURE_DIFFUSE,		NONE,	TEXTURE2D,	"in_DiffuseTexture" },
        { RECT_SCALE,                MEDIUM, FLOAT,    "scale"},
        { OUTLINE_COLOR,             MEDIUM, VEC4,     "outlineColor"},
        { INSERT_COLOR,     HIGH,   VEC4,        "insertColor"},
        { USE_INSERT_COLOR,   HIGH, FLOAT,         "useInsertColor"},
	}
	FUNCTION_OUTPUT =
	{
        { SURFACE_COLOR,				    MEDIUM,	VEC4,		"out_SurfaceColor" },
	}

#SHADER_CODE
    vec4 out_SurfaceColor = in_SurfaceColor;
    if(in_Easing > 0.0){
        float sliceVOut = in_SliceStartVOut + (in_SliceEndVOut - in_SliceStartVOut) * in_Easing;
        float pre_AlphaOut = 1.0 - smoothstep(sliceVOut, sliceVOut, in_Coordinate1.y);
        vec3 tempCutColor = in_SurfaceColor.rgb;
        if(pre_AlphaOut == 1.0){
            vec2 temp = vec2(in_Coordinate1.x,clamp(in_Coordinate1.y - 1.0 + sliceVOut, 0.0, 1.0));
            vec4 offsetColor = texture2D(in_DiffuseTexture,temp);
            in_SurfaceColor.a = offsetColor.a;
            tempCutColor = offsetColor.rgb;
           if(useInsertColor > 0.0){
               tempCutColor = insertColor.rgb;
               in_SurfaceColor.a *= insertColor.a;
             }
           if(scale != 0.0 && useInsertColor <= 0.0){
               in_SurfaceColor.a = in_SurfaceColor.a * outlineColor.a;
           }
        }
        pre_AlphaOut = in_SurfaceColor.a * pre_AlphaOut;
        out_SurfaceColor = vec4(tempCutColor,pre_AlphaOut);
    }
#END_CODE
#END_DEFINE

#SHADER_DEFINE CutVerticalB2TIn

	FUNCTION_INPUT =
	{
        { CUT_VERTICAL_EASING_VALUE,              MEDIUM, FLOAT,  "in_Easing"},
        { CutVerticalInStartV,             MEDIUM, FLOAT,  "in_SliceStartVIn" },
        { CutVerticalInEndV,               MEDIUM, FLOAT,  "in_SliceEndVIn" },
        { ATTRIBUTE_COORDNATE0,	MEDIUM,	VEC2,		 "in_Coordinate1" },
        { SURFACE_COLOR,				    MEDIUM,	VEC4,		"in_SurfaceColor" },
        { TEXTURE_DIFFUSE,		NONE,	TEXTURE2D,	"in_DiffuseTexture" },
        { RECT_SCALE,                MEDIUM, FLOAT,    "scale"},
        { OUTLINE_COLOR,             MEDIUM, VEC4,     "outlineColor"},
	}
	FUNCTION_OUTPUT =
	{
        { SURFACE_COLOR,				    MEDIUM,	VEC4,		"out_SurfaceColor" },
	}

#SHADER_CODE
    vec4 out_SurfaceColor = in_SurfaceColor;
    if(in_Easing < 1.0){
        float sliceVIn = in_SliceStartVIn + (in_SliceEndVIn - in_SliceStartVIn) * in_Easing;
        float pre_AlphaIn = 1.0 - smoothstep(sliceVIn, sliceVIn, in_Coordinate1.y);
        vec3 tempCutColor = in_SurfaceColor.rgb;
        if(pre_AlphaIn == 1.0){
            vec2 temp = vec2(in_Coordinate1.x,clamp(in_Coordinate1.y - 1.0 + sliceVIn, 0.0, 1.0));
             vec4 offsetColor = texture2D(in_DiffuseTexture,temp);
              in_SurfaceColor.a = offsetColor.a;
              tempCutColor = offsetColor.rgb;
              if(scale != 0.0){
                  in_SurfaceColor.a = in_SurfaceColor.a * outlineColor.a;
              }
          }
          pre_AlphaIn = in_SurfaceColor.a * pre_AlphaIn;
          out_SurfaceColor = vec4(tempCutColor,pre_AlphaIn);
    }
#END_CODE
#END_DEFINE

#SHADER_DEFINE CutVerticalB2TOut

	FUNCTION_INPUT =
	{
        { CUT_VERTICAL_EASING_VALUE,              MEDIUM, FLOAT,  "in_Easing"},
        { CutVerticalOutStartV,             MEDIUM, FLOAT,  "in_SliceStartVOut" },
        { CutVerticalOutEndV,               MEDIUM, FLOAT,  "in_SliceEndVOut" },
        { ATTRIBUTE_COORDNATE0,	MEDIUM,	VEC2,		 "in_Coordinate1" },
        { SURFACE_COLOR,				    MEDIUM,	VEC4,		"in_SurfaceColor" },
        { TEXTURE_DIFFUSE,		NONE,	TEXTURE2D,	"in_DiffuseTexture" },
        { RECT_SCALE,                MEDIUM, FLOAT,    "scale"},
        { OUTLINE_COLOR,             MEDIUM, VEC4,     "outlineColor"},
        { INSERT_COLOR,     HIGH,   VEC4,        "insertColor"},
        { USE_INSERT_COLOR,   HIGH, FLOAT,         "useInsertColor"},
	}
	FUNCTION_OUTPUT =
	{
        { SURFACE_COLOR,				    MEDIUM,	VEC4,		"out_SurfaceColor" },
	}

#SHADER_CODE
    vec4 out_SurfaceColor = in_SurfaceColor;
    if(in_Easing > 0.0){
        float sliceVOut = in_SliceStartVOut + (in_SliceEndVOut - in_SliceStartVOut) * in_Easing;
        float pre_AlphaOut = smoothstep(sliceVOut, sliceVOut, in_Coordinate1.y);
        vec3 tempCutColor = in_SurfaceColor.rgb;
        if(pre_AlphaOut == 1.0){
            vec2 temp = vec2(in_Coordinate1.x,clamp(in_Coordinate1.y + sliceVOut, 0.0, 1.0));
            vec4 offsetColor = texture2D(in_DiffuseTexture,temp);
            in_SurfaceColor.a = offsetColor.a;
            tempCutColor = offsetColor.rgb;
            if(useInsertColor > 0.0){
                            tempCutColor = insertColor.rgb;
                            in_SurfaceColor.a *= insertColor.a;
                        }
                        if(scale != 0.0 && useInsertColor <= 0.0){
                            in_SurfaceColor.a = in_SurfaceColor.a * outlineColor.a;
                        }
                    }
                    pre_AlphaOut = in_SurfaceColor.a * pre_AlphaOut;
                    out_SurfaceColor = vec4(tempCutColor,pre_AlphaOut);
    }
#END_CODE
#END_DEFINE


#SHADER_DEFINE KTVLTRIn

	FUNCTION_INPUT =
	{
        { KTV_EASING_VALUE,              MEDIUM, FLOAT,  "in_Easing"},
        { KTVInStartV,             MEDIUM, FLOAT,  "in_KtvStartVIn" },
        { KTVInEndV,               MEDIUM, FLOAT,  "in_KtvEndVIn" },
        { ATTRIBUTE_COORDNATE0,	MEDIUM,	VEC2,		 "in_Coordinate1" },
        { SURFACE_COLOR,				    MEDIUM,	VEC4,		"in_SurfaceColor" },
        { TEXTURE_DIFFUSE,		NONE,	TEXTURE2D,	"in_DiffuseTexture" },
        { RECT_SCALE,                MEDIUM, FLOAT,    "scale"},
        { OUTLINE_COLOR,             MEDIUM, VEC4,     "outlineColor"},
        { IN_COVER_OUTLINE_COLOR,             MEDIUM, VEC4,     "in_cover_outline_color"},
        { IN_COVER_COLOR,           HIGH, VEC4,     "in_cover_color"},
        { INSERT_COLOR,     HIGH,   VEC4,        "in_insertColor"},
	}
	FUNCTION_OUTPUT =
	{
        { SURFACE_COLOR,				    MEDIUM,	VEC4,		"out_SurfaceColor" },
        { OUTLINE_COLOR,             MEDIUM, VEC4,     "output_outlineColor"},
        { INSERT_COLOR,     HIGH,   VEC4,        "out_insertColor"},
	}

#SHADER_CODE
    vec4 out_SurfaceColor = in_SurfaceColor;
    vec4 out_insertColor = in_cover_color;
    if(scale > 0.0){
        out_SurfaceColor = vec4(outlineColor.rgb,in_SurfaceColor.a * outlineColor.a);
        out_insertColor = in_cover_outline_color;
    }
    vec4 output_outlineColor = outlineColor;
    if(in_Easing > 0.0){
        float sliceVOut = in_KtvStartVIn + (in_KtvEndVIn - in_KtvStartVIn) * in_Easing;
        float cover = 1.0 - smoothstep(sliceVOut, sliceVOut, in_Coordinate1.x);
        vec4 tempColor = in_SurfaceColor;
        vec4 tempOutlineColor = outlineColor;
        if(cover == 1.0 && in_SurfaceColor.a > 0.0){
            tempColor= in_cover_color;
            if(scale > 0.0){
                tempOutlineColor = in_cover_outline_color;
                output_outlineColor = tempOutlineColor;
            }
            float originTexAlpha = texture2D(in_DiffuseTexture, in_Coordinate1).a;
            if(scale > 0.0){
                out_SurfaceColor = vec4(tempOutlineColor.rgb, originTexAlpha * tempOutlineColor.a);
            }else{
                out_SurfaceColor = vec4(tempColor.rgb, originTexAlpha * tempColor.a);
            }
        }
    }
#END_CODE
#END_DEFINE

#SHADER_DEFINE KTVRTLIn

	FUNCTION_INPUT =
    	{
            { KTV_EASING_VALUE,              MEDIUM, FLOAT,  "in_Easing"},
            { KTVInStartV,             MEDIUM, FLOAT,  "in_KtvStartVIn" },
            { KTVInEndV,               MEDIUM, FLOAT,  "in_KtvEndVIn" },
            { ATTRIBUTE_COORDNATE0,	MEDIUM,	VEC2,		 "in_Coordinate1" },
            { SURFACE_COLOR,				    MEDIUM,	VEC4,		"in_SurfaceColor" },
            { TEXTURE_DIFFUSE,		NONE,	TEXTURE2D,	"in_DiffuseTexture" },
            { RECT_SCALE,                MEDIUM, FLOAT,    "scale"},
            { OUTLINE_COLOR,             MEDIUM, VEC4,     "outlineColor"},
            { IN_COVER_OUTLINE_COLOR,             MEDIUM, VEC4,     "in_cover_outline_color"},
            { IN_COVER_COLOR,           HIGH, VEC4,     "in_cover_color"},
            { INSERT_COLOR,     HIGH,   VEC4,        "in_insertColor"},
    	}
    	FUNCTION_OUTPUT =
    	{
            { SURFACE_COLOR,				    MEDIUM,	VEC4,		"out_SurfaceColor" },
            { OUTLINE_COLOR,             MEDIUM, VEC4,     "output_outlineColor"},
            { INSERT_COLOR,     HIGH,   VEC4,        "out_insertColor"},
    	}

    #SHADER_CODE
        vec4 out_SurfaceColor = in_SurfaceColor;
            vec4 out_insertColor = in_cover_color;
            if(scale > 0.0){
                out_SurfaceColor = vec4(outlineColor.rgb,in_SurfaceColor.a * outlineColor.a);
                out_insertColor = in_cover_outline_color;
            }
        vec4 output_outlineColor = outlineColor;
        if(in_Easing > 0.0){
            float sliceVOut = in_KtvStartVIn + (in_KtvEndVIn - in_KtvStartVIn) * in_Easing;
            float cover = smoothstep(sliceVOut, sliceVOut, in_Coordinate1.x);
            vec4 tempColor = vec4(in_SurfaceColor.rgb, 1.0);
            vec4 tempOutlineColor = vec4(outlineColor.rgb, 1.0);
            if(cover == 1.0 && in_SurfaceColor.a > 0.0){
                tempColor= in_cover_color;
                if(scale > 0.0){
                    tempOutlineColor = in_cover_outline_color;
                    output_outlineColor = tempOutlineColor;
                }
                float originTexAlpha = texture2D(in_DiffuseTexture, in_Coordinate1).a;
                if(scale > 0.0){
                    out_SurfaceColor = vec4(tempOutlineColor.rgb, originTexAlpha * tempOutlineColor.a);
                }else{
                    out_SurfaceColor = vec4(tempColor.rgb, originTexAlpha * tempColor.a);
                }
            }
        }
#END_CODE
#END_DEFINE

#SHADER_DEFINE KTVLTROut

	FUNCTION_INPUT =
	{
        { KTV_EASING_VALUE,              MEDIUM, FLOAT,  "in_Easing"},
        { KTVOutStartV,             MEDIUM, FLOAT,  "in_KtvStartVOut" },
        { KTVOutEndV,               MEDIUM, FLOAT,  "in_KtvEndVOut" },
        { ATTRIBUTE_COORDNATE0,	MEDIUM,	VEC2,		 "in_Coordinate1" },
        { SURFACE_COLOR,				    MEDIUM,	VEC4,		"in_SurfaceColor" },
        { TEXTURE_DIFFUSE,		NONE,	TEXTURE2D,	"in_DiffuseTexture" },
        { RECT_SCALE,                MEDIUM, FLOAT,    "scale"},
        { OUTLINE_COLOR,             MEDIUM, VEC4,     "outlineColor"},
        { OUT_COVER_OUTLINE_COLOR,             MEDIUM, VEC4,     "out_cover_outline_color"},
        { OUT_COVER_COLOR,           HIGH, VEC4,     "out_cover_color"},
	}
	FUNCTION_OUTPUT =
	{
        { SURFACE_COLOR,				    MEDIUM,	VEC4,		"out_SurfaceColor" },
	}

#SHADER_CODE
    vec4 out_SurfaceColor = in_SurfaceColor;
        if(scale > 0.0){
            out_SurfaceColor = vec4(outlineColor.rgb,in_SurfaceColor.a * outlineColor.a);
        }
    if(in_Easing > 0.0){
        float sliceVOut = in_KtvStartVOut + (in_KtvEndVOut - in_KtvStartVOut) * in_Easing;
        float cover = 1.0 - smoothstep(sliceVOut, sliceVOut, in_Coordinate1.x);
        vec4 tempColor = vec4(in_SurfaceColor.rgb, 1.0);
        vec4 tempOutlineColor = vec4(outlineColor.rgb, 1.0);
        if(cover == 1.0 && in_SurfaceColor.a > 0.0){
            tempColor= out_cover_color;
            if(scale > 0.0){
                tempOutlineColor = out_cover_outline_color;
            }
            float originTexAlpha = texture2D(in_DiffuseTexture, in_Coordinate1).a;
            if(scale > 0.0){
                out_SurfaceColor = vec4(tempOutlineColor.rgb, originTexAlpha * tempOutlineColor.a);
            }else{
                out_SurfaceColor = vec4(tempColor.rgb, originTexAlpha * tempColor.a);
            }
        }
    }
#END_CODE
#END_DEFINE

#SHADER_DEFINE KTVRTLOut
FUNCTION_INPUT =
	{
        { KTV_EASING_VALUE,              MEDIUM, FLOAT,  "in_Easing"},
        { KTVOutStartV,             MEDIUM, FLOAT,  "in_KtvStartVOut" },
        { KTVOutEndV,               MEDIUM, FLOAT,  "in_KtvEndVOut" },
        { ATTRIBUTE_COORDNATE0,	MEDIUM,	VEC2,		 "in_Coordinate1" },
        { SURFACE_COLOR,				    MEDIUM,	VEC4,		"in_SurfaceColor" },
        { TEXTURE_DIFFUSE,		NONE,	TEXTURE2D,	"in_DiffuseTexture" },
        { RECT_SCALE,                MEDIUM, FLOAT,    "scale"},
        { OUTLINE_COLOR,             MEDIUM, VEC4,     "outlineColor"},
        { OUT_COVER_OUTLINE_COLOR,             MEDIUM, VEC4,     "out_cover_outline_color"},
        { OUT_COVER_COLOR,           HIGH, VEC4,     "out_cover_color"},
	}
	FUNCTION_OUTPUT =
	{
        { SURFACE_COLOR,				    MEDIUM,	VEC4,		"out_SurfaceColor" },
	}

#SHADER_CODE
    vec4 out_SurfaceColor = in_SurfaceColor;
        if(scale > 0.0){
            out_SurfaceColor = vec4(outlineColor.rgb,in_SurfaceColor.a * outlineColor.a);
        }
    if(in_Easing > 0.0){
        float sliceVOut = in_KtvStartVOut + (in_KtvEndVOut - in_KtvStartVOut) * in_Easing;
        float cover = smoothstep(sliceVOut, sliceVOut, in_Coordinate1.x);
        vec4 tempColor = vec4(in_SurfaceColor.rgb, 1.0);
        vec4 tempOutlineColor = vec4(outlineColor.rgb, 1.0);
        if(cover == 1.0 && in_SurfaceColor.a > 0.0){
            tempColor= out_cover_color;
            if(scale > 0.0){
                tempOutlineColor = out_cover_outline_color;
            }
            float originTexAlpha = texture2D(in_DiffuseTexture, in_Coordinate1).a;
            if(scale > 0.0){
                out_SurfaceColor = vec4(tempOutlineColor.rgb, originTexAlpha * tempOutlineColor.a);
            }else{
                out_SurfaceColor = vec4(tempColor.rgb, originTexAlpha * tempColor.a);
            }
        }
    }
#END_CODE
#END_DEFINE

#SHADER_DEFINE RotateIn

	FUNCTION_INPUT =
    	{
            { SCREENSPACE_POSITION, 		HIGH,	VEC4,		  "in_ScreenSpacePositionOut" },
            { ROTATE_EASING_VALUE,              MEDIUM, FLOAT,  "in_EasingV"},
            { RotateInStartV,             MEDIUM, VEC3,  "start_rotate" },
            { RotateInEndV,               MEDIUM, VEC3,  "end_rotate" },
            { RECT_CENTER,               MEDIUM, VEC4,      "rectCenter"},
    	}
    	FUNCTION_OUTPUT =
    	{
            { SCREENSPACE_POSITION, 		    HIGH,	VEC4,		  "out_ScreenSpacePositionOut" },
    	}

#SHADER_CODE
    vec3 tempangle = start_rotate + (end_rotate - start_rotate) * in_EasingV * 3.141592653589793;
    vec3 localpos = (in_ScreenSpacePositionOut - rectCenter).xyz;
    float angleX = tempangle.x;
    float angleY = tempangle.y;
    float angleZ = tempangle.z;

    float sx = sin(angleX);
    float cx = cos(angleX);

    float sy = sin(angleY);
    float cy = cos(angleY);

    float sz = sin(angleZ);
    float cz = cos(angleZ);

    mat3 rotMatrix = mat3(cz * cy, cz * sy * sx - cx * sz, sz * sx + cz * cx * sy,
                        cy * sz, cz * cx + sz * sy * sx, cx * sz  - cz * sx,
                        -sy, cy * sx, cy * cx);

    vec4 out_ScreenSpacePositionOut = vec4(localpos * rotMatrix, 1.0);
#END_CODE
#END_DEFINE











