

#SHADER_DEFINE PositionConstIn

	FUNCTION_INPUT =
	{
	}
	FUNCTION_OUTPUT =
	{
	     { POSITION_EASING_VALUE,           MEDIUM, FLOAT,  "position_out_EasingV"},
	}
#SHADER_CODE	
    float position_out_EasingV = 0.0;
#END_CODE
#END_DEFINE

#SHADER_DEFINE PositionConstOut

	FUNCTION_INPUT =
	{
	}
	FUNCTION_OUTPUT =
	{
	    { POSITION_EASING_VALUE,           MEDIUM, FLOAT,  "position_out_EasingV"},
	}
#SHADER_CODE	
    float position_out_EasingV = 0.0;
#END_CODE
#END_DEFINE

#SHADER_DEFINE PositionLinearIn

	FUNCTION_INPUT = 
	{
		{ EASING_PROGRESS, 		MEDIUM,	FLOAT,	"in_Progress" },
	}
	FUNCTION_OUTPUT =
	{
    { POSITION_EASING_VALUE,           MEDIUM, FLOAT,  "position_out_EasingV"},
	}

#SHADER_CODE	
    float position_out_EasingV = in_Progress;
#END_CODE
#END_DEFINE

#SHADER_DEFINE PositionLinearOut

	FUNCTION_INPUT = 
	{
		{ EASING_PROGRESS, 		MEDIUM,	FLOAT,	"in_Progress" },
	}
	FUNCTION_OUTPUT =
	{
    { POSITION_EASING_VALUE,           MEDIUM, FLOAT,  "position_out_EasingV"},
	}

#SHADER_CODE	
    float position_out_EasingV = in_Progress;
#END_CODE
#END_DEFINE


#SHADER_DEFINE PositionSineIn

	FUNCTION_INPUT = 
	{
		{ EASING_PROGRESS, 		MEDIUM,	FLOAT,	"in_Progress" },
	}
	FUNCTION_OUTPUT =
	{
    { POSITION_EASING_VALUE,           MEDIUM, FLOAT,  "position_out_EasingV"},
	}

#SHADER_CODE	
    float position_out_EasingV = sin((in_Progress - 1.0) * 1.5707963267948966) + 1.0;
#END_CODE
#END_DEFINE

#SHADER_DEFINE PositionSineOut

	FUNCTION_INPUT = 
	{
		{ EASING_PROGRESS, 		MEDIUM,	FLOAT,	"in_Progress" },
	}
	FUNCTION_OUTPUT =
	{
    { POSITION_EASING_VALUE,           MEDIUM, FLOAT,  "position_out_EasingV"},
	}

#SHADER_CODE	
    float position_out_EasingV = sin(in_Progress * 1.5707963267948966);
#END_CODE
#END_DEFINE


#SHADER_DEFINE PositionExponentialIn

	FUNCTION_INPUT = 
	{
		{ EASING_PROGRESS, 		MEDIUM,	FLOAT,	"in_Progress" },
	}
	FUNCTION_OUTPUT =
	{
    { POSITION_EASING_VALUE,           MEDIUM, FLOAT,  "position_out_EasingV"},
	}

#SHADER_CODE	

  float position_out_EasingV = 0.0;
  if (in_Progress == 0.0)
    position_out_EasingV = in_Progress;
  else
    position_out_EasingV = pow(2.0,10.0 * (in_Progress - 1.0));
#END_CODE
#END_DEFINE

#SHADER_DEFINE PositionExponentialOut

	FUNCTION_INPUT = 
	{
		{ EASING_PROGRESS, 		MEDIUM,	FLOAT,	"in_Progress" },
	}
	FUNCTION_OUTPUT =
	{
    { POSITION_EASING_VALUE,           MEDIUM, FLOAT,  "position_out_EasingV"},
	}

#SHADER_CODE	
  float position_out_EasingV = 0.0;
  if (in_Progress == 1.0)
    position_out_EasingV = in_Progress;
  else
    position_out_EasingV = 1.0 - pow(2.0, -10.0 * in_Progress);
#END_CODE
#END_DEFINE


#SHADER_DEFINE PositionBackIn

	FUNCTION_INPUT = 
	{
		{ EASING_PROGRESS, 		MEDIUM,	FLOAT,	"in_Progress" },
	}
	FUNCTION_OUTPUT =
	{
    { POSITION_EASING_VALUE,           MEDIUM, FLOAT,  "position_out_EasingV"},
	}

#SHADER_CODE	
  float position_out_EasingV = pow(in_Progress,3.0) - in_Progress * sin(in_Progress * 3.141592653589793);
#END_CODE
#END_DEFINE

#SHADER_DEFINE PositionBackOut

	FUNCTION_INPUT = 
	{
		{ EASING_PROGRESS, 		MEDIUM,	FLOAT,	"in_Progress" },
	}
	FUNCTION_OUTPUT =
	{
    { POSITION_EASING_VALUE,           MEDIUM, FLOAT,  "position_out_EasingV"},
	}

#SHADER_CODE	
  float f_posbackout = 1.0 - in_Progress;
  float position_out_EasingV = 1.0 - (pow(f_posbackout, 3.0) - f_posbackout * sin(f_posbackout * 3.141592653589793));
#END_CODE
#END_DEFINE

#SHADER_DEFINE PositionBounceOut

	FUNCTION_INPUT = 
	{
		{ EASING_PROGRESS, 		MEDIUM,	FLOAT,	"in_Progress" },
	}
	FUNCTION_OUTPUT =
	{
    { POSITION_EASING_VALUE,           MEDIUM, FLOAT,  "position_out_EasingV"},
	}

#SHADER_CODE	
  const float a_posbout = 4.0 / 11.0;
  const float b_posbout = 8.0 / 11.0;
  const float c_posbout = 9.0 / 10.0;

  const float ca_posbout = 4356.0 / 361.0;
  const float cb_posbout = 35442.0 / 1805.0;
  const float cc_posbout = 16061.0 / 1805.0;

  float t2_posbout = in_Progress * in_Progress;
  
  float position_out_EasingV = 0.0;
  if (in_Progress < a_posbout)
  {
    position_out_EasingV = 7.5625 * t2_posbout;
  }
  else
  {
    if (in_Progress < b_posbout)
    {
      position_out_EasingV = 9.075 * t2_posbout - 9.9 * in_Progress + 3.4;
    }
    else
    {
      if (in_Progress < c_posbout)
      {
        position_out_EasingV = ca_posbout * t2_posbout - cb_posbout * in_Progress + cc_posbout;
      }
      else
      {
        position_out_EasingV = 10.8 * in_Progress * in_Progress - 20.52 * in_Progress + 10.72;
      }
    }
  }

#END_CODE
#END_DEFINE

#SHADER_DEFINE PositionBounceIn

	FUNCTION_INPUT = 
	{
		{ EASING_PROGRESS, 		MEDIUM,	FLOAT,	"in_Progress" },
	}
	FUNCTION_OUTPUT =
	{
    { POSITION_EASING_VALUE,           MEDIUM, FLOAT,  "position_out_EasingV"},
	}

#SHADER_CODE	

  float t_posbin = 1.0 - in_Progress;
  const float a_posbin = 4.0 / 11.0;
  const float b_posbin = 8.0 / 11.0;
  const float c_posbin = 9.0 / 10.0;

  const float ca_posbin = 4356.0 / 361.0;
  const float cb_posbin = 35442.0 / 1805.0;
  const float cc_posbin = 16061.0 / 1805.0;

  float t2_posbin = t_posbin * t_posbin;
  
  float position_out_EasingV = 0.0;
  if (t_posbin < a_posbin)
  {
    position_out_EasingV = 7.5625 * t2_posbin;
  }
  else
  {
    if (t_posbin < b_posbin)
    {
      position_out_EasingV = 9.075 * t2_posbin - 9.9 * t_posbin + 3.4;
    }
    else
    {
      if (t_posbin < c_posbin)
      {
        position_out_EasingV = ca_posbin * t2_posbin - cb_posbin * t_posbin + cc_posbin;
      }
      else
      {
        position_out_EasingV = 10.8 * t_posbin * t_posbin - 20.52 * t_posbin + 10.72;
      }
    }
  }
  position_out_EasingV = 1.0 - position_out_EasingV;

#END_CODE
#END_DEFINE



