
#SHADER_DEFINE BaseVideoVertex

	FUNCTION_INPUT = 
	{
		{ ATTRIBUTE_POSITION, 		HIGH,	VEC4,	"in_Position" },
        { ATTRIBUTE_COORDNATE0,			MEDIUM,	VEC2,		"in_Coordinate" },
        { DEVICE_COORDINATE_Y_FLIP,    MEDIUM, FLOAT,       "in_yflip" },
	}
	FUNCTION_OUTPUT =
	{
        { ATTRIBUTE_COORDNATE0,		MEDIUM,	VEC2,		"Out_Coordinate" },
	}

#SHADER_CODE
    vec4 scale = vec4(
		1.0f,
		in_yflip,
		1.0f,
		1.0f);
    gl_Position = scale*in_Position;

    mediump vec2 Out_Coordinate = in_Coordinate;
#END_CODE
#END_DEFINE


#SHADER_DEFINE BaseVideoFragment

	FUNCTION_INPUT = 
	{
        { TEXTURE_DIFFUSE,		NONE,	TEXTURE2D,	"in_DiffuseTexture" },
        { ATTRIBUTE_COORDNATE0,	MEDIUM,	VEC2,		"in_Coordinate" },
        { TEXTURE_LOCATION, MEDIUM, VEC2, "in_TextureLocation" },
        { TEXTURE_SPLIT_INFO, MEDIUM, VEC2, "in_TextureSplitInfo"},
	}
  FUNCTION_OUTPUT =
  {
  }
#SHADER_CODE

    mediump float rows = in_TextureSplitInfo.x;
    mediump float cols = in_TextureSplitInfo.y;
    mediump float xLoc = in_TextureLocation.x;
    mediump float yLoc = in_TextureLocation.y;

    mediump float coordinate_v = xLoc / rows + in_Coordinate.y / rows;
    mediump float coordinate_u = yLoc / cols + in_Coordinate.x / cols;

    gl_FragColor = texture2D(in_DiffuseTexture,vec2(coordinate_u,coordinate_v));
#END_CODE
#END_DEFINE



