local apolloengine = require "apolloengine"
local apollonode = require "apolloutility.apollonode"
local videodecet = require "videodecet"
local venuscore = require "venuscore"
local mathfunction = require "mathfunction"
local historicalframe = require "facecute.haircolor.historicalframe"
local haircolordefined = require "facecute.haircolor.haircolordefined"
local defined = require "apolloutility.defiend"
local renderqueue = require "apolloutility.renderqueue"

local historicalrgbmain = {};
historicalrgbmain.rgbscale = 4.0;

function historicalrgbmain:Initialize(camera,config)
  local maincamera = renderqueue:GetCamera("Output");
  local sequnce = maincamera:GetSequence();
  historicalframe:Initialize("Output",3,-10,1,defined.blit_material_path,false);

  self.post = maincamera:CreatePostEffect();
  self.lpath = venuscore.IFileSystem:PathAssembly("docs:filter/historicalrgb/filter/resource");
  self.post:CreateResource(self.lpath.."/historicalrgb.lua"); 
  self.post:RegisterParameter("TEXTURE_RED", self.lpath.."/material/historicalrgb.material");
  self.post:RegisterParameter("TEXTURE_GREEN", self.lpath.."/material/historicalrgb.material");
  self.post:RegisterParameter("TEXTURE_BLUE", self.lpath.."/material/historicalrgb.material");
  self.post:RegisterParameter("UNIFORM_RGBSCALE", self.lpath.."/material/historicalrgb.material");
  
  self.post:UNIFORM_RGBSCALE(mathfunction.vector1(self.rgbscale));
  self.post:Disable();
  self.enable = false;
  
  self.time = 0;
end

function historicalrgbmain:Update(def)
  if self.post then
    self.time = self.time + 1;
	if self.time < 3 then
		return;
	end
	self.time = 3;	
    --historicalframe:SetVideoTexture(renderqueue:GetTexture(renderqueue:GetLink(renderqueue.CAMERA_LAYER_ZERO)));
    historicalframe:SetShow(true);
    self.texrgb, self.mask = historicalframe:Update();
    if self.texrgb == nil then
      return;
    end
  
    self.post:TEXTURE_RED(self.texrgb[3]);
    self.post:TEXTURE_GREEN(self.texrgb[2]);
    self.post:TEXTURE_BLUE(self.texrgb[1]);
  
    if self.texrgb ~= nil and self.enable == false then
      self.post:Enable();
      self.enable = true;
    end
  end
end

function historicalrgbmain:OnRecordStart()
  self.texrgb = nil;
  self.mask = nil;
  self.enable = false;
  self.post:Disable();
  self.time = 0;
end

function historicalrgbmain:Exit()
  self.post:Disable();
  local maincamera = renderqueue:GetCamera("Output");
  maincamera:DeletePostEffect(self.post);
  self.texrgb = nil;
  self.mask = nil;
  self.post = nil;
  historicalframe:Clear();
  self.time = 0;
end

return historicalrgbmain;


