 local apolloengine = require "apolloengine"
local apollonode = require "apolloutility.apollonode"
local videodecet = require "videodecet"
local mathfunction = require "mathfunction"
local define = require "videodecet.defined"
local math = require "math"
local venuscore = require "venuscore"

local spiltscreenmain = {};

spiltscreenmain.time = 0;

--二分屏中心
spiltscreenmain.center2 = mathfunction.vector2(0.5,0.5);
--三分屏中心
spiltscreenmain.center3 = mathfunction.vector2(0.5,0.5);
--右屏饱和度
spiltscreenmain.saturation = mathfunction.vector1(0.75);
--右屏亮度
spiltscreenmain.luminance = mathfunction.vector1(0.85);

spiltscreenmain.post = {};
spiltscreenmain.count = 0;
spiltscreenmain.facedetect = false;
--spiltscreenmain.facedetect = true;


function spiltscreenmain:Initialize(camera,config)
  self.maincamera = camera;
  self.lpath = venuscore.IFileSystem:PathAssembly("docs:filter/halfcolor/filter/resource");
  
  self.post[1] = self.maincamera:CreatePostEffect();
  self.post[1]:CreateResource(self.lpath.."/halfcolor.lua"); 
  self.post[1]:RegisterParameter("UNIFORM_CENTER", self.lpath.."/material/halfcolor.material");
  self.post[1]:RegisterParameter("UNIFORM_SPILT", self.lpath.."/material/halfcolor.material");
  self.post[1]:RegisterParameter("UNIFORM_SATURATION", self.lpath.."/material/halfcolor.material");
  self.post[1]:RegisterParameter("UNIFORM_LUMINANCE", self.lpath.."/material/halfcolor.material");
  
  self.post[1]:UNIFORM_CENTER(self.center2);
  self.post[1]:UNIFORM_SPILT(mathfunction.vector1(1.0));
  self.post[1]:UNIFORM_SATURATION(self.saturation);
  self.post[1]:UNIFORM_LUMINANCE(self.luminance);
  
  --self.maincamera:AttachPostEffect(self.post[1]);
  
  videodecet:AddNewframeCallback(self:NewframeCallback());
end
function spiltscreenmain:NewframeCallback()
  self.newframecallback = function()   
    local faces = videodecet:GetFaces();
    if #faces == 0 then
      if self.facedetect == true then
        self.facedetect = false;
        self.count = self.count + 1;
      
        if self.count == 1 then
          self.post[1]:UNIFORM_SPILT(mathfunction.vector1(2.0));
        elseif self.count == 2 then
          self.post[1]:UNIFORM_SPILT(mathfunction.vector1(3.0));
        else
          self.post[1]:UNIFORM_SPILT(mathfunction.vector1(1.0));
          self.count = 0;
        end
      
      end
    else
      self.facedetect = true;
    end  
  end
  return self.newframecallback;
end
      
function spiltscreenmain:Update(def)
end

function spiltscreenmain:OnRecordStart()
  self.post[1]:UNIFORM_SPILT(mathfunction.vector1(1.0));
  self.count = 0;
  self.facedetect = false;
end

function spiltscreenmain:Exit()  
  self.post[1]:Disable();
  self.maincamera:DeletePostEffect(self.post[1]);
  self.post = {};
end

return spiltscreenmain;