
#DEFPARAMS
TEXTURE_DIFFUSE = {"TEXTURE_DIFFUSE", TEXTURE2D, "white" },
#END

#DEFTAG
ShaderName = "haircolor_boundingbox"
RenderQueue = "Transparent"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, SRC_ALPHA, ONE_MINUS_SRC_ALPHA, ONE, ONE }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = {STENCIL_OFF}

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 in_Position : POSITION;
	float in_Coordinate : TEXCOORD0;
};

struct v2f
{
	float2 out_Coordinate : TEXCOORD0;
	float4 screenPosition : TEXCOORD1;
	float4 vertex : SV_POSITION;
};

v2f vert(appdata v)
{
	v2f o;

	float4x4 in_ViewPorj = CAMERA_VIEWPROJ;
	float4 in_Position = v.in_Position;
	half2 in_Coordinate = v.in_Coordinate;

	float4 in_ScreenPosition  = mul(in_Position, in_ViewPorj);
	
	o.screenPosition = in_ScreenPosition;
	o.out_Coordinate = in_Coordinate;
	o.vertex = UniformNDC(in_ScreenPosition);
	return o;
}

Texture2D TEXTURE_DIFFUSE;
SamplerState TEXTURE_DIFFUSE_Sampler;

void frag(in v2f i, out float4 outColr : SV_Target0)
{
	float4 TextureColor = TEXTURE_DIFFUSE.Sample( TEXTURE_DIFFUSE_Sampler, i.out_Coordinate.xy);
	outColr = float4(TextureColor.r * TextureColor.a,TextureColor.g * TextureColor.a,TextureColor.b * TextureColor.a,1.0);
}

ENDCG
#END
