local libvenuscore = require "libvenuscore"
local apolloengine = require "apolloengine"
local filelfs = require "window.editor.widget.assets.fileutility"
local CommandBase = require "window.editor.command.command"
local ContentManager = require "apolloengine.content.contentmanager"
local DeleteTransitionCommand = CommandBase:extend("DeleteTransitionCommand");

function DeleteTransitionCommand:new(uuid, delete_transitionId)
    DeleteTransitionCommand.super.new(self);
    self._uuid = uuid;
    self._deleteId = delete_transitionId;
end

function DeleteTransitionCommand:DoIt()
    self:BeginCmd();
    if self._uuid then
      local ani = self:GetContent(self._uuid); --基类中方法：可以根据id返回对象
      if ani and self._deleteId ~= nil then
        ani:RemoveTransition(0, self._deleteId);
      end
    end
    self:EndCmd();
end

function DeleteTransitionCommand:Undo()
    self:BeginCmd();
    self:EndCmd();
end

return DeleteTransitionCommand;