--
-- Blue RTTI 定义每种类型的 默认值和字面值 生成的方法; 默认值和字面值不一定是RTTI的对象,只是一个metadata 相当于单参数构造函数
--
local Types = require "venuscore.rtti.types"
local BD = require "bluecore.bluedefined"
local ClassInfo = require "bluecore.core.class_info"
local RM = require "venuscore.rtti.rttimanager"
local vc = require "venuscore"
local BlueRtti = {}

BlueRtti._ClassPathEd = {}  -- 编辑器旧素材兼容 { contentPath : clsId }
BlueRtti._BlueRttiMap = {}  -- 端内没有动态创建的类 {default = defaultFtn literal = literalFtn, dup = dupFtn, create = createFtn, typeInfo = typeInfo, reflect = reflectFtn}
if _KRATOSEDITOR then
  BlueRtti._BlueprintTypeMap = {}   -- {  clsId : BlueprintType:extend }
  BlueRtti._ClassDeclaredMap = { }  -- {  clsId : ClassInfo() }
else
  BlueRtti._BlueprintTypeMap =  nil
  BlueRtti._ClassDeclaredMap =  nil
end

local function _Found(rtti)
  local rttiName = BlueRtti.GetRealTypeName(rtti)
  local info = BlueRtti._BlueRttiMap[rttiName]
  local r = rtti
  while info == nil do
    local s = type(r)
    if s == 'table' then -- metatable
      r = r:RTTI()       -- blueprintClass 暂时不考虑继承
    elseif s == 'userdata' then
      WARNING(r:GetTypeName()..": This Class BastType not ready, use default")
      return BlueRtti._DefaultCpp;
      --r = r:GetBase()    -- RttiWrapper FIXME(hhl) 增加C++类 目前不用
    end
    if r == nil then
      break;
    else
      rttiName = BlueRtti.GetRealTypeName(r)
      info = BlueRtti._BlueRttiMap[rttiName]
    end
  end
  assert(info ~= nil,"rtti not found")
  return info ;
end


-- 特殊类型/特殊值 都是luaObject对象
local _SpecValueMap = {
  [Types.NotNullType] = {}, -- replace by nil
  [Types.NoneType]    = {}, -- deprecated
  [Types.AnyType]     = {},
  [Types.AnyArrayType] = {},
}


local function _SpecValue(value)
  if type(value) == 'table' and value.GetTypeName then
    local rtti = value:RTTI();
    if _SpecValueMap[rtti] then
      return rtti();
    end
  end
end

-- 蓝图只有一维数组
local function _IsArray(cb, rtti, rhs, ...)
  if rtti.isArray == nil then
    ERROR("isArray empty ");
  end
  if rtti:isArray() then
    local rttiBase = rtti:GetElementType()
    local array = {}
    if rhs ~= nil then
      for _, _obj in  pairs(rhs) do
        local obj = cb(rttiBase, _obj, ...)
        table.insert(array, obj);
      end
    end
    return array;
  end
end

function BlueRtti.GetDefault(rtti)
  return _IsArray(BlueRtti.GetDefault, rtti,nil) or _Found(rtti).default(rtti)
end

function BlueRtti.GetLiteral(rtti, default)
  return _SpecValue(default) or _IsArray(BlueRtti.GetLiteral, rtti, default) or _Found(rtti).literal(rtti, default)
end

-- 复制字面值或者默认值  注意不一定是值接复制对应RTTI的对象
function BlueRtti.Dup(rtti, rhs)
  return _SpecValue(rhs) or _IsArray(BlueRtti.Dup, rtti, rhs) or _Found(rtti).dup(rtti, rhs)
end

function BlueRtti.Create(rtti, metadata, ...)
  return _IsArray(BlueRtti.Create, rtti, metadata, ...) or _Found(rtti).create(rtti, metadata, ...)
end

function BlueRtti.GetTypeInfo(rtti)
  local found = _Found(rtti)
  if found ~= nil then
    return found.typeInfo
  end
  return nil
end


-- 只要给定的classId/rttiName是个蓝图类 就要返回一个BlueprintType,用于引脚匹配和反射面板
function BlueRtti.GetRttiByClsId(classId)
    -- rttiName is displayClassName
  if classId == nil then
    error("class id is nil");
  end
  local clsNameIdx = string.find(classId, BD.REGULAR);
  if clsNameIdx then --  Blue_ is signature of BlueprintClass
    local rtti
    if _KRATOSEDITOR then
      rtti = BlueRtti._BlueprintTypeMap[classId]; -- rtti is extend BlueprintType
      if rtti == nil  then
        WARNING("class not register, extend one "..tostring(classId))
        -- 如果没有在表格中 可能是还没有注册 或者场景根本没有这个类 prefab迁移到其他场景中
        -- 如果场景中根本没有这个类,那么就 不会在_BlueRttiMap中 不能创建这种类型的 自定义变量 或者函数参数
        -- 对于已经存在的,还是保留,编译出错(无法连接 或者引用错误)
        rtti = Types.BlueprintType:extend();
        rtti:InitClassInfo(classId, classId); -- classInfo注册时候更新名字
        BlueRtti._BlueprintTypeMap[classId] = rtti
      end
    else
      rtti = Types.BlueprintType:extend();
      rtti:InitClassInfo(classId, classId);
    end
    return rtti ;
  end

end

function BlueRtti.SignatureClassIdEd(uuid)
  local clsId = tostring(uuid)
  local str  = string.match(clsId, BD.SIGNATURE)
  if str == nil then
    return BD.SIGNATURE..clsId;
  else
    ERROR("SignatureClassId twice:"..tostring(uuid));
  end
end

-- 加入到Blue RTTI系统 用于蓝图间通信(蓝图类型变量 成员函数调用 事件调度器等)
-- 不加入RTTIManage考虑的是会动态增加和删除
-- 注册蓝图类
function BlueRtti.RegisterClassAddRef(blueprint, node)

  if not _KRATOSEDITOR then
    return ; -- 端内移除ClassInfo
  end

  ERROR("RegisterClassAddRef ... "..tostring(blueprint:GetClassName()));

  local clsId = blueprint:GetClassId() ;

  if clsId == nil then
    -- editor 兼容旧素材 (在game和scene同一个blueprint要有同一个clsID即可)
    local cpath = node:GetContentPath()
    clsId = BlueRtti._ClassPathEd[cpath] ;
    if clsId == nil then
      local CM = require "apolloengine.content.contentmanager"
      clsId = BlueRtti.SignatureClassIdEd(CM:GenerateUUID());
      BlueRtti._ClassPathEd[cpath] = clsId;
    end
    local nodeName = node.Name;
    local className = BD.BPCLASS_PREFIX..tostring(nodeName);
    blueprint:SetClassID(clsId, className);
  end

  local isNewClass = false
  local clsInfo = BlueRtti._ClassDeclaredMap[clsId]
  if clsInfo ~= nil then
    WARNING("RegisterBluePrintClass, class declared before");
  else
    -- 蓝图类的声明 ClassInfo (成员函数的声明)
    clsInfo = ClassInfo();
    clsInfo:RegisterBlueprint(blueprint)
    BlueRtti._ClassDeclaredMap[clsId] = clsInfo
    isNewClass = true
  end

  if _KRATOSEDITOR then
    -- 端内 同一个classId 会有不同的blueprintType 判断blueprintType是否一致使用isType, 端内不用同步
    local blueprintType = BlueRtti._BlueprintTypeMap[clsId]
    if blueprintType == nil then
      -- 增加蓝图类类型 BlueprintType
      blueprintType = Types.BlueprintType:extend();
      blueprintType:InitClassInfo(clsId, blueprint:GetClassName());
      BlueRtti._BlueprintTypeMap[clsId] = blueprintType;
    else
      -- 以prefab的信息为准 目前先解析json文件中的名字 如果没有就用blueprint的
      if isNewClass then
        blueprintType:UpdateDisplayName(blueprint:GetClassName());
      end
    end

    -- 端内直接走blueprintType这个BaseType的兜底处理 生成默认值/字面值等
    local realRttiName = BlueRtti.GetRealTypeName(blueprintType);
    if BlueRtti._BlueRttiMap[realRttiName] == nil then
      local baseInfo = BlueRtti._BlueRttiMap[Types.BlueprintType:GetTypeName()];
      BlueRtti.Register(blueprintType, baseInfo.default, baseInfo.literal, baseInfo.dup, baseInfo.create, blueprintType);
    end
  else
    -- for mobile, we use blueprint to strongly reference ClassInfo
    blueprint._myInfo = clsInfo
  end

  clsInfo:AddRef();

  WARNING(">>   RegisterBluePrintClass: "..tostring(blueprint:GetClassName())..","..tostring(clsId)..", refCnt="..tostring(clsInfo:GetRef()))

end

---- 给 指定的蓝图类 注册自定义事件 remove at custom_event_node
function BlueRtti.AppendCustomEventToClassInfoEd(blueprint, eventNode)
  local clsId = blueprint:GetClassId() ;
  local classInfo = BlueRtti._ClassDeclaredMap[clsId]
  if classInfo == nil then error("blueprintClass not found "..tostring(clsId)) end
  classInfo:AppendCustomEvent(eventNode);
end


---- 给 指定的蓝图类 注册事件分发器 remove at blue_event_dispatcher
function BlueRtti.AppendEventDispatcherToClassInfo(blueprint, dispatcher)
  local clsId = blueprint:GetClassId() ;
  local classInfo = BlueRtti._ClassDeclaredMap[clsId]
  if classInfo == nil then error("blueprintClass not found "..tostring(clsId)) end
  classInfo:AppendEventDispatcher(dispatcher);
end


function BlueRtti.AppendBlueFunctionToClassInfo(blueprint, blueFunction)
  local clsId = blueprint:GetClassId() ;
  local classInfo = BlueRtti._ClassDeclaredMap[clsId]
  if classInfo == nil then error("blueprintClass not found "..tostring(clsId)) end
  classInfo:AppendBlueFunction(blueFunction);
end


-- 注册prefab类 这个接口不能有重复的
function BlueRtti.RegisterBluePrintClassInfoEd(clsInfo)

  local clsId = clsInfo:GetClassId();
  assert( BlueRtti._ClassDeclaredMap[clsId] == nil, "classInfo register twice")

  -- BlueprintType注册
  local blueprintType = BlueRtti._BlueprintTypeMap[clsId]
  if blueprintType == nil then
    -- 增加蓝图类类型 BlueprintType
    blueprintType = Types.BlueprintType:extend();
    blueprintType:InitClassInfo(clsId, clsInfo:GetClassName());
    BlueRtti._BlueprintTypeMap[clsId] = blueprintType;
  else
    blueprintType:UpdateDisplayName(clsInfo:GetClassName());
  end

  local baseInfo = BlueRtti._BlueRttiMap[Types.BlueprintType:GetTypeName()];
  BlueRtti.Register(blueprintType, baseInfo.default, baseInfo.literal, baseInfo.dup, baseInfo.create, blueprintType);

  -- ClassInfo注册
  BlueRtti._ClassDeclaredMap[clsId] = clsInfo
end

-- 清理当前场景--所有的蓝图类信息--切换场景/素材使用 通过BlueUtilityEd使用
function BlueRtti.ClearClassEd()

  WARNING("----------------------------------");
  WARNING("------       ClearClassEd     ------");
  WARNING("----------------------------------");
  if _KRATOSEDITOR then
    for clsId, type in pairs(BlueRtti._BlueprintTypeMap) do
      WARNING("ClearClass clsId: "..tostring(clsId).." "..tostring(BlueRtti._BlueRttiMap[clsId]));
      if BlueRtti._BlueRttiMap[clsId] ~= nil then
        -- only for editor, RegisterClassAddRef will NOT create BlueRttiMap for blueprintClass in mobile
        WARNING("ClearClass _BlueRttiMap[clsId]: "..BlueRtti._BlueRttiMap[clsId].rtti._ClassId);
        BlueRtti._BlueRttiMap[clsId] = nil
      end
    end
    -- 多场景同时加载 需要处理这个
    BlueRtti._BlueprintTypeMap = {}
    BlueRtti._ClassDeclaredMap = {}
  else
    -- 端内只是做lua leak检查(有打印都是错误)
    if BlueRtti._BlueprintTypeMap then
      for clsId, type in pairs(BlueRtti._BlueprintTypeMap) do
        ERROR("ClearClass _BlueprintTypeMap : "..tostring(clsId));
      end
    end
    if BlueRtti._ClassDeclaredMap then
      for clsId, clsInfo in pairs(BlueRtti._ClassDeclaredMap) do
        ERROR("ClearClass  _ClassDeclaredMap "..tostring(clsInfo._clsName)..","..tostring(clsInfo._clsId));
      end
    end
  end


end

function BlueRtti.GetRtti(rttiName, isArray)

  local rtti  = BlueRtti.GetRttiByClsId(rttiName)

  if _KRATOSEDITOR and rtti then WARNING(" BlueRtti.GetRtti, " ..tostring(rttiName).." is BlueprintClass");  end

  rtti = rtti or RM:GetRttiByName(rttiName);

  assert(rtti, "[_RedefineDefault] rtti not found "..tostring(rttiName))

  local rttiOfArray = nil
  if isArray then
    if rtti == Types.AnyType then
      --Types.AnyArrayType:extend(Types.AnyType) 会多一层Types.AnyArrayType类
      rttiOfArray = Types.AnyArrayType
    else
      rttiOfArray = Types.AnyArrayType:extend(rtti);
    end
  end
  return rtti, rttiOfArray
end

-- 取消引用 蓝图实例销毁或者变类(perfab实例拖到asset 相当于原来的蓝图实例销毁)
function  BlueRtti.UnRefBluePrintClass(blueprint)
  local clsId = blueprint:GetClassId() ;
  if clsId == nil then -- blueprint是bluefunction或者bluescene
    WARNING("UnRefBluePrintClass, not blueprintClass");
    return
  end
  local clsInfo = BlueRtti._ClassDeclaredMap[clsId];
  clsInfo:UnRef();
end

function BlueRtti.DeleteClassByClsIdEd(clsId)
  local clsInfo = BlueRtti._ClassDeclaredMap[clsId]
  if clsInfo:GetRef() > 0 then
    error("delete ClassInfo with reference? prefab check pass?")
    -- 删除类的时候 发现还有引用 说明删除prefab文件时候检查prefab实例有漏洞
  end

  if clsInfo ~= nil then
    clsInfo:DeleteClassInfoEd();
  else
    WARNING("DeleteClassByInfoEd ClassInfo deleted before yet")
  end

  BlueRtti._ClassDeclaredMap[clsId] = nil -- classInfo
  BlueRtti._BlueprintTypeMap[clsId] = nil; -- blueprintType
  BlueRtti._BlueRttiMap[clsId] = nil; -- blueprintType reflectInfo

end

function BlueRtti.GetClassesEd()
  return BlueRtti._ClassDeclaredMap;
end

function BlueRtti.GetClassesByIdEd(clsId)
  return BlueRtti._ClassDeclaredMap[clsId]; -- 目前返回的是blueprint
end

-- call on _OnDeserialize
function BlueRtti.ClearPrefabClassEd(blueprint)
  local clsId = blueprint:GetClassId()
  local classInfo = BlueRtti.GetClassesByIdEd(clsId)
  local metaFileFullPath = classInfo:ClearPrefabClass(blueprint)

  -- ClassInfo的依赖建立是在 _OnDeserializePost e.g func_call_node/bind_event_dispatcher
  BlueRtti._ClassDeclaredMap[clsId] = nil
  BlueRtti._BlueRttiMap[clsId] = nil -- clsId is rttiName for blueprintClass
  --BlueRtti._BlueprintTypeMap[clsId] = nil
  --BlueRtti._ClassPath = {}

  return metaFileFullPath;
end

function BlueRtti.DumpClassDeclaredMapEd()
  ERROR("---------------- DumpClassDeclaredMap -------------- "  );
  for clsId, clsInfo in pairs(BlueRtti._ClassDeclaredMap) do
    ERROR("----- Class: "..tostring(clsId) .. " ---- , reference: "..tostring(clsInfo:GetRef()));
    clsInfo:Dump();
  end
end

-- 蓝图类类名是类ID(不是类名字) 也不是"BlueprintType"(rtti = extend BlueprintType)
function BlueRtti.GetRealTypeName(rtti)
  local rttiName = rtti:GetTypeName() ;
  rttiName = rtti.GetClassId and rtti:GetClassId() or rttiName
  return rttiName ;
end

-- defaultFtn 该类型的默认metadata
-- literalFtn 该类型如果从metadata创建字面值(主要考虑meta是复杂类型的拷贝)
-- dupFtn     metadata的拷贝
-- createFtn  该类型根据metadata/一个参数创建实例  unreal中Material/Texture都是选择文件
-- typeInfo   右侧反射面版 比如BaseType等
function BlueRtti.Register(rtti, defaultFtn, literalFtn, dupFtn, createFtn, typeInfo)
  local rttiName = BlueRtti.GetRealTypeName(rtti)
  BlueRtti.RegisterWithName(rttiName, rtti, defaultFtn, literalFtn, dupFtn, createFtn, typeInfo);
end

-- 需要特殊指名类型名字 而不是rtti:GetTypeName
function BlueRtti.RegisterWithName(rttiName, rtti, defaultFtn, literalFtn, dupFtn, createFtn, typeInfo)

  WARNING("BlueRtti.Register rtti: "..tostring(rttiName).." typeInfo "..tostring(typeInfo))
  assert(BlueRtti._BlueRttiMap[rttiName] == nil,
          "BlueRtti.Register duplicate "..tostring(rttiName));

  BlueRtti._BlueRttiMap[rttiName] = {
    default = defaultFtn,
    literal = literalFtn,
    dup     = dupFtn,
    create  = createFtn,
    typeInfo = typeInfo,
    rtti = rtti,
  }

end

function BlueRtti.RegisterDefaultCpp(defaultFtn, literalFtn, dupFtn, createFtn, typeInfo)
  assert(BlueRtti._DefaultCpp == nil , "RegisterDefaultCpp twice");
  BlueRtti._DefaultCpp = {
    default = defaultFtn,
    literal = literalFtn,
    dup     = dupFtn,
    create  = createFtn,
    typeInfo = typeInfo,
    rtti = nil
  }
end

-- 基于场景的蓝图类型系统  ClassId作为索引
--function BlueRtti.GetSceneMap(_scene)
--  local sceneRttiMap  = _StaticRttiTbl[_scene]
--  if sceneRttiMap ~= nil then
--    sceneRttiMap = {}
--    local metatable = {}
--    metatable.__index = BlueRtti._BlueRttiMap
--    setmetatable(sceneRttiMap, metatable);
--    _StaticRttiTbl[_scene] = sceneRttiMap
--  end
--  return sceneRttiMap
--end

-- 蓝图节点引脚的放射面板
function BlueRtti.RegisterInputReflect(rtti, reflector)
  local rttiName = BlueRtti.GetRealTypeName(rtti)
  assert(BlueRtti._BlueRttiMap[rttiName] ~= nil, rttiName.." is not registered");
  assert(BlueRtti._BlueRttiMap[rttiName].reflect == nil , rttiName.." registered twice");
  BlueRtti._BlueRttiMap[rttiName].reflect = reflector
end

function  BlueRtti.RegisterInputReflects(rttiNameFtnsTbl)
  for rttiName, reflector in pairs(rttiNameFtnsTbl) do
    BlueRtti._BlueRttiMap[rttiName].reflect = reflector
  end
end

function BlueRtti.GetMap()
  ERROR("return map");
  return  BlueRtti._BlueRttiMap;
end

-- 获取所有 可以创建引脚 的类型列表
function BlueRtti.GetComboData()
  local rttiCombo = {} -- 用在反射面板上ComboType格式
  for rttiName, info in pairs(BlueRtti._BlueRttiMap) do
    if info.typeInfo ~= nil then
      local isClass = info.rtti and info.rtti.GetClassId;
      if isClass then
        if not info.rtti:IsSceneClass() then -- 场景蓝图类不显示
          local rtti = info.rtti
          local dispName = rtti:GetDisplayName() -- FIXME(hhl) 改成GetTypeName 风险??
          local clsId = rtti:GetClassId();
          table.insert(rttiCombo, {key = dispName, value = clsId})
        end
      else
        table.insert(rttiCombo, {key = rttiName, value = rttiName})
      end
    end -- 使用类型的显示名字 替换 真实名字
  end

  -- 在编辑模式下 会进行排序 方便下拉列表
  if _KRATOSEDITOR then
    table.sort(rttiCombo,function(a,b)
      return a.key < b.key
    end)
  end
  return rttiCombo
end


function BlueRtti.GetComboDataOfClass()
  local rttiCombo = {} -- 用在引脚反射的ComboType格式
  for rttiName, info in pairs(BlueRtti._BlueRttiMap) do
    if info.typeInfo ~= nil then
      local isClass = info.rtti and info.rtti.GetClassId;
      if isClass then
        if not info.rtti:IsSceneClass() then
          local rtti = info.rtti
          local dispName = rtti:GetDisplayName()
          local clsId = rtti:GetClassId();
          if rttiCombo[clsId] ~= nil then
            error("Class Duplicate Defined"..tostring(dispName)..","..tostring(clsId));
          end
          rttiCombo[clsId] = dispName
        end
      end
    end
  end

  if _KRATOSEDITOR then
    table.sort(rttiCombo,function(a,b)
      return a < b
    end)
  end
  return rttiCombo
end


-- 蓝图节点引脚显示
function BlueRtti.GetReflector(rtti)
  local rttiName = BlueRtti.GetRealTypeName(rtti)

  local info = BlueRtti._BlueRttiMap[rttiName]
  local r = rtti;
  while info == nil or info.reflect == nil do
    local s = type(r) -- 这样来判断是C++类型还是Lua类型 而不是通过 object.isLua这样
    if s == 'table' then -- metatable
      r = r:RTTI()
    elseif s == 'userdata' then
      r = r:GetBase()    -- RttiWrapper
    end
    if r == nil then
      break;
    else
      rttiName = BlueRtti.GetRealTypeName(r)
      info = BlueRtti._BlueRttiMap[rttiName]
    end
  end

  if info == nil then
    error("rtti info not found " .. tostring(rttiName))
  end
  if info.reflect == nil then
    error("reflector not found " .. tostring(rttiName))
  end
  return info.reflect;
end

-- 加载/注册内置的类型
local func,errorstr = loadfile(vc.IFileSystem:PathAssembly("comm:script/bluecore/core/_blue_rtti_default.lua"));
if not errorstr then
  func(BlueRtti);
else
  ERROR("loadfile _blue_rtti_default.lua fail ");
end

return BlueRtti;
