local BlueNode = require "bluecore.bluenode"
local EventDispatcher = require "bluecore.eventdispatcher"
local BlueDefined = require "bluecore.bluedefined"
local apolloengine = require "apolloengine"
local BlueSelf = require "bluecore.blueself"
local Types = require "venuscore.rtti.types"
local PhotoUploadResponse = BlueNode:extend();

function PhotoUploadResponse:new(...)
  PhotoUploadResponse.super.new(self, ...);
end


--func 把执行流函数地址以及调用者本身丢进去
function PhotoUploadResponse:RegisterTriggerFunc(func, bluePrintSelf)
  self:_GetInput();
  EventDispatcher:RegisterCallback(self.inputArgs[1]._hostID, BlueDefined.Event.PhotoUploadResponse, func, bluePrintSelf);
end


PhotoUploadResponse:RegisterInput(1, Types.ScriptInsRefType, "photo_upload", "监听相册上传是否接收到新图片", Types.NotNullType());
PhotoUploadResponse:RegisterExecOutput(1, "OnTrigger", "执行");

PhotoUploadResponse:SetFunctionName("PhotoUploadResponse");

PhotoUploadResponse:SetFunctionType(BlueDefined.EVENT_FUNCTION_NODE);

PhotoUploadResponse:SetEventType(BlueDefined.EventType.RegisterCallback);

return PhotoUploadResponse;

