local BlueNode = require "bluecore.bluenode"
local BD = require "bluecore.bluedefined"
local Types = require "venuscore.rtti.types"

local Asin = BlueNode:extend();

---- 游戏运行模式
function Asin:new(...)
  Asin.super.new(self, ...)
end

function Asin:_OnUpdate(args)

  local res = math.asin(args[1]);
  return res, res*180.0/math.pi;

end

---- 编辑器模式

Asin:RegisterInput(1, Types.FloatType, "val", "[1]", 0);
Asin:RegisterOutput(1, Types.FloatType, "rad", "反正弦结果(弧度)");
Asin:RegisterOutput(2, Types.FloatType, "angle", "反正弦结果(角度)");
Asin:SetFunctionName("Asin");
Asin:SetFunctionType(BD.STATIC_FUNCTION_NODE);

return Asin;

