local BD = require "bluecore.bluedefined"
local BlueNode = require "bluecore.bluenode"
local Types = require "venuscore.rtti.types"
local mf = require "mathfunction"
local FloatToVector1 = BlueNode:extend();

---- 游戏运行模式
function FloatToVector1:new(...)
  FloatToVector1.super.new(self, ...)
end

function FloatToVector1:_OnUpdate(args)
  if args[1] == nil then
    return mf.vector1(0.0);
  else
    return mf.vector1(args[1]);
  end 
end

---- 编辑器模式
FloatToVector1:RegisterInput(1, Types.FloatType, "float", "浮点数", 1.0);
FloatToVector1:RegisterOutput(1, mf.vector1:RTTI(), "vector1", "一维向量");
FloatToVector1:SetFunctionName("float->vec1");
FloatToVector1:SetFunctionType(BD.STATIC_FUNCTION_NODE);

return FloatToVector1 ;

