


local libvenuscore = require "libvenuscore"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"
local BlueNode = require "bluecore.bluenode"
local BlueSelf = require "bluecore.blueself"
local Types = require "venuscore.rtti.types"
local BlueDefined = require "bluecore.bluedefined"
local BlueUtility = require "bluecore.blueutility"

local CreateRenderTarget = BlueNode:extend();
--Unreal Engine: Create RenderTarget 2D  
--FIXME(hjh):输入fbo路径创建rendertargetentity
--FIXME(hjh):后续要考虑TargetType不同？目前没考虑

---- 游戏运行模式
function CreateRenderTarget:new(...)

  CreateRenderTarget.super.new(self, ...)

end


function CreateRenderTarget:_OnUpdate(args)

  --传入路径 根据路径后缀判断是什么类型纹理 加载对应元数据 
  local path = args[1]
  local entity = BlueUtility:CreateEntity(path, "fbo");	
  local texture = entity:GetAttachment(apolloengine.RenderTargetEntity.TA_COLOR_0);

  --返回RenderTargeiEntity 以及绑定的Texture
  return entity, texture; 

end



---- 编辑器模式
CreateRenderTarget:RegisterInput(1, Types.FboPathType, "Fbo Path", "根据FBO路径创建FBO", "proj:assets/LipStick/FBOs/first.fbo");

CreateRenderTarget:RegisterOutput(1, apolloengine.RenderTargetEntity:RTTI(), "FBO", "输出FBO");
CreateRenderTarget:RegisterOutput(2, apolloengine.TextureEntity:RTTI(), "tex", "fbo绑定的纹理");


CreateRenderTarget:RegisterExecInput(1, "exec", "执行");

CreateRenderTarget:RegisterExecOutput(1, "exec", "执行");

CreateRenderTarget:SetFunctionName("Create RenderTarget");


return CreateRenderTarget ;

